/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.main;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.vtp.framework.engine.ActionDescriptor;
import org.eclipse.vtp.framework.engine.ConfigurationDescriptor;
import org.eclipse.vtp.framework.engine.ObserverDescriptor;
import org.eclipse.vtp.framework.engine.ServiceDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Process;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.eclipse.vtp.framework.spi.IProcessDescriptor;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.eclipse.vtp.framework.spi.IProcessEngineObserver;

public class ProcessEngine
implements IProcessEngine {
    private static final IProcessEngineObserver[] NO_OBSERVERS = new IProcessEngineObserver[0];
    private final IExtensionRegistry extensionRegistry;
    private final Map actionRegistry = new HashMap();
    private final Map configurationRegistry = new HashMap();
    private final Map observerRegistry = new HashMap();
    private final Map serviceRegistry = new HashMap();
    private final Set observers = Collections.synchronizedSet(new HashSet());

    public ProcessEngine(IExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public void registerAction(ActionDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.register(this.actionRegistry, 1, descriptor.getId(), descriptor);
    }

    public void unregisterAction(ActionDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.unregister(this.actionRegistry, 1, descriptor.getId(), descriptor);
    }

    public void registerConfiguration(ConfigurationDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.register(this.configurationRegistry, 2, descriptor.getId(), descriptor);
    }

    public void unregisterConfiguration(ConfigurationDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.unregister(this.configurationRegistry, 2, descriptor.getId(), descriptor);
    }

    public void registerObserver(ObserverDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.register(this.observerRegistry, 3, descriptor.getId(), descriptor);
    }

    public void unregisterObserver(ObserverDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.unregister(this.observerRegistry, 3, descriptor.getId(), descriptor);
    }

    public void registerService(ServiceDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.register(this.serviceRegistry, 4, descriptor.getId(), descriptor);
    }

    public void unregisterService(ServiceDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.unregister(this.serviceRegistry, 4, descriptor.getId(), descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Map registry, int componentType, String identifier, Object descriptor) {
        int eventType = 0;
        ProcessEngine processEngine = this;
        synchronized (processEngine) {
            Object value = registry.get(identifier);
            if (value == null) {
                registry.put(identifier, descriptor);
                eventType = 1;
            } else if (value instanceof LinkedList) {
                ((LinkedList)value).addLast(descriptor);
            } else {
                LinkedList<Object> list = new LinkedList<Object>();
                list.addLast(value);
                list.addLast(descriptor);
                registry.put(identifier, list);
            }
        }
        if (eventType > 0) {
            this.fireEvent(eventType, componentType, identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(Map registry, int componentType, String identifier, Object descriptor) {
        int eventType = 0;
        ProcessEngine processEngine = this;
        synchronized (processEngine) {
            Object value = registry.get(identifier);
            if (value instanceof LinkedList) {
                LinkedList list = (LinkedList)value;
                if (descriptor.equals(list.getFirst())) {
                    eventType = 2;
                }
                if (list.remove(descriptor) && list.size() == 1) {
                    registry.put(identifier, list.removeFirst());
                }
            } else if (descriptor.equals(value)) {
                registry.remove(identifier);
                eventType = 3;
            }
        }
        if (eventType > 0) {
            this.fireEvent(eventType, componentType, identifier);
        }
    }

    private void fireEvent(int eventType, int componentType, String componentIdentifier) {
        IProcessEngineObserver[] array = this.observers.toArray(NO_OBSERVERS);
        int i = 0;
        while (i < array.length) {
            if (this.observers.contains(array[i])) {
                array[i].processEngineUpdated(eventType, componentType, componentIdentifier);
            }
            ++i;
        }
    }

    private void exportDescriptors(Map registry, Object[] results) {
        int i = 0;
        for (Object value : registry.values()) {
            results[i] = value instanceof LinkedList ? ((LinkedList)value).getFirst() : value;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcess createProcess(IProcessDefinition definition, IProcessDescriptor descriptor) throws NullPointerException {
        ActionDescriptor[] actions = null;
        ConfigurationDescriptor[] configurations = null;
        ObserverDescriptor[] observers = null;
        ServiceDescriptor[] services = null;
        ProcessEngine processEngine = this;
        synchronized (processEngine) {
            actions = new ActionDescriptor[this.actionRegistry.size()];
            this.exportDescriptors(this.actionRegistry, actions);
            configurations = new ConfigurationDescriptor[this.configurationRegistry.size()];
            this.exportDescriptors(this.configurationRegistry, configurations);
            observers = new ObserverDescriptor[this.observerRegistry.size()];
            this.exportDescriptors(this.observerRegistry, observers);
            services = new ServiceDescriptor[this.serviceRegistry.size()];
            this.exportDescriptors(this.serviceRegistry, services);
        }
        return new Process(new Blueprint(definition, configurations, actions, observers, services, this.extensionRegistry), descriptor);
    }

    public void addProcessEngineObserver(IProcessEngineObserver observer) throws NullPointerException {
        if (observer == null) {
            throw new NullPointerException("observer");
        }
        this.observers.add(observer);
    }

    public void removeProcessEngineObserver(IProcessEngineObserver observer) throws NullPointerException {
        if (observer == null) {
            throw new NullPointerException("observer");
        }
        this.observers.remove(observer);
    }
}

