/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.osgi.ProcessEngineManager;
import org.eclipse.vtp.framework.engine.support.AbstractReporter;
import org.eclipse.vtp.framework.util.LogTracker;
import org.eclipse.vtp.framework.util.StaticConfigurationAdmin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.w3c.dom.Document;

public class Activator
extends AbstractReporter
implements BundleActivator,
LogListener,
ServiceTrackerCustomizer {
    private static final String[] REPORT_LEVELS = new String[]{"ERROR", "WARN ", "INFO ", "DEBUG"};
    private BundleContext context = null;
    private LogTracker log = null;
    private StaticConfigurationAdmin configurationAdmin = null;
    private ProcessEngineManager processEngineManager = null;
    private ServiceTracker logReader = null;
    private ServiceTracker reporters = null;

    private String buildReport(int severity, String[] categories, String message, Dictionary properties) {
        StringBuffer buffer = new StringBuffer(REPORT_LEVELS[Math.max(0, Math.min(REPORT_LEVELS.length - 1, severity - 1))]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        buffer.append('|').append(calendar.get(1));
        buffer.append('/').append(this.format(calendar.get(2) + 1, 2));
        buffer.append('/').append(this.format(calendar.get(5), 2));
        buffer.append('|').append(this.format(calendar.get(11), 2));
        buffer.append(':').append(this.format(calendar.get(12), 2));
        buffer.append(':').append(this.format(calendar.get(13), 2));
        Object id = properties.remove("process.id");
        if (id != null) {
            buffer.append('|').append("p=").append(id);
        }
        if ((id = properties.remove("session.id")) != null) {
            buffer.append('|').append("s=").append(id);
        }
        if ((id = properties.remove("execution.id")) != null) {
            buffer.append('|').append("e=").append(this.format(id.toString(), 4));
        }
        id = properties.remove("action.id");
        buffer.append('>');
        String prefix = buffer.toString();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(prefix);
        printWriter.print(' ');
        printWriter.print(message);
        if (properties != null) {
            Object t = properties.get("cause");
            if (t instanceof Throwable) {
                properties.remove("cause");
            } else {
                t = null;
            }
            if (t != null) {
                StringWriter causeStringWriter = new StringWriter();
                PrintWriter causePrintWriter = new PrintWriter(causeStringWriter);
                ((Throwable)t).printStackTrace(causePrintWriter);
                causePrintWriter.flush();
                StringTokenizer st = new StringTokenizer(causeStringWriter.toString(), "\r\n");
                while (st.hasMoreTokens()) {
                    printWriter.println();
                    printWriter.print(prefix);
                    printWriter.print('\t');
                    printWriter.print(st.nextToken());
                }
            }
        }
        return stringWriter.toString();
    }

    private String format(int number, int minLength) {
        return this.format(String.valueOf(number), minLength);
    }

    private String format(String number, int minLength) {
        StringBuffer buffer = new StringBuffer(minLength);
        int i = number.length();
        while (i < minLength) {
            buffer.append(0);
            ++i;
        }
        return buffer.append(number).toString();
    }

    public boolean isSeverityEnabled(int severity) {
        return true;
    }

    protected void doReport(int severity, String[] categories, String message, Dictionary properties) {
        Object type;
        Object[] reporters = this.reporters.getServices();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (((Dictionary)properties).get("scope") == null) {
            ((Dictionary)properties).put("scope", "host");
        }
        if ((type = ((Dictionary)properties).get("type")) == null || "report".equalsIgnoreCase(type.toString())) {
            type = "report";
            ((Dictionary)properties).put("type", "report");
            if (((Dictionary)properties).get("time") == null) {
                ((Dictionary)properties).put("time", DateFormat.getDateTimeInstance().format(new Date()));
            }
            if (reporters != null) {
                int i = 0;
                while (i < reporters.length) {
                    ((IReporter)reporters[i]).report(severity, categories, message, properties);
                    ++i;
                }
            }
        } else if (!"log".equalsIgnoreCase(type.toString())) {
            return;
        }
        System.out.println(this.buildReport(severity, categories, message, properties));
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.logReader = new ServiceTracker(context, LogReaderService.class.getName(), (ServiceTrackerCustomizer)this);
        this.logReader.open();
        this.reporters = new ServiceTracker(context, IReporter.class.getName(), null);
        this.reporters.open();
        this.log = new LogTracker(context);
        this.log.open();
        URL staticConfig = context.getBundle().getResource("META-INF/services/" + StaticConfigurationAdmin.class.getName());
        if (staticConfig != null) {
            Document document;
            block16: {
                this.log.log(4, "Loading static configuration...");
                document = null;
                InputStream input = null;
                try {
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setNamespaceAware(false);
                        dbf.setValidating(false);
                        input = staticConfig.openStream();
                        document = dbf.newDocumentBuilder().parse(input);
                        this.log.log(3, "Loaded static configuration from \"" + staticConfig.toExternalForm() + "\".");
                    }
                    catch (Exception e) {
                        this.log.log(2, "Failed to load static configuration: " + e.getMessage(), (Throwable)e);
                        try {
                            if (input != null) {
                                input.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (document != null) {
                this.log.log(4, "Creating configuration admin...");
                this.configurationAdmin = new StaticConfigurationAdmin(context, (LogService)this.log, document.getDocumentElement());
                this.configurationAdmin.start();
                this.log.log(4, "Configuration admin created.");
            }
        }
        this.log.log(4, "Creating process engine manager...");
        this.processEngineManager = new ProcessEngineManager(context, (LogService)this.log, this);
        this.processEngineManager.open();
        this.log.log(4, "Process engine manager created.");
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "host.started");
        this.report(3, "Host Started", report);
    }

    public void stop(BundleContext context) throws Exception {
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "host.stopped");
        this.report(3, "Host Stopped", report);
        try {
            if (this.processEngineManager != null) {
                this.log.log(4, "Releasing process engine manager...");
                this.processEngineManager.close();
            }
        }
        finally {
            if (this.processEngineManager != null) {
                this.processEngineManager = null;
                this.log.log(4, "Process engine manager released.");
            }
            try {
                if (this.configurationAdmin != null) {
                    this.log.log(4, "Releasing configuration admin...");
                    this.configurationAdmin.stop();
                }
            }
            finally {
                if (this.configurationAdmin != null) {
                    this.configurationAdmin = null;
                    this.log.log(4, "Configuration admin released.");
                }
                try {
                    if (this.log != null) {
                        this.log.close();
                    }
                }
                finally {
                    if (this.log != null) {
                        this.log = null;
                    }
                    this.reporters.close();
                    this.reporters = null;
                    this.logReader.close();
                    this.logReader = null;
                    this.context = null;
                }
            }
        }
    }

    public synchronized void logged(LogEntry entry) {
    }

    public Object addingService(ServiceReference reference) {
        LogReaderService logReader = (LogReaderService)this.context.getService(reference);
        Enumeration log = logReader.getLog();
        if (log != null) {
            while (log.hasMoreElements()) {
                this.logged((LogEntry)log.nextElement());
            }
        }
        logReader.addLogListener((LogListener)this);
        return logReader;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        ((LogReaderService)this.context.getService(reference)).removeLogListener((LogListener)this);
        this.context.ungetService(reference);
    }
}

