/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.osgi;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.ActionDescriptor;
import org.eclipse.vtp.framework.engine.ConfigurationDescriptor;
import org.eclipse.vtp.framework.engine.IdentifierDescriptor;
import org.eclipse.vtp.framework.engine.ObserverDescriptor;
import org.eclipse.vtp.framework.engine.ServiceDescriptor;
import org.eclipse.vtp.framework.engine.main.ProcessEngine;
import org.eclipse.vtp.framework.engine.osgi.HttpConnectorManager;
import org.eclipse.vtp.framework.engine.osgi.OSGiUtils;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.eclipse.vtp.framework.util.SingletonTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public final class ProcessEngineManager
extends SingletonTracker {
    private final LogService log;
    private final IReporter reporter;
    private ProcessEngineInstance processEngineInstance = null;
    private HttpConnectorManager httpConnectorManager = null;

    public ProcessEngineManager(BundleContext context, LogService log, IReporter reporter) {
        super(context, IExtensionRegistry.class.getName(), null);
        this.log = log;
        this.reporter = reporter;
    }

    private void createProcessEngine(IExtensionRegistry extensionRegistry) {
        this.log.log(4, "Creating process engine...");
        this.processEngineInstance = new ProcessEngineInstance(extensionRegistry);
        this.processEngineInstance.open();
        this.log.log(4, "Process engine created.");
        this.log.log(4, "Creating HTTP connector manager...");
        this.httpConnectorManager = new HttpConnectorManager(this.context, this.log, extensionRegistry, this.processEngineInstance.processEngine, this.reporter);
        this.httpConnectorManager.open();
        this.log.log(4, "HTTP connector manager created.");
    }

    private void releaseProcessEngine() {
        try {
            if (this.httpConnectorManager != null) {
                this.log.log(4, "Releasing HTTP connector manager...");
                this.httpConnectorManager.close();
            }
        }
        finally {
            if (this.httpConnectorManager != null) {
                this.httpConnectorManager = null;
                this.log.log(4, "HTTP connector manager released.");
            }
            try {
                if (this.processEngineInstance != null) {
                    this.log.log(4, "Releasing process engine...");
                    this.processEngineInstance.close();
                }
            }
            finally {
                if (this.processEngineInstance != null) {
                    this.processEngineInstance = null;
                    this.log.log(4, "Process engine released.");
                }
            }
        }
    }

    public Object selectingService(ServiceReference reference) {
        IExtensionRegistry service = (IExtensionRegistry)this.context.getService(reference);
        boolean failed = true;
        try {
            this.createProcessEngine(service);
            failed = false;
        }
        finally {
            if (failed) {
                service = null;
                this.context.ungetService(reference);
            }
        }
        return service;
    }

    public Object changingSelectedService(ServiceReference oldReference, Object oldService, ServiceReference newReference) {
        IExtensionRegistry newService = (IExtensionRegistry)this.context.getService(newReference);
        this.releaseProcessEngine();
        boolean failed = true;
        try {
            this.createProcessEngine(newService);
            failed = false;
        }
        finally {
            if (failed) {
                newService = null;
                this.context.ungetService(newReference);
                this.createProcessEngine((IExtensionRegistry)oldService);
            }
        }
        this.context.ungetService(oldReference);
        return newService;
    }

    public void releasedSelectedService(ServiceReference reference, Object service) {
        try {
            this.releaseProcessEngine();
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    private final class ProcessEngineInstance
    implements IExtensionChangeHandler {
        final IExtensionRegistry extensionRegistry;
        final IExtensionPoint actions;
        final IExtensionPoint configurations;
        final IExtensionPoint observers;
        final IExtensionPoint services;
        final ProcessEngine processEngine;
        IExtensionTracker extensionTracker = null;
        ServiceRegistration registration = null;

        ProcessEngineInstance(IExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
            this.actions = extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.core.actions");
            this.configurations = extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.core.configurations");
            this.observers = extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.core.observers");
            this.services = extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.core.services");
            this.processEngine = new ProcessEngine(extensionRegistry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            this.extensionTracker = new ExtensionTracker(this.extensionRegistry);
            ProcessEngineInstance processEngineInstance = this;
            synchronized (processEngineInstance) {
                IExtensionPoint[] extensionPoints = new IExtensionPoint[]{this.actions, this.configurations, this.observers, this.services};
                this.extensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint[])extensionPoints));
                int i = 0;
                while (i < extensionPoints.length) {
                    IExtension[] extensions = extensionPoints[i].getExtensions();
                    int j = 0;
                    while (j < extensions.length) {
                        this.addExtension(this.extensionTracker, extensions[j]);
                        ++j;
                    }
                    ++i;
                }
            }
            this.registration = ((ServiceTracker)ProcessEngineManager.this).context.registerService(IProcessEngine.class.getName(), (Object)this.processEngine, null);
        }

        void close() {
            try {
                if (this.registration != null) {
                    this.registration.unregister();
                }
            }
            finally {
                this.registration = null;
                try {
                    if (this.extensionTracker != null) {
                        this.extensionTracker.unregisterHandler((IExtensionChangeHandler)this);
                    }
                }
                finally {
                    try {
                        if (this.extensionTracker != null) {
                            this.extensionTracker.close();
                        }
                    }
                    finally {
                        this.extensionTracker = null;
                    }
                }
            }
        }

        ActionDescriptor loadAction(Bundle contributor, IConfigurationElement element) {
            return new ActionDescriptor(element.getAttribute("id"), element.getAttribute("name"), this.loadClass(contributor, element.getAttribute("type")), Boolean.TRUE.toString().equalsIgnoreCase(element.getAttribute("blocking")));
        }

        ConfigurationDescriptor loadConfiguration(Bundle contributor, IConfigurationElement element) {
            return new ConfigurationDescriptor(element.getAttribute("id"), element.getAttribute("name"), element.getAttribute("xml-namespace"), element.getAttribute("xml-tag"), this.loadClass(contributor, element.getAttribute("type")));
        }

        ObserverDescriptor loadObserver(Bundle contributor, IConfigurationElement element) {
            return new ObserverDescriptor(element.getAttribute("id"), element.getAttribute("name"), this.loadClass(contributor, element.getAttribute("type")), Boolean.TRUE.toString().equalsIgnoreCase(element.getAttribute("blocking")));
        }

        ServiceDescriptor loadService(Bundle contributor, IConfigurationElement element) {
            IConfigurationElement[] identifierElements = element.getChildren("identifier");
            IdentifierDescriptor[] identifiers = new IdentifierDescriptor[identifierElements.length];
            int i = 0;
            while (i < identifierElements.length) {
                IConfigurationElement[] qualifierElements = identifierElements[i].getChildren("qualifier");
                String[] qualifiers = new String[qualifierElements.length];
                int j = 0;
                while (j < qualifierElements.length) {
                    qualifiers[j] = qualifierElements[j].getAttribute("name");
                    ++j;
                }
                identifiers[i] = new IdentifierDescriptor(identifierElements[i].getAttribute("name"), qualifiers);
                ++i;
            }
            return new ServiceDescriptor(element.getAttribute("id"), element.getAttribute("name"), element.getAttribute("scope"), this.loadClass(contributor, element.getAttribute("type")), identifiers);
        }

        Class loadClass(Bundle contributor, String className) throws IllegalStateException {
            try {
                return contributor.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        private IExtensionPoint getExtensionPoint(IExtension extension) {
            String epuid = extension.getExtensionPointUniqueIdentifier();
            if (this.actions.getUniqueIdentifier().equals(epuid)) {
                return this.actions;
            }
            if (this.configurations.getUniqueIdentifier().equals(epuid)) {
                return this.configurations;
            }
            if (this.observers.getUniqueIdentifier().equals(epuid)) {
                return this.observers;
            }
            if (this.services.getUniqueIdentifier().equals(epuid)) {
                return this.services;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExtension(IExtensionTracker tracker, IExtension extension) {
            Bundle contributor = OSGiUtils.findBundle(extension.getContributor(), ((ServiceTracker)ProcessEngineManager.this).context.getBundles());
            if (contributor == null) {
                return;
            }
            ProcessEngineInstance processEngineInstance = this;
            synchronized (processEngineInstance) {
                Object[] objects = tracker.getObjects(extension);
                if (objects != null && objects.length > 0) {
                    return;
                }
                IExtensionPoint point = this.getExtensionPoint(extension);
                if (point == null) {
                    return;
                }
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    Object descriptor = null;
                    if (this.actions == point) {
                        descriptor = this.loadAction(contributor, elements[i]);
                    } else if (this.configurations == point) {
                        descriptor = this.loadConfiguration(contributor, elements[i]);
                    } else if (this.observers == point) {
                        descriptor = this.loadObserver(contributor, elements[i]);
                    } else if (this.services == point) {
                        descriptor = this.loadService(contributor, elements[i]);
                    }
                    if (descriptor != null) {
                        tracker.registerObject(extension, descriptor, 0);
                        if (this.actions == point) {
                            this.processEngine.registerAction((ActionDescriptor)descriptor);
                        } else if (this.configurations == point) {
                            this.processEngine.registerConfiguration((ConfigurationDescriptor)descriptor);
                        } else if (this.observers == point) {
                            this.processEngine.registerObserver((ObserverDescriptor)descriptor);
                        } else if (this.services == point) {
                            this.processEngine.registerService((ServiceDescriptor)descriptor);
                        }
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeExtension(IExtension extension, Object[] objects) {
            ProcessEngineInstance processEngineInstance = this;
            synchronized (processEngineInstance) {
                if (objects == null || objects.length <= 0) {
                    return;
                }
                IExtensionPoint point = this.getExtensionPoint(extension);
                if (point == null) {
                    return;
                }
                int i = 0;
                while (i < objects.length) {
                    Object descriptor = objects[i];
                    if (this.actions == point) {
                        this.processEngine.unregisterAction((ActionDescriptor)descriptor);
                    } else if (this.configurations == point) {
                        this.processEngine.unregisterConfiguration((ConfigurationDescriptor)descriptor);
                    } else if (this.observers == point) {
                        this.processEngine.unregisterObserver((ObserverDescriptor)descriptor);
                    } else if (this.services == point) {
                        this.processEngine.unregisterService((ServiceDescriptor)descriptor);
                    }
                    ++i;
                }
            }
        }
    }
}

