/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.engine.ActionDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Executable;
import org.eclipse.vtp.framework.engine.runtime.Sequence;
import org.w3c.dom.Element;

public class Action
extends Executable {
    private final String name;
    private final ActionDescriptor descriptor;
    private final Map resultPaths = new HashMap();

    public Action(Blueprint blueprint, String name, Element[] elements, String instanceID, ActionDescriptor descriptor) throws NullPointerException {
        super(blueprint, descriptor.getType(), elements, instanceID);
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.name = name;
        this.descriptor = descriptor;
        this.resultPaths.put("repeat", this);
    }

    public void configure(String resultID, Executable next) {
        this.resultPaths.put(resultID, next);
    }

    public String getName() {
        return this.name;
    }

    public Action getActionInstance() {
        return this;
    }

    public int getActionState() {
        return 2;
    }

    public boolean isBlocking() {
        return this.descriptor.isBlocking();
    }

    public Executable execute(Sequence sequence) {
        Throwable cause;
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "action.starting");
        sequence.context.report(3, "Action \"" + this.getName() + "\" Starting", report);
        IActionResult actionResult = null;
        try {
            actionResult = ((IAction)this.createInstance(sequence)).execute();
        }
        catch (RuntimeException e) {
            actionResult = sequence.context.createResult(null, e);
        }
        report = new Hashtable();
        ((Dictionary)report).put("event", "action.ended");
        sequence.context.report(3, "Action \"" + this.getName() + "\" Ended", report);
        if (actionResult == null) {
            actionResult = sequence.context.createResult(null);
        }
        if ((cause = actionResult.getFailureCause()) != null && sequence.context.isErrorEnabled()) {
            Hashtable<String, Throwable> properties = new Hashtable<String, Throwable>();
            properties.put("cause", cause);
            sequence.context.error(cause.getMessage(), properties);
        }
        String resultName = actionResult.getName();
        Executable next = (Executable)this.resultPaths.get(resultName);
        while (next == null) {
            if ("abort".equals(resultName)) {
                return null;
            }
            if ("error".equals(resultName)) {
                resultName = "abort";
                continue;
            }
            if ("default".equals(resultName)) {
                resultName = "error";
                continue;
            }
            int lastDot = resultName.lastIndexOf(46);
            resultName = lastDot < 0 ? "default" : resultName.substring(0, lastDot);
            next = (Executable)this.resultPaths.get(resultName);
        }
        return next;
    }

    protected Class getComponentType() {
        return this.descriptor.getType();
    }
}

