/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.runtime.RuntimeUtils;

public abstract class Builder {
    private IContext registry = null;
    private Object instance = null;

    protected Builder() {
    }

    public Object create() throws IllegalStateException {
        if (this.instance != null) {
            throw new IllegalStateException();
        }
        Constructor[] constructors = this.getConstructors();
        ArrayList<Object> arguments = new ArrayList<Object>();
        int i = 0;
        while (this.instance == null && i < constructors.length) {
            Class<?>[] parameterTypes = constructors[i].getParameterTypes();
            if (parameterTypes.length == 0) {
                this.instance = RuntimeUtils.createInstance(constructors[i], new Object[0]);
            } else {
                int j = 0;
                while (j < parameterTypes.length) {
                    Object value = this.resolveDependency(parameterTypes[j]);
                    if (value == null) {
                        arguments.clear();
                        break;
                    }
                    arguments.add(value);
                    ++j;
                }
                if (!arguments.isEmpty()) {
                    this.instance = RuntimeUtils.createInstance(constructors[i], arguments.toArray());
                }
            }
            ++i;
        }
        if (this.instance == null) {
            System.err.println("Unable to create: " + constructors[0].getDeclaringClass().getName());
        }
        return this.instance;
    }

    public void configure() throws IllegalStateException {
        if (this.instance == null) {
            throw new IllegalStateException();
        }
        Method[] mutators = this.getMutators();
        int i = 0;
        while (i < mutators.length) {
            Object value = this.resolveDependency(mutators[i].getParameterTypes()[0]);
            if (!(value == null || value.getClass().isArray() && ((Object[])value).length <= 0)) {
                RuntimeUtils.setProperty(this.instance, mutators[i], value);
            }
            ++i;
        }
        this.instance = null;
    }

    protected abstract Constructor[] getConstructors();

    protected abstract Method[] getMutators();

    protected abstract IContext createServiceRegistry();

    private Object resolveDependency(Class type) {
        if (this.registry == null) {
            this.registry = this.createServiceRegistry();
        }
        Object[] value = null;
        if (type.isArray()) {
            Object[] values = this.registry.lookupAll(type.getComponentType().getName());
            ArrayList<Object> results = new ArrayList<Object>(values.length);
            int i = 0;
            while (i < values.length) {
                if (type.getComponentType().isInstance(values[i])) {
                    results.add(values[i]);
                }
                ++i;
            }
            value = results.toArray((Object[])Array.newInstance(type.getComponentType(), results.size()));
        } else {
            value = this.registry.lookup(type.getName());
            if (value != null && !type.isInstance(value)) {
                value = null;
            }
        }
        return value;
    }
}

