/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;

public abstract class Component {
    private static final Comparator CONSTRUCTOR_SORT = new Comparator(){

        public int compare(Object left, Object right) {
            return ((Constructor)right).getParameterTypes().length - ((Constructor)left).getParameterTypes().length;
        }
    };
    protected final Blueprint blueprint;
    protected final Constructor[] constructors;
    protected final Method[] mutators;

    public Component(Blueprint blueprint, Class type) throws NullPointerException {
        if (blueprint == null) {
            throw new NullPointerException("blueprint");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.blueprint = blueprint;
        this.constructors = type.getConstructors();
        Arrays.sort(this.constructors, CONSTRUCTOR_SORT);
        Method[] methods = type.getMethods();
        ArrayList<Method> mutators = new ArrayList<Method>(methods.length);
        int i = 0;
        while (i < methods.length) {
            Class<?>[] parameterTypes;
            char c;
            String name;
            if (Void.TYPE.equals(methods[i].getReturnType()) && !Modifier.isStatic(methods[i].getModifiers()) && (name = methods[i].getName()).startsWith("set") && name.length() >= 4 && Character.isJavaIdentifierStart(c = name.charAt(3)) && Character.isUpperCase(c) && (parameterTypes = methods[i].getParameterTypes()).length == 1) {
                mutators.add(methods[i]);
            }
            ++i;
        }
        this.mutators = mutators.toArray(new Method[mutators.size()]);
    }
}

