/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Builder;
import org.eclipse.vtp.framework.engine.runtime.Component;
import org.eclipse.vtp.framework.engine.runtime.Configuration;
import org.eclipse.vtp.framework.engine.runtime.RuntimeUtils;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.w3c.dom.Element;

public abstract class Configurable
extends Component {
    private final Map configurationIndex;

    protected Configurable(Blueprint blueprint, Class type, Element[] elements) throws NullPointerException {
        super(blueprint, type);
        HashMap configurationIndex = new HashMap();
        LinkedList<Element> elementList = new LinkedList<Element>();
        int i = 0;
        while (elements != null && i < elements.length) {
            if (elements[i] != null) {
                Element element = (Element)elements[i].cloneNode(true);
                elementList.addLast(element);
                String xmlIdentifier = RuntimeUtils.getXMLIdentifier(element);
                LinkedList<Element> items = (LinkedList<Element>)configurationIndex.get(xmlIdentifier);
                if (items == null) {
                    items = new LinkedList<Element>();
                    configurationIndex.put(xmlIdentifier, items);
                }
                items.addLast(element);
                String qualifiedIdentifier = RuntimeUtils.getQualifiedIdentifier(Element.class.getName(), xmlIdentifier);
                items = (LinkedList<Element>)configurationIndex.get(qualifiedIdentifier);
                if (items == null) {
                    items = new LinkedList<Element>();
                    configurationIndex.put(qualifiedIdentifier, items);
                }
                items.addLast(element);
            }
            ++i;
        }
        if (!elementList.isEmpty()) {
            configurationIndex.put(Element.class.getName(), elementList);
        }
        for (Element element : elementList) {
            Collection configurationList = blueprint.createConfigurations(element);
            for (Configuration configuration : configurationList) {
                Set identifierSet = configuration.getIdentifiers();
                for (String identifier : identifierSet) {
                    LinkedList<Configuration> items = (LinkedList<Configuration>)configurationIndex.get(identifier);
                    if (items == null) {
                        items = new LinkedList<Configuration>();
                        configurationIndex.put(identifier, items);
                    }
                    items.addLast(configuration);
                }
            }
        }
        for (Map.Entry entry : configurationIndex.entrySet()) {
            entry.setValue(Collections.unmodifiableList(new ArrayList((LinkedList)entry.getValue())));
        }
        this.configurationIndex = Collections.unmodifiableMap(new HashMap(configurationIndex));
    }

    protected Object lookupConfiguration(String identifier, IContext serviceRegistry) {
        List items = (List)this.configurationIndex.get(identifier);
        if (items == null || items.isEmpty()) {
            return null;
        }
        Object item = items.iterator().next();
        if (item instanceof Configuration) {
            return ((Configuration)item).createInstance(serviceRegistry);
        }
        return ((Element)item).cloneNode(true);
    }

    protected Object[] lookupAllConfigurations(String identifier, IContext serviceRegistry) {
        List items = (List)this.configurationIndex.get(identifier);
        if (items == null || items.isEmpty()) {
            return null;
        }
        Object[] results = new Object[items.size()];
        int i = 0;
        for (Object item : items) {
            results[i] = item instanceof Configuration ? ((Configuration)item).createInstance(serviceRegistry) : ((Element)item).cloneNode(true);
            ++i;
        }
        return results;
    }

    protected Builder createBuilder(final Scope scope) {
        return new Builder(){

            protected Constructor[] getConstructors() {
                return Configurable.this.constructors;
            }

            protected Method[] getMutators() {
                return Configurable.this.mutators;
            }

            protected IContext createServiceRegistry() {
                return Configurable.this.createServiceRegistry(scope);
            }
        };
    }

    protected abstract IContext createServiceRegistry(Scope var1);
}

