/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.ConfigurationDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Builder;
import org.eclipse.vtp.framework.engine.runtime.Component;
import org.eclipse.vtp.framework.engine.runtime.RuntimeUtils;
import org.w3c.dom.Element;

public class Configuration
extends Component {
    private final Element data;
    private final Set identifiers;

    public Configuration(Blueprint blueprint, ConfigurationDescriptor descriptor, Element data) throws NullPointerException {
        super(blueprint, descriptor.getType());
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        HashSet typeHierarchy = new HashSet();
        RuntimeUtils.listTypeHierarchy(descriptor.getType(), typeHierarchy);
        typeHierarchy.remove(Object.class);
        HashSet<String> identifiers = new HashSet<String>(2 + typeHierarchy.size() * 2);
        identifiers.add(descriptor.getId());
        String xmlIdentifier = RuntimeUtils.getQualifiedIdentifier(descriptor.getXmlTag(), descriptor.getXmlNamespace());
        identifiers.add(xmlIdentifier);
        Iterator i = typeHierarchy.iterator();
        while (i.hasNext()) {
            String typeName = ((Class)i.next()).getName();
            identifiers.add(typeName);
            identifiers.add(RuntimeUtils.getQualifiedIdentifier(typeName, xmlIdentifier));
        }
        this.identifiers = Collections.unmodifiableSet(identifiers);
    }

    public Set getIdentifiers() {
        return this.identifiers;
    }

    public Object createInstance(final IContext serviceRegistry) throws NullPointerException {
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry");
        }
        Builder builder = new Builder(){

            protected Constructor[] getConstructors() {
                return Configuration.this.constructors;
            }

            protected Method[] getMutators() {
                return Configuration.this.mutators;
            }

            protected IContext createServiceRegistry() {
                return serviceRegistry;
            }
        };
        IConfiguration instance = (IConfiguration)builder.create();
        if (instance != null) {
            builder.configure();
            instance.load((Element)this.data.cloneNode(true));
        }
        return instance;
    }
}

