/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.runtime.Action;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Builder;
import org.eclipse.vtp.framework.engine.runtime.Configurable;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.runtime.Sequence;
import org.eclipse.vtp.framework.engine.support.ActionContextWrapper;
import org.w3c.dom.Element;

public abstract class Executable
extends Configurable {
    private final String instanceID;

    public Executable(Blueprint blueprint, Class type, Element[] elements, String instanceID) throws NullPointerException {
        super(blueprint, type, elements);
        if (instanceID == null) {
            throw new NullPointerException("instanceID");
        }
        this.instanceID = instanceID;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public abstract Action getActionInstance();

    public abstract int getActionState();

    public abstract boolean isBlocking();

    public abstract Executable execute(Sequence var1);

    protected IContext createServiceRegistry(Scope scope) {
        return new ActionContext((Sequence)scope);
    }

    protected Object createInstance(Sequence sequence) throws NullPointerException {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        Builder builder = this.createBuilder(sequence);
        Object instance = builder.create();
        if (instance != null) {
            builder.configure();
        }
        return instance;
    }

    private final class ActionContext
    extends ActionContextWrapper {
        private final Sequence sequence;

        ActionContext(Sequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException("sequence");
            }
            this.sequence = sequence;
        }

        public Object lookup(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return this;
            }
            Object config = Executable.this.lookupConfiguration(identifier, (IContext)this);
            if (config == null) {
                return this.sequence.context.lookup(identifier);
            }
            return config;
        }

        public Object[] lookupAll(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return new Object[]{this};
            }
            Object[] configs = Executable.this.lookupAllConfigurations(identifier, (IContext)this);
            if (configs == null || configs.length == 0) {
                return this.sequence.context.lookupAll(identifier);
            }
            Object[] services = this.sequence.context.lookupAll(identifier);
            if (services == null || services.length == 0) {
                return configs;
            }
            Object[] results = new Object[configs.length + services.length];
            System.arraycopy(configs, 0, results, 0, configs.length);
            System.arraycopy(services, 0, results, configs.length, services.length);
            return results;
        }

        protected IActionContext getActionContext() {
            return this.sequence.context;
        }
    }
}

