/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.runtime.Sequence;
import org.eclipse.vtp.framework.engine.runtime.Session;
import org.eclipse.vtp.framework.engine.support.AbstractExecutionContext;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandProcessor;
import org.eclipse.vtp.framework.spi.ICommandVisitor;
import org.eclipse.vtp.framework.spi.IExecution;
import org.eclipse.vtp.framework.spi.IExecutionDescriptor;
import org.eclipse.vtp.framework.spi.IRunnableCommand;
import org.eclipse.vtp.framework.spi.IRunnableCommandVisitor;
import org.eclipse.vtp.framework.spi.ISession;

public class Execution
extends Scope
implements IExecution {
    private static final String COMMAND_QUEUE = "engine.command.queue";
    protected final Session session;
    protected final Context context;
    private LinkedList commandQueue = new LinkedList();
    private Sequence current = null;

    public Execution(Session session, IExecutionDescriptor descriptor) {
        Sequence current;
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.session = session;
        this.context = new Context(descriptor);
        Object exportedQueue = this.context.getAttribute(COMMAND_QUEUE);
        if (exportedQueue instanceof Object[]) {
            Object[] array = (Object[])exportedQueue;
            int i = 0;
            while (i < array.length) {
                try {
                    ICommand command = (ICommand)this.context.loadClass((String)array[i]).newInstance();
                    command.importContents(array[i + 1]);
                    this.commandQueue.addLast(command);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                i += 2;
            }
        }
        if ((current = new Sequence(this)).hasNext()) {
            this.current = current;
        }
    }

    protected Collection getServices(String identifier) {
        return this.session.process.blueprint.getExecutionServices(identifier);
    }

    public String getExecutionID() {
        return this.context.getExecutionID();
    }

    public Object lookupService(String identifier) throws NullPointerException {
        return this.context.lookup(identifier);
    }

    public Object[] lookupAllServices(String identifier) throws NullPointerException {
        return this.context.lookupAll(identifier);
    }

    public boolean hasNextStep() {
        return this.commandQueue != null && !this.commandQueue.isEmpty() || this.current != null;
    }

    public boolean isNextStepBlocking() {
        if (this.commandQueue != null && !this.commandQueue.isEmpty()) {
            return false;
        }
        return this.current != null && this.current.isNextBlocking();
    }

    public ICommand nextStep() throws IllegalStateException {
        if (this.commandQueue != null && !this.commandQueue.isEmpty()) {
            return (ICommand)this.commandQueue.removeFirst();
        }
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return new IRunnableCommand(){

            public void run() {
                Execution.this.current = Execution.this.current.next();
            }

            public Object accept(ICommandVisitor visitor) throws NullPointerException {
                if (visitor == null) {
                    throw new NullPointerException("visitor");
                }
                if (visitor instanceof IRunnableCommandVisitor) {
                    return ((IRunnableCommandVisitor)visitor).visitRunnable((IRunnableCommand)this);
                }
                return visitor.visitUnknown((ICommand)this);
            }

            public void importContents(Object contents) {
            }

            public Object exportContents() {
                return new Object[0];
            }
        };
    }

    public void takeNextStep() throws IllegalStateException, RuntimeException {
    }

    public ISession getSession() {
        return this.session;
    }

    public void dispose() {
        if (this.commandQueue == null) {
            return;
        }
        LinkedList commandQueue = this.commandQueue;
        this.commandQueue = null;
        Object[] array = new Object[commandQueue.size() * 2];
        int i = 0;
        for (ICommand command : commandQueue) {
            array[i] = command.getClass().getName();
            array[i + 1] = command.exportContents();
            i += 2;
        }
    }

    protected final class Context
    extends AbstractExecutionContext
    implements ICommandProcessor {
        Context(IExecutionDescriptor descriptor) throws NullPointerException {
            super(Execution.this.session.context, descriptor);
        }

        IExecutionDescriptor getDescriptor() {
            return this.descriptor;
        }

        Set getProvidedServiceIdentifiers() {
            return this.providedServiceIdentifiers;
        }

        protected Object lookupReservedService(String identifier) {
            Object service = super.lookupReservedService(identifier);
            if (service == null && ICommandProcessor.class.getName().equals(identifier)) {
                service = this;
            }
            return service;
        }

        protected Object lookupLocalService(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            if (provided == null) {
                return Execution.this.lookupInScope(identifier);
            }
            return provided;
        }

        protected Object[] lookupAllLocalServices(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            Object[] all = Execution.this.lookupAllInScope(identifier);
            if (provided == null) {
                return all;
            }
            Object[] result = new Object[all.length];
            result[0] = provided;
            System.arraycopy(all, 0, result, 1, all.length);
            return result;
        }

        public boolean enqueue(ICommand command) {
            Execution.this.commandQueue.addLast(command);
            return true;
        }

        public boolean process(ICommand command) throws IllegalStateException {
            throw new IllegalStateException();
        }
    }
}

