/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Hashtable;
import org.eclipse.vtp.framework.engine.ObserverDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Action;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Executable;
import org.eclipse.vtp.framework.engine.runtime.Sequence;
import org.w3c.dom.Element;

public class Observer
extends Executable {
    private final ObserverDescriptor descriptor;
    private final Action observed;
    private Executable next = null;

    public Observer(Blueprint blueprint, Element[] elements, String instanceID, ObserverDescriptor descriptor, Action observed) throws NullPointerException {
        super(blueprint, descriptor.getType(), elements, instanceID);
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        if (observed == null) {
            throw new NullPointerException("observed");
        }
        this.descriptor = descriptor;
        this.observed = observed;
    }

    protected void configure(Executable next) {
        this.next = next;
    }

    public Action getActionInstance() {
        return this.observed;
    }

    public int getActionState() {
        if (this.next == null) {
            return 3;
        }
        if (this.next instanceof Observer) {
            return this.next.getActionState();
        }
        if (this.observed.equals(this.next)) {
            return 1;
        }
        return 3;
    }

    public boolean isBlocking() {
        return this.descriptor.isBlocking();
    }

    public Executable execute(Sequence sequence) {
        block2: {
            try {
                ((Runnable)this.createInstance(sequence)).run();
            }
            catch (RuntimeException cause) {
                if (!sequence.context.isErrorEnabled()) break block2;
                Hashtable<String, RuntimeException> properties = new Hashtable<String, RuntimeException>();
                properties.put("cause", cause);
                sequence.context.error(cause.getMessage(), properties);
            }
        }
        return this.next;
    }

    protected Class getComponentType() {
        return this.descriptor.getType();
    }
}

