/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.runtime.Session;
import org.eclipse.vtp.framework.engine.support.AbstractProcessContext;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.IProcessDescriptor;
import org.eclipse.vtp.framework.spi.ISession;
import org.eclipse.vtp.framework.spi.ISessionDescriptor;

public class Process
extends Scope
implements IProcess {
    protected final Blueprint blueprint;
    protected final Context context;

    public Process(Blueprint blueprint, IProcessDescriptor descriptor) throws NullPointerException {
        if (blueprint == null) {
            throw new NullPointerException("blueprint");
        }
        this.blueprint = blueprint;
        this.context = new Context(descriptor);
    }

    protected Object lookupInScope(String identifier) {
        if (IExtensionRegistry.class.getName().equals(identifier)) {
            return this.blueprint.getRegistry();
        }
        return super.lookupInScope(identifier);
    }

    protected Object[] lookupAllInScope(String identifier) {
        Object[] results = super.lookupAllInScope(identifier);
        if (IExtensionRegistry.class.getName().equals(identifier)) {
            Object[] allResults = new Object[results == null ? 1 : results.length + 1];
            allResults[0] = this.blueprint.getRegistry();
            if (results != null) {
                System.arraycopy(results, 0, allResults, 1, results.length);
            }
            return allResults;
        }
        return results;
    }

    protected Collection getServices(String identifier) {
        return this.blueprint.getProcessServices(identifier);
    }

    public String getProcessID() {
        return this.context.getProcessID();
    }

    public Object lookupService(String identifier) throws NullPointerException {
        return this.context.lookup(identifier);
    }

    public Object[] lookupAllServices(String identifier) throws NullPointerException {
        return this.context.lookupAll(identifier);
    }

    public ISession createSession(ISessionDescriptor descriptor) throws NullPointerException {
        return new Session(this, descriptor);
    }

    protected final class Context
    extends AbstractProcessContext {
        Context(IProcessDescriptor descriptor) throws NullPointerException {
            super(descriptor);
        }

        IProcessDescriptor getDescriptor() {
            return this.descriptor;
        }

        Set getProvidedServiceIdentifiers() {
            return this.providedServiceIdentifiers;
        }

        protected Object lookupLocalService(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            if (provided == null) {
                return Process.this.lookupInScope(identifier);
            }
            return provided;
        }

        protected Object[] lookupAllLocalServices(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            Object[] all = Process.this.lookupAllInScope(identifier);
            if (provided == null) {
                return all;
            }
            Object[] result = new Object[all.length];
            result[0] = provided;
            System.arraycopy(all, 0, result, 1, all.length);
            return result;
        }
    }
}

