/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.engine.runtime.Builder;
import org.eclipse.vtp.framework.engine.runtime.Service;

public abstract class Scope {
    private final Map implicitServices = new HashMap();
    private final Map declaredServices = new HashMap();
    private List builderQueue = null;

    protected Scope() {
    }

    protected void registerImplicitServices(String identifier, Object[] services) {
        this.implicitServices.put(identifier, Arrays.asList(services));
    }

    protected Object lookupInScope(String identifier) {
        Collection implicitServices = (Collection)this.implicitServices.get(identifier);
        if (implicitServices != null && !implicitServices.isEmpty()) {
            return implicitServices.iterator().next();
        }
        Collection declaredServices = this.getServices(identifier);
        if (declaredServices != null && !declaredServices.isEmpty()) {
            return ((Service)declaredServices.iterator().next()).getInstance(this);
        }
        return null;
    }

    protected Object[] lookupAllInScope(String identifier) {
        Collection implicitServices = (Collection)this.implicitServices.get(identifier);
        Collection declaredServices = this.getServices(identifier);
        ArrayList<Object> results = new ArrayList<Object>((implicitServices == null ? 0 : implicitServices.size()) + (declaredServices == null ? 0 : declaredServices.size()));
        if (implicitServices != null && !implicitServices.isEmpty()) {
            results.addAll(implicitServices);
        }
        if (declaredServices != null && !declaredServices.isEmpty()) {
            Iterator i = declaredServices.iterator();
            while (i.hasNext()) {
                Object instance = ((Service)i.next()).getInstance(this);
                if (instance == null) continue;
                results.add(instance);
            }
        }
        return results.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getServiceInstance(Service service) {
        String id = service.getDescriptorID();
        Map map = this.declaredServices;
        synchronized (map) {
            Object instance = this.declaredServices.get(id);
            if (instance == null && !this.declaredServices.containsKey(id)) {
                this.declaredServices.put(id, null);
                boolean flushBuilders = this.builderQueue == null;
                try {
                    Builder builder;
                    if (flushBuilders) {
                        this.builderQueue = new LinkedList();
                    }
                    if ((instance = (builder = service.createBuilder(this)).create()) != null) {
                        this.declaredServices.put(id, instance);
                        this.builderQueue.add(builder);
                    }
                    if (flushBuilders) {
                        List builders = this.builderQueue;
                        this.builderQueue = null;
                        RuntimeException re = null;
                        Iterator i = builders.iterator();
                        while (i.hasNext()) {
                            try {
                                ((Builder)i.next()).configure();
                            }
                            catch (RuntimeException e) {
                                if (re != null) continue;
                                re = e;
                            }
                        }
                        if (re != null) {
                            throw re;
                        }
                    }
                }
                finally {
                    if (flushBuilders && this.builderQueue != null) {
                        this.builderQueue = null;
                    }
                    if (instance == null) {
                        this.declaredServices.remove(id);
                    }
                }
            }
            return instance;
        }
    }

    protected abstract Collection getServices(String var1);
}

