/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Collection;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.engine.runtime.Executable;
import org.eclipse.vtp.framework.engine.runtime.Execution;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.support.AbstractActionContext;

public class Sequence
extends Scope {
    private static final String SEQUENCE_POSITION = "engine.sequence.position";
    protected final Execution execution;
    protected final Context context;
    private Executable next = null;

    public Sequence(Execution execution) throws NullPointerException {
        if (execution == null) {
            throw new NullPointerException("execution");
        }
        this.execution = execution;
        this.context = new Context();
        Object position = this.context.getAttribute(SEQUENCE_POSITION);
        if (position == null) {
            this.next = execution.session.process.blueprint.getEntryPoint();
        } else if (position instanceof String) {
            this.next = execution.session.process.blueprint.getExecutable((String)position);
        }
    }

    private Sequence(Execution execution, Executable next) {
        this.execution = execution;
        this.context = new Context();
        this.next = next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean isNextBlocking() {
        return this.next.isBlocking();
    }

    public Sequence next() {
        Executable previous = this.next;
        String instanceID = this.next.getActionInstance().getInstanceID();
        int colon = instanceID.indexOf(58);
        if (colon < 0) {
            this.context.setAttribute("span.primitive", instanceID);
        } else {
            this.context.setAttribute("span.dialog", instanceID.substring(0, colon));
            this.context.setAttribute("span.primitive", instanceID.substring(colon + 1));
        }
        this.context.setAttribute("span.primitive.name", this.next.getActionInstance().getName());
        this.next = this.next.execute(this);
        if (this.next == null) {
            this.context.setAttribute(SEQUENCE_POSITION, "");
            return null;
        }
        this.context.setAttribute(SEQUENCE_POSITION, this.next.getInstanceID());
        if (!previous.getActionInstance().equals(this.next.getActionInstance())) {
            Executable next = this.next;
            this.next = null;
            return new Sequence(this.execution, next);
        }
        return this;
    }

    protected Collection getServices(String identifier) {
        return this.execution.session.process.blueprint.getActionServices(identifier);
    }

    protected final class Context
    extends AbstractActionContext {
        Context() {
            super(Sequence.this.execution.context);
        }

        protected Object lookupLocalService(String identifier) {
            return Sequence.this.lookupInScope(identifier);
        }

        protected Object[] lookupAllLocalServices(String identifier) {
            return Sequence.this.lookupAllInScope(identifier);
        }

        public String getActionID() {
            return Sequence.this.next.getActionInstance().getInstanceID();
        }

        public String getActionName() {
            return Sequence.this.next.getActionInstance().getName();
        }

        public int getActionState() {
            return Sequence.this.next.getActionState();
        }

        public IActionResult createResult(final String resultName, final Throwable failureCause) {
            return new IActionResult(){

                public String getName() {
                    return resultName == null || resultName.length() == 0 ? "error" : resultName;
                }

                public Throwable getFailureCause() {
                    return failureCause;
                }
            };
        }
    }
}

