/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.engine.IdentifierDescriptor;
import org.eclipse.vtp.framework.engine.ServiceDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Blueprint;
import org.eclipse.vtp.framework.engine.runtime.Configurable;
import org.eclipse.vtp.framework.engine.runtime.Execution;
import org.eclipse.vtp.framework.engine.runtime.Process;
import org.eclipse.vtp.framework.engine.runtime.RuntimeUtils;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.runtime.Sequence;
import org.eclipse.vtp.framework.engine.runtime.Session;
import org.eclipse.vtp.framework.engine.support.ActionContextWrapper;
import org.eclipse.vtp.framework.engine.support.ExecutionContextWrapper;
import org.eclipse.vtp.framework.engine.support.ProcessContextWrapper;
import org.eclipse.vtp.framework.engine.support.SessionContextWrapper;
import org.eclipse.vtp.framework.spi.ICommandProcessor;
import org.w3c.dom.Element;

public class Service
extends Configurable {
    private final ServiceDescriptor descriptor;
    private final Set identifiers;

    public Service(Blueprint blueprint, Element[] configurations, ServiceDescriptor descriptor) throws NullPointerException {
        super(blueprint, descriptor.getType(), configurations);
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.descriptor = descriptor;
        HashSet<String> identifiers = new HashSet<String>();
        identifiers.add(descriptor.getId());
        HashSet typeHierarchy = new HashSet();
        RuntimeUtils.listTypeHierarchy(descriptor.getType(), typeHierarchy);
        typeHierarchy.remove(Object.class);
        Iterator i = typeHierarchy.iterator();
        while (i.hasNext()) {
            identifiers.add(((Class)i.next()).getName());
        }
        int identifierCount = descriptor.getIdentifierCount();
        int i2 = 0;
        while (i2 < identifierCount) {
            IdentifierDescriptor identifier = descriptor.getIdentifier(i2);
            identifiers.add(identifier.getName());
            int qualifierCount = identifier.getQualifierCount();
            int j = 0;
            while (j < qualifierCount) {
                identifiers.add(RuntimeUtils.getQualifiedIdentifier(identifier.getName(), identifier.getQualifier(j)));
                ++j;
            }
            ++i2;
        }
        this.identifiers = Collections.unmodifiableSet(new HashSet(identifiers));
    }

    public String getDescriptorID() {
        return this.descriptor.getId();
    }

    public Set getIdentifiers() {
        return this.identifiers;
    }

    protected Object lookupSiblingService(String identifier, Scope scope) {
        if (scope instanceof Process) {
            Process process = (Process)scope;
            if (process.context.getProvidedServiceIdentifiers().contains(identifier)) {
                return process.context.getDescriptor().getService(identifier);
            }
        } else if (scope instanceof Session) {
            Session session = (Session)scope;
            if (session.context.getProvidedServiceIdentifiers().contains(identifier)) {
                return session.context.getDescriptor().getService(identifier);
            }
        } else if (scope instanceof Execution) {
            Execution execution = (Execution)scope;
            if (execution.context.getProvidedServiceIdentifiers().contains(identifier)) {
                return execution.context.getDescriptor().getService(identifier);
            }
        }
        if (this.identifiers.contains(identifier)) {
            return null;
        }
        return scope.lookupInScope(identifier);
    }

    protected Object[] lookupAllSiblingServices(String identifier, Scope scope) {
        Object[] services;
        LinkedList<Object> results = new LinkedList<Object>();
        if (scope instanceof Process) {
            Process process = (Process)scope;
            if (process.context.getProvidedServiceIdentifiers().contains(identifier)) {
                results.add(process.context.getDescriptor().getService(identifier));
            }
        } else if (scope instanceof Session) {
            Session session = (Session)scope;
            if (session.context.getProvidedServiceIdentifiers().contains(identifier)) {
                results.add(session.context.getDescriptor().getService(identifier));
            }
        } else if (scope instanceof Execution) {
            Execution execution = (Execution)scope;
            if (execution.context.getProvidedServiceIdentifiers().contains(identifier)) {
                results.add(execution.context.getDescriptor().getService(identifier));
            }
        }
        if (!this.identifiers.contains(identifier) && (services = scope.lookupAllInScope(identifier)) != null) {
            int i = 0;
            while (i < services.length) {
                results.add(services[i]);
                ++i;
            }
        }
        return results.toArray();
    }

    protected Class getComponentType() {
        return this.descriptor.getType();
    }

    protected IContext createServiceRegistry(Scope scope) {
        if (scope instanceof Process) {
            return new ProcessContext((Process)scope);
        }
        if (scope instanceof Session) {
            return new SessionContext((Session)scope);
        }
        if (scope instanceof Execution) {
            return new ExecutionContext((Execution)scope);
        }
        if (scope instanceof Sequence) {
            return new ActionContext((Sequence)scope);
        }
        return null;
    }

    public Object getInstance(Scope scope) throws IllegalStateException, NullPointerException {
        return scope.getServiceInstance(this);
    }

    private final class ActionContext
    extends ActionContextWrapper {
        final Sequence sequence;

        ActionContext(Sequence sequence) throws NullPointerException {
            this.sequence = sequence;
        }

        public Object lookup(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return this;
            }
            Object config = Service.this.lookupConfiguration(identifier, (IContext)this);
            if (config == null) {
                Object service = Service.this.lookupSiblingService(identifier, this.sequence);
                if (service == null) {
                    return this.sequence.execution.context.lookup(identifier);
                }
                return service;
            }
            return config;
        }

        public Object[] lookupAll(String identifier) throws NullPointerException {
            int i;
            Object[] services;
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return new Object[]{this};
            }
            LinkedList<Object> results = new LinkedList<Object>();
            Object[] configs = Service.this.lookupAllConfigurations(identifier, (IContext)this);
            if (configs != null) {
                int i2 = 0;
                while (i2 < configs.length) {
                    results.add(configs[i2]);
                    ++i2;
                }
            }
            if ((services = Service.this.lookupAllSiblingServices(identifier, this.sequence)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            if ((services = this.sequence.execution.context.lookupAll(identifier)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            return results.toArray();
        }

        protected IActionContext getActionContext() {
            return this.sequence.context;
        }
    }

    private final class ExecutionContext
    extends ExecutionContextWrapper {
        final Execution execution;

        ExecutionContext(Execution execution) throws NullPointerException {
            this.execution = execution;
        }

        public Object lookup(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return this;
            }
            if (ICommandProcessor.class.getName().equals(identifier)) {
                return this.execution.context;
            }
            Object config = Service.this.lookupConfiguration(identifier, (IContext)this);
            if (config == null) {
                Object service = Service.this.lookupSiblingService(identifier, this.execution);
                if (service == null) {
                    return this.execution.session.context.lookup(identifier);
                }
                return service;
            }
            return config;
        }

        public Object[] lookupAll(String identifier) throws NullPointerException {
            int i;
            Object[] services;
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return new Object[]{this};
            }
            LinkedList<Object> results = new LinkedList<Object>();
            Object[] configs = Service.this.lookupAllConfigurations(identifier, (IContext)this);
            if (configs != null) {
                int i2 = 0;
                while (i2 < configs.length) {
                    results.add(configs[i2]);
                    ++i2;
                }
            }
            if ((services = Service.this.lookupAllSiblingServices(identifier, this.execution)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            if ((services = this.execution.session.context.lookupAll(identifier)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            return results.toArray();
        }

        protected IExecutionContext getExecutionContext() {
            return this.execution.context;
        }
    }

    private final class ProcessContext
    extends ProcessContextWrapper {
        final Process process;

        ProcessContext(Process process) throws NullPointerException {
            this.process = process;
        }

        public Object lookup(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return this;
            }
            Object config = Service.this.lookupConfiguration(identifier, (IContext)this);
            if (config == null) {
                return Service.this.lookupSiblingService(identifier, this.process);
            }
            return config;
        }

        public Object[] lookupAll(String identifier) throws NullPointerException {
            Object[] services;
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return new Object[]{this};
            }
            LinkedList<Object> results = new LinkedList<Object>();
            Object[] configs = Service.this.lookupAllConfigurations(identifier, (IContext)this);
            if (configs != null) {
                int i = 0;
                while (i < configs.length) {
                    results.add(configs[i]);
                    ++i;
                }
            }
            if ((services = Service.this.lookupAllSiblingServices(identifier, this.process)) != null) {
                int i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            return results.toArray();
        }

        protected IProcessContext getProcessContext() {
            return this.process.context;
        }
    }

    private final class SessionContext
    extends SessionContextWrapper {
        final Session session;

        SessionContext(Session session) throws NullPointerException {
            this.session = session;
        }

        public Object lookup(String identifier) throws NullPointerException {
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return this;
            }
            Object config = Service.this.lookupConfiguration(identifier, (IContext)this);
            if (config == null) {
                Object service = Service.this.lookupSiblingService(identifier, this.session);
                if (service == null) {
                    return this.session.process.context.lookup(identifier);
                }
                return service;
            }
            return config;
        }

        public Object[] lookupAll(String identifier) throws NullPointerException {
            int i;
            Object[] services;
            if (identifier == null) {
                throw new NullPointerException("identifier");
            }
            if (this.isReservedIdentifier(identifier)) {
                return new Object[]{this};
            }
            LinkedList<Object> results = new LinkedList<Object>();
            Object[] configs = Service.this.lookupAllConfigurations(identifier, (IContext)this);
            if (configs != null) {
                int i2 = 0;
                while (i2 < configs.length) {
                    results.add(configs[i2]);
                    ++i2;
                }
            }
            if ((services = Service.this.lookupAllSiblingServices(identifier, this.session)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            if ((services = this.session.process.context.lookupAll(identifier)) != null) {
                i = 0;
                while (i < services.length) {
                    results.add(services[i]);
                    ++i;
                }
            }
            return results.toArray();
        }

        protected ISessionContext getSessionContext() {
            return this.session.context;
        }
    }
}

