/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.Collection;
import java.util.Set;
import org.eclipse.vtp.framework.engine.runtime.Execution;
import org.eclipse.vtp.framework.engine.runtime.Process;
import org.eclipse.vtp.framework.engine.runtime.Scope;
import org.eclipse.vtp.framework.engine.support.AbstractSessionContext;
import org.eclipse.vtp.framework.spi.IExecution;
import org.eclipse.vtp.framework.spi.IExecutionDescriptor;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.ISession;
import org.eclipse.vtp.framework.spi.ISessionDescriptor;

public class Session
extends Scope
implements ISession {
    protected final Process process;
    protected final Context context;

    public Session(Process process, ISessionDescriptor descriptor) throws NullPointerException {
        if (process == null) {
            throw new NullPointerException("process");
        }
        this.process = process;
        this.context = new Context(descriptor);
    }

    protected Collection getServices(String identifier) {
        return this.process.blueprint.getSessionServices(identifier);
    }

    public String getSessionID() {
        return this.context.getSessionID();
    }

    public Object lookupService(String identifier) throws NullPointerException {
        return this.context.lookup(identifier);
    }

    public Object[] lookupAllServices(String identifier) throws NullPointerException {
        return this.context.lookupAll(identifier);
    }

    public IExecution createExecution(IExecutionDescriptor descriptor) throws NullPointerException {
        return new Execution(this, descriptor);
    }

    public IProcess getProcess() {
        return this.process;
    }

    protected final class Context
    extends AbstractSessionContext {
        Context(ISessionDescriptor descriptor) throws NullPointerException {
            super(Session.this.process.context, descriptor);
        }

        ISessionDescriptor getDescriptor() {
            return this.descriptor;
        }

        Set getProvidedServiceIdentifiers() {
            return this.providedServiceIdentifiers;
        }

        protected Object lookupLocalService(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            if (provided == null) {
                return Session.this.lookupInScope(identifier);
            }
            return provided;
        }

        protected Object[] lookupAllLocalServices(String identifier) {
            Object provided = super.lookupLocalService(identifier);
            Object[] all = Session.this.lookupAllInScope(identifier);
            if (provided == null) {
                return all;
            }
            Object[] result = new Object[all.length];
            result[0] = provided;
            System.arraycopy(all, 0, result, 1, all.length);
            return result;
        }
    }
}

