/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.engine.support.AbstractContext;
import org.eclipse.vtp.framework.engine.support.AbstractExecutionContext;

public abstract class AbstractActionContext
extends AbstractContext
implements IActionContext {
    protected static final Set RESERVED_SERVICE_IDENTIFIERS;
    protected final IExecutionContext executionContext;

    static {
        HashSet<String> identifiers = new HashSet<String>(AbstractExecutionContext.RESERVED_SERVICE_IDENTIFIERS.size() + 1);
        identifiers.addAll(AbstractExecutionContext.RESERVED_SERVICE_IDENTIFIERS);
        identifiers.add(IActionContext.class.getName());
        RESERVED_SERVICE_IDENTIFIERS = Collections.unmodifiableSet(identifiers);
    }

    protected AbstractActionContext(IExecutionContext executionContext) throws NullPointerException {
        if (executionContext == null) {
            throw new NullPointerException("executionContext");
        }
        this.executionContext = executionContext;
    }

    protected void doReport(int severity, String[] categories, String message, Dictionary properties) {
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (((Dictionary)properties).get("scope") == null) {
            ((Dictionary)properties).put("scope", "action");
        }
        ((Dictionary)properties).put("action.id", this.getActionID());
        ((Dictionary)properties).put("action.name", this.getActionName());
        this.executionContext.report(severity, categories, message, properties);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.executionContext.isSeverityEnabled(severity);
    }

    protected Object lookupReservedService(String identifier) {
        if (RESERVED_SERVICE_IDENTIFIERS.contains(identifier)) {
            return this;
        }
        return null;
    }

    protected Object lookupInheritedService(String identifier) {
        return this.executionContext.lookup(identifier);
    }

    protected Object[] lookupAllInheritedServices(String identifier) {
        return this.executionContext.lookupAll(identifier);
    }

    public final String getProcessID() {
        return this.executionContext.getProcessID();
    }

    public final Object getProperty(String propertyName) throws NullPointerException {
        return this.executionContext.getProperty(propertyName);
    }

    public final Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.executionContext.loadClass(className);
    }

    public final String getSessionID() {
        return this.executionContext.getSessionID();
    }

    public final String[] getAttributeNames() {
        return this.executionContext.getAttributeNames();
    }

    public final Object getAttribute(String attributeName) throws NullPointerException {
        return this.executionContext.getAttribute(attributeName);
    }

    public final void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.executionContext.setAttribute(attributeName, attributeValue);
    }

    public final void clearAttribute(String attributeName) throws NullPointerException {
        this.executionContext.clearAttribute(attributeName);
    }

    public final String getExecutionID() {
        return this.executionContext.getExecutionID();
    }

    public final String[] getParameterNames() {
        return this.executionContext.getParameterNames();
    }

    public final String getParameter(String parameterName) throws NullPointerException {
        return this.executionContext.getParameter(parameterName);
    }

    public final String[] getParameters(String parameterName) throws NullPointerException {
        return this.executionContext.getParameters(parameterName);
    }

    public void setParameter(String parameterName, String value) throws NullPointerException {
        this.executionContext.setParameter(parameterName, value);
    }

    public void setParameters(String parameterName, String[] values) throws NullPointerException {
        this.executionContext.setParameters(parameterName, values);
    }

    public void clearParameter(String parameterName) throws NullPointerException {
        this.executionContext.clearParameter(parameterName);
    }

    public final IActionResult createResult(String resultName) {
        return this.createResult(resultName, null);
    }
}

