/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.engine.support.AbstractContext;
import org.eclipse.vtp.framework.engine.support.AbstractSessionContext;
import org.eclipse.vtp.framework.spi.IExecutionDescriptor;

public abstract class AbstractExecutionContext
extends AbstractContext
implements IExecutionContext {
    protected static final Set RESERVED_SERVICE_IDENTIFIERS;
    protected final ISessionContext sessionContext;
    protected final IExecutionDescriptor descriptor;
    protected final Set providedServiceIdentifiers;

    static {
        HashSet<String> identifiers = new HashSet<String>(AbstractSessionContext.RESERVED_SERVICE_IDENTIFIERS.size() + 1);
        identifiers.addAll(AbstractSessionContext.RESERVED_SERVICE_IDENTIFIERS);
        identifiers.add(IExecutionContext.class.getName());
        RESERVED_SERVICE_IDENTIFIERS = Collections.unmodifiableSet(identifiers);
    }

    protected AbstractExecutionContext(ISessionContext sessionContext, IExecutionDescriptor descriptor) throws NullPointerException {
        if (sessionContext == null) {
            throw new NullPointerException("sessionContext");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.sessionContext = sessionContext;
        this.descriptor = descriptor;
        this.providedServiceIdentifiers = Collections.unmodifiableSet(new HashSet(Arrays.asList(descriptor.getServiceIdentifiers())));
    }

    protected void doReport(int severity, String[] categories, String message, Dictionary properties) {
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (((Dictionary)properties).get("scope") == null) {
            ((Dictionary)properties).put("scope", "execution");
        }
        ((Dictionary)properties).put("execution.id", this.getExecutionID());
        this.sessionContext.report(severity, categories, message, properties);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.sessionContext.isSeverityEnabled(severity);
    }

    protected Object lookupReservedService(String identifier) {
        if (RESERVED_SERVICE_IDENTIFIERS.contains(identifier)) {
            return this;
        }
        return null;
    }

    protected Object lookupLocalService(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return this.descriptor.getService(identifier);
        }
        return null;
    }

    protected Object[] lookupAllLocalServices(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return new Object[]{this.descriptor.getService(identifier)};
        }
        return null;
    }

    protected Object lookupInheritedService(String identifier) {
        return this.sessionContext.lookup(identifier);
    }

    protected Object[] lookupAllInheritedServices(String identifier) {
        return this.sessionContext.lookupAll(identifier);
    }

    public final String getProcessID() {
        return this.sessionContext.getProcessID();
    }

    public final Object getProperty(String propertyName) throws NullPointerException {
        return this.sessionContext.getProperty(propertyName);
    }

    public final Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.sessionContext.loadClass(className);
    }

    public final String getSessionID() {
        return this.sessionContext.getSessionID();
    }

    public final String[] getAttributeNames() {
        return this.sessionContext.getAttributeNames();
    }

    public final Object getAttribute(String attributeName) throws NullPointerException {
        return this.sessionContext.getAttribute(attributeName);
    }

    public final void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.sessionContext.setAttribute(attributeName, attributeValue);
    }

    public final void clearAttribute(String attributeName) throws NullPointerException {
        this.sessionContext.clearAttribute(attributeName);
    }

    public final String getExecutionID() {
        return this.descriptor.getExecutionID();
    }

    public final String[] getParameterNames() {
        return this.descriptor.getParameterNames();
    }

    public final String getParameter(String parameterName) throws NullPointerException {
        return this.descriptor.getParameter(parameterName);
    }

    public final String[] getParameters(String parameterName) throws NullPointerException {
        return this.descriptor.getParameters(parameterName);
    }

    public void setParameter(String parameterName, String value) throws NullPointerException {
        this.descriptor.setParameter(parameterName, value);
    }

    public void setParameters(String parameterName, String[] values) throws NullPointerException {
        this.descriptor.setParameters(parameterName, values);
    }

    public void clearParameter(String parameterName) throws NullPointerException {
        this.descriptor.clearParameter(parameterName);
    }
}

