/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.core.ILogger;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.support.AbstractContext;
import org.eclipse.vtp.framework.spi.IProcessDescriptor;

public abstract class AbstractProcessContext
extends AbstractContext
implements IProcessContext {
    protected static final Set RESERVED_SERVICE_IDENTIFIERS;
    protected final IProcessDescriptor descriptor;
    protected final Set providedServiceIdentifiers;

    static {
        HashSet<String> identifiers = new HashSet<String>(4);
        identifiers.add(IReporter.class.getName());
        identifiers.add(ILogger.class.getName());
        identifiers.add(IContext.class.getName());
        identifiers.add(IProcessContext.class.getName());
        RESERVED_SERVICE_IDENTIFIERS = Collections.unmodifiableSet(identifiers);
    }

    protected AbstractProcessContext(IProcessDescriptor descriptor) throws NullPointerException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.descriptor = descriptor;
        this.providedServiceIdentifiers = Collections.unmodifiableSet(new HashSet(Arrays.asList(descriptor.getServiceIdentifiers())));
    }

    protected void doReport(int severity, String[] categories, String message, Dictionary properties) {
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (((Dictionary)properties).get("scope") == null) {
            ((Dictionary)properties).put("scope", "process");
        }
        ((Dictionary)properties).put("process.id", this.getProcessID());
        this.descriptor.report(severity, categories, message, properties);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.descriptor.isSeverityEnabled(severity);
    }

    protected Object lookupReservedService(String identifier) {
        if (RESERVED_SERVICE_IDENTIFIERS.contains(identifier)) {
            return this;
        }
        return null;
    }

    protected Object lookupLocalService(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return this.descriptor.getService(identifier);
        }
        return null;
    }

    protected Object[] lookupAllLocalServices(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return new Object[]{this.descriptor.getService(identifier)};
        }
        return null;
    }

    public final String getProcessID() {
        return this.descriptor.getProcessID();
    }

    public final Object getProperty(String propertyName) throws NullPointerException {
        return this.descriptor.getProperty(propertyName);
    }

    public final Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.descriptor.loadClass(className);
    }
}

