/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.engine.support.AbstractContext;
import org.eclipse.vtp.framework.engine.support.AbstractProcessContext;
import org.eclipse.vtp.framework.spi.ISessionDescriptor;

public abstract class AbstractSessionContext
extends AbstractContext
implements ISessionContext {
    protected static final Set RESERVED_SERVICE_IDENTIFIERS;
    protected final IProcessContext processContext;
    protected final ISessionDescriptor descriptor;
    protected final Set providedServiceIdentifiers;

    static {
        HashSet<String> identifiers = new HashSet<String>(AbstractProcessContext.RESERVED_SERVICE_IDENTIFIERS.size() + 1);
        identifiers.addAll(AbstractProcessContext.RESERVED_SERVICE_IDENTIFIERS);
        identifiers.add(ISessionContext.class.getName());
        RESERVED_SERVICE_IDENTIFIERS = Collections.unmodifiableSet(identifiers);
    }

    protected AbstractSessionContext(IProcessContext processContext, ISessionDescriptor descriptor) throws NullPointerException {
        if (processContext == null) {
            throw new NullPointerException("processContext");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.processContext = processContext;
        this.descriptor = descriptor;
        this.providedServiceIdentifiers = Collections.unmodifiableSet(new HashSet(Arrays.asList(descriptor.getServiceIdentifiers())));
    }

    protected void doReport(int severity, String[] categories, String message, Dictionary properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        if (((Dictionary)properties).get("scope") == null) {
            ((Dictionary)properties).put("scope", "session");
        }
        ((Dictionary)properties).put("session.id", this.getSessionID());
        Object value = this.getAttribute("span.dialog");
        if (value != null) {
            ((Dictionary)properties).put("span.dialog", value);
        }
        if ((value = this.getAttribute("span.dialog.name")) != null) {
            ((Dictionary)properties).put("span.dialog.name", value);
        }
        if ((value = this.getAttribute("span.primitive")) != null) {
            ((Dictionary)properties).put("span.primitive", value);
        }
        if ((value = this.getAttribute("span.primitive.name")) != null) {
            ((Dictionary)properties).put("span.primitive.name", value);
        }
        this.processContext.report(severity, categories, message, properties);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.processContext.isSeverityEnabled(severity);
    }

    protected Object lookupReservedService(String identifier) {
        if (RESERVED_SERVICE_IDENTIFIERS.contains(identifier)) {
            return this;
        }
        return null;
    }

    protected Object lookupLocalService(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return this.descriptor.getService(identifier);
        }
        return null;
    }

    protected Object[] lookupAllLocalServices(String identifier) {
        if (this.providedServiceIdentifiers.contains(identifier)) {
            return new Object[]{this.descriptor.getService(identifier)};
        }
        return null;
    }

    protected Object lookupInheritedService(String identifier) {
        return this.processContext.lookup(identifier);
    }

    protected Object[] lookupAllInheritedServices(String identifier) {
        return this.processContext.lookupAll(identifier);
    }

    public final String getProcessID() {
        return this.processContext.getProcessID();
    }

    public final Object getProperty(String propertyName) throws NullPointerException {
        return this.processContext.getProperty(propertyName);
    }

    public final Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.processContext.loadClass(className);
    }

    public final String getSessionID() {
        return this.descriptor.getSessionID();
    }

    public final String[] getAttributeNames() {
        return this.descriptor.getAttributeNames();
    }

    public final Object getAttribute(String attributeName) throws NullPointerException {
        return this.descriptor.getAttribute(attributeName);
    }

    public final void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.descriptor.setAttribute(attributeName, attributeValue);
    }

    public final void clearAttribute(String attributeName) throws NullPointerException {
        this.descriptor.clearAttribute(attributeName);
    }
}

