/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Dictionary;
import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.engine.support.AbstractExecutionContext;

public abstract class ExecutionContextWrapper
implements IExecutionContext {
    protected ExecutionContextWrapper() {
    }

    protected boolean isReservedIdentifier(String identifier) {
        return AbstractExecutionContext.RESERVED_SERVICE_IDENTIFIERS.contains(identifier);
    }

    protected abstract IExecutionContext getExecutionContext();

    public boolean isSeverityEnabled(int severity) {
        return this.getExecutionContext().isSeverityEnabled(severity);
    }

    public void report(int severity, String message) {
        this.getExecutionContext().report(severity, message);
    }

    public void report(int severity, String message, Dictionary properties) {
        this.getExecutionContext().report(severity, message, properties);
    }

    public void report(int severity, String[] categories, String message) {
        this.getExecutionContext().report(severity, categories, message);
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().report(severity, categories, message, properties);
    }

    public void log(int severity, String message) {
        this.getExecutionContext().log(severity, message);
    }

    public void log(int severity, String message, Dictionary properties) {
        this.getExecutionContext().log(severity, message, properties);
    }

    public void log(int severity, String[] categories, String message) {
        this.getExecutionContext().log(severity, categories, message);
    }

    public void log(int severity, String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().log(severity, categories, message, properties);
    }

    public boolean isErrorEnabled() {
        return this.getExecutionContext().isErrorEnabled();
    }

    public void error(String message) {
        this.getExecutionContext().error(message);
    }

    public void error(String message, Dictionary properties) {
        this.getExecutionContext().error(message, properties);
    }

    public void error(String[] categories, String message) {
        this.getExecutionContext().error(categories, message);
    }

    public void error(String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().error(categories, message, properties);
    }

    public boolean isWarnEnabled() {
        return this.getExecutionContext().isWarnEnabled();
    }

    public void warn(String message) {
        this.getExecutionContext().warn(message);
    }

    public void warn(String message, Dictionary properties) {
        this.getExecutionContext().warn(message, properties);
    }

    public void warn(String[] categories, String message) {
        this.getExecutionContext().warn(categories, message);
    }

    public void warn(String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().warn(categories, message, properties);
    }

    public boolean isInfoEnabled() {
        return this.getExecutionContext().isInfoEnabled();
    }

    public void info(String message) {
        this.getExecutionContext().info(message);
    }

    public void info(String message, Dictionary properties) {
        this.getExecutionContext().info(message, properties);
    }

    public void info(String[] categories, String message) {
        this.getExecutionContext().info(categories, message);
    }

    public void info(String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().info(categories, message, properties);
    }

    public boolean isDebugEnabled() {
        return this.getExecutionContext().isDebugEnabled();
    }

    public void debug(String message) {
        this.getExecutionContext().debug(message);
    }

    public void debug(String message, Dictionary properties) {
        this.getExecutionContext().debug(message, properties);
    }

    public void debug(String[] categories, String message) {
        this.getExecutionContext().debug(categories, message);
    }

    public void debug(String[] categories, String message, Dictionary properties) {
        this.getExecutionContext().debug(categories, message, properties);
    }

    public Object lookup(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return this;
        }
        return this.getExecutionContext().lookup(identifier);
    }

    public Object[] lookupAll(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return new Object[]{this};
        }
        return this.getExecutionContext().lookupAll(identifier);
    }

    public String getProcessID() {
        return this.getExecutionContext().getProcessID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.getExecutionContext().getProperty(propertyName);
    }

    public Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.getExecutionContext().loadClass(className);
    }

    public String getSessionID() {
        return this.getExecutionContext().getSessionID();
    }

    public String[] getAttributeNames() {
        return this.getExecutionContext().getAttributeNames();
    }

    public Object getAttribute(String attributeName) throws NullPointerException {
        return this.getExecutionContext().getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.getExecutionContext().setAttribute(attributeName, attributeValue);
    }

    public void clearAttribute(String attributeName) throws NullPointerException {
        this.getExecutionContext().clearAttribute(attributeName);
    }

    public String getExecutionID() {
        return this.getExecutionContext().getExecutionID();
    }

    public String[] getParameterNames() {
        return this.getExecutionContext().getParameterNames();
    }

    public String getParameter(String parameterName) throws NullPointerException {
        return this.getExecutionContext().getParameter(parameterName);
    }

    public String[] getParameters(String parameterName) throws NullPointerException {
        return this.getExecutionContext().getParameters(parameterName);
    }

    public void setParameter(String parameterName, String value) throws NullPointerException {
        this.getExecutionContext().setParameter(parameterName, value);
    }

    public void setParameters(String parameterName, String[] values) throws NullPointerException {
        this.getExecutionContext().setParameters(parameterName, values);
    }

    public void clearParameter(String parameterName) throws NullPointerException {
        this.getExecutionContext().clearParameter(parameterName);
    }
}

