/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConstants;
import org.eclipse.vtp.framework.databases.configurations.DatabaseCriteriaConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseMappingConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseQueryConfiguration
implements IConfiguration,
DatabaseConstants {
    private String database = "";
    private String table = "";
    private String resultName = "";
    private String resultType = null;
    private boolean resultArray = true;
    private int resultLimit = 0;
    private final Set criteria = new LinkedHashSet();
    private final Set mappings = new LinkedHashSet();
    private int queryTimeout = 0;

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database == null ? "" : database;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table == null ? "" : table;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName == null ? "" : resultName;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public boolean isResultArray() {
        return this.resultArray;
    }

    public void setResultArray(boolean resultArray) {
        this.resultArray = resultArray;
    }

    public int getResultLimit() {
        return this.resultLimit;
    }

    public void setResultLimit(int resultLimit) {
        this.resultLimit = resultLimit < 0 ? 0 : resultLimit;
    }

    public DatabaseCriteriaConfiguration[] getCriteria() {
        return this.criteria.toArray(new DatabaseCriteriaConfiguration[this.criteria.size()]);
    }

    public void addCriteria(DatabaseCriteriaConfiguration criteria) {
        if (criteria != null) {
            this.criteria.add(criteria);
        }
    }

    public void removeCriteria(DatabaseCriteriaConfiguration criteria) {
        if (criteria != null) {
            this.criteria.remove(criteria);
        }
    }

    public DatabaseMappingConfiguration[] getMappings() {
        return this.mappings.toArray(new DatabaseMappingConfiguration[this.mappings.size()]);
    }

    public void addMapping(DatabaseMappingConfiguration mapping) {
        if (mapping != null) {
            this.mappings.add(mapping);
        }
    }

    public void removeMapping(DatabaseMappingConfiguration mapping) {
        if (mapping != null) {
            this.mappings.remove(mapping);
        }
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = Math.max(0, queryTimeout);
    }

    public void load(Element configurationElement) {
        DatabaseConstants item;
        Element element;
        this.database = configurationElement.getAttribute("database");
        this.table = configurationElement.getAttribute("table");
        this.resultName = configurationElement.getAttribute("result-name");
        this.resultType = configurationElement.hasAttribute("result-type") ? configurationElement.getAttribute("result-type") : null;
        this.resultArray = "many".equalsIgnoreCase(configurationElement.getAttribute("result-cardinality"));
        this.resultLimit = configurationElement.hasAttribute("result-limit") ? Integer.parseInt(configurationElement.getAttribute("result-limit")) : 0;
        this.criteria.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "criteria");
        int i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            item = new DatabaseCriteriaConfiguration();
            ((DatabaseCriteriaConfiguration)item).load(element);
            this.criteria.add(item);
            ++i;
        }
        this.mappings.clear();
        list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "mapping");
        i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            item = new DatabaseMappingConfiguration();
            ((DatabaseMappingConfiguration)item).load(element);
            this.mappings.add(item);
            ++i;
        }
        if (configurationElement.hasAttribute("timeout")) {
            this.setQueryTimeout(Integer.parseInt(configurationElement.getAttribute("timeout")));
        }
    }

    public void save(Element configurationElement) {
        Element element;
        configurationElement.setAttribute("database", this.database);
        configurationElement.setAttribute("table", this.table);
        configurationElement.setAttribute("result-name", this.resultName);
        if (this.resultType != null) {
            configurationElement.setAttribute("result-type", this.resultType);
        }
        if (this.resultArray) {
            configurationElement.setAttribute("result-cardinality", "many");
        }
        if (this.resultLimit > 0) {
            configurationElement.setAttribute("result-limit", String.valueOf(this.resultLimit));
        }
        String criteriaName = "criteria";
        String mappingName = "mapping";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            criteriaName = String.valueOf(prefix) + ":" + criteriaName;
            mappingName = String.valueOf(prefix) + ":" + mappingName;
        }
        for (DatabaseConstants item : this.criteria) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", criteriaName);
            ((DatabaseCriteriaConfiguration)item).save(element);
            configurationElement.appendChild(element);
        }
        for (DatabaseConstants item : this.mappings) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", mappingName);
            ((DatabaseMappingConfiguration)item).save(element);
            configurationElement.appendChild(element);
        }
        if (this.queryTimeout != 0) {
            configurationElement.setAttribute("timeout", String.valueOf(this.queryTimeout));
        }
    }
}

