/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseColumnConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseTableConfiguration
implements IConfiguration,
DatabaseConstants {
    private String name = "";
    private Set columns = new LinkedHashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public DatabaseColumnConfiguration[] getColumns() {
        return this.columns.toArray(new DatabaseColumnConfiguration[this.columns.size()]);
    }

    public void addColumn(DatabaseColumnConfiguration column) {
        if (column != null) {
            this.columns.add(column);
        }
    }

    public void removeColumn(DatabaseColumnConfiguration column) {
        if (column != null) {
            this.columns.remove(column);
        }
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.columns.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "column");
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            DatabaseColumnConfiguration item = new DatabaseColumnConfiguration();
            item.load(element);
            this.columns.add(item);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        String columnName = "column";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            columnName = String.valueOf(prefix) + ":" + columnName;
        }
        for (DatabaseColumnConfiguration item : this.columns) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", columnName);
            item.save(element);
            configurationElement.appendChild(element);
        }
    }
}

