/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.projects.core.IMediaProject;
import org.eclipse.vtp.desktop.projects.core.MediaProjectFactory;
import org.osgi.framework.Bundle;

public class MediaProjectManager {
    public static final String mediaProjectExtensionId = "org.eclipse.vtp.desktop.projects.core.mediaProjects";
    private static final MediaProjectManager INSTANCE = new MediaProjectManager();
    private Map natures = new HashMap();

    public static MediaProjectManager getInstance() {
        return INSTANCE;
    }

    public MediaProjectManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaProjectExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            block3: {
                MediaProjectRecord mpr = new MediaProjectRecord();
                mpr.id = primitiveExtensions[i].getAttribute("id");
                mpr.name = primitiveExtensions[i].getAttribute("name");
                mpr.nature = primitiveExtensions[i].getAttribute("nature-id");
                mpr.interactionType = primitiveExtensions[i].getAttribute("interaction-type");
                String className = primitiveExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
                try {
                    mpr.factory = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block3;
                }
                this.natures.put(mpr.nature, mpr);
            }
            ++i;
        }
    }

    public boolean isMediaProject(IProject project) {
        boolean isMediaProject = false;
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                if (!(isMediaProject |= this.natures.get(natureIds[i]) != null)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isMediaProject;
    }

    public IMediaProject convertToMediaProject(IProject project) {
        IMediaProject ret = null;
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                MediaProjectRecord mpr = (MediaProjectRecord)this.natures.get(natureIds[i]);
                if (mpr != null) {
                    MediaProjectFactory factory = (MediaProjectFactory)mpr.factory.newInstance();
                    ret = factory.createMediaProject(project);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private class MediaProjectRecord {
        String id;
        String name;
        String nature;
        String interactionType;
        Class factory;

        private MediaProjectRecord() {
        }
    }
}

