/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.projects.core.export.ExportWebappPage;
import org.eclipse.vtp.desktop.projects.core.export.Exporter;
import org.eclipse.vtp.framework.databases.configurations.DatabaseColumnConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseTableConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JdbcDatabaseConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JndiDatabaseConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigureDatabasesPage
extends ExportWebappPage
implements ISelectionChangedListener,
ModifyListener,
SelectionListener,
ITreeContentProvider,
ILabelProvider {
    private static final Comparator RESOURCE_COMPARE = new Comparator(){

        public int compare(Object left, Object right) {
            return ((IResource)left).getFullPath().toString().compareTo(((IResource)right).getFullPath().toString());
        }
    };
    private final Map settings;
    private Map selectedDatabase = null;
    private TreeViewer viewer = null;
    private Combo typeCombo = null;
    private Composite stackComposite = null;
    private StackLayout stackLayout = null;
    private Composite jndiComposite = null;
    private Text jndiUriText = null;
    private Text jndiUsrText = null;
    private Text jndiPwdText = null;
    private Composite jdbcComposite = null;
    private Text jdbcDvrText = null;
    private Text jdbcUrlText = null;
    private Text jdbcUsrText = null;
    private Text jdbcPwdText = null;
    private Composite emptyComposite = null;

    public ConfigureDatabasesPage(Exporter exporter) {
        super("ConfigureDatabasesPage", "Configure the Exported Database Connections", null, exporter);
        try {
            String[] applicationProjectNames = exporter.getApplicationProjectNames();
            String[] fragmentProjectNames = exporter.getFragmentProjectNames();
            String[] names = new String[applicationProjectNames.length + fragmentProjectNames.length];
            System.arraycopy(applicationProjectNames, 0, names, 0, applicationProjectNames.length);
            System.arraycopy(fragmentProjectNames, 0, names, applicationProjectNames.length, fragmentProjectNames.length);
            TreeMap settings = new TreeMap(RESOURCE_COMPARE);
            int i = 0;
            while (i < names.length) {
                IFolder databases;
                IProject project = exporter.getProject(names[i]);
                if (project != null && (databases = project.getFolder("Databases")) != null && databases.exists()) {
                    IResource[] children = null;
                    try {
                        children = databases.members();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (children != null && children.length != 0) {
                        TreeMap folders = new TreeMap(RESOURCE_COMPARE);
                        int j = 0;
                        while (j < children.length) {
                            if (2 == children[j].getType()) {
                                folders.put(children[j], null);
                            }
                            ++j;
                        }
                        if (!folders.isEmpty()) {
                            settings.put(project, folders);
                        }
                    }
                }
                ++i;
            }
            this.settings = Collections.unmodifiableMap(settings);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void loadDefaults(String projectName, String folderName, Map properties) {
        String prefix = "db." + folderName + ".";
        String type = this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "type");
        type = "jdbc".equalsIgnoreCase(type) ? "jdbc" : "jndi";
        properties.put("type", type);
        properties.put("dvr", this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "dvr"));
        properties.put("url", this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "url"));
        String uri = this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "uri");
        if (uri.length() == 0) {
            uri = "java:comp/env/jdbc/" + folderName;
        }
        properties.put("uri", uri);
        properties.put("usr", this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "usr"));
        properties.put("pwd", this.exporter.getProjectProperty(projectName, String.valueOf(prefix) + "pwd", true));
    }

    private void resetStack() {
        String type = (String)this.selectedDatabase.get("type");
        if ("jndi".equalsIgnoreCase(type)) {
            this.typeCombo.select(0);
            this.stackLayout.topControl = this.jndiComposite;
            this.stackComposite.layout();
            this.jndiUriText.setText((String)this.selectedDatabase.get("uri"));
            this.jndiUsrText.setText((String)this.selectedDatabase.get("usr"));
            this.jndiPwdText.setText((String)this.selectedDatabase.get("pwd"));
        } else if ("jdbc".equalsIgnoreCase(type)) {
            this.typeCombo.select(1);
            this.stackLayout.topControl = this.jdbcComposite;
            this.stackComposite.layout();
            this.jdbcDvrText.setText((String)this.selectedDatabase.get("dvr"));
            this.jdbcUrlText.setText((String)this.selectedDatabase.get("url"));
            this.jdbcUsrText.setText((String)this.selectedDatabase.get("usr"));
            this.jdbcPwdText.setText((String)this.selectedDatabase.get("pwd"));
        }
    }

    public void createControl(Composite parent) {
        SashForm root = new SashForm(parent, 256);
        this.viewer = new TreeViewer((Composite)root, 2048);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.exporter);
        this.viewer.expandAll();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite composite = new Composite((Composite)root, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label typeLabel = new Label(composite, 0);
        typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        typeLabel.setText("Database lookup method:");
        this.typeCombo = new Combo(composite, 12);
        this.typeCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.typeCombo.add("JNDI Lookup");
        this.typeCombo.add("JDBC Driver");
        this.typeCombo.addSelectionListener((SelectionListener)this);
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.stackComposite = new Composite(composite, 0);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.jndiComposite = new Composite(this.stackComposite, 0);
        this.jndiComposite.setLayout((Layout)new GridLayout(2, false));
        Label jndiUriLabel = new Label(this.jndiComposite, 0);
        jndiUriLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jndiUriLabel.setText("JNDI URI:");
        this.jndiUriText = new Text(this.jndiComposite, 2048);
        this.jndiUriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jndiUriText.addModifyListener((ModifyListener)this);
        Label jndiUsrLabel = new Label(this.jndiComposite, 0);
        jndiUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jndiUsrLabel.setText("User Name:");
        this.jndiUsrText = new Text(this.jndiComposite, 2048);
        this.jndiUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jndiUsrText.addModifyListener((ModifyListener)this);
        Label jndiPwdLabel = new Label(this.jndiComposite, 0);
        jndiPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jndiPwdLabel.setText("Password:");
        this.jndiPwdText = new Text(this.jndiComposite, 2048);
        this.jndiPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jndiPwdText.addModifyListener((ModifyListener)this);
        this.jdbcComposite = new Composite(this.stackComposite, 0);
        this.jdbcComposite.setLayout((Layout)new GridLayout(2, false));
        Label jdbcDvrLabel = new Label(this.jdbcComposite, 0);
        jdbcDvrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jdbcDvrLabel.setText("JDBC Driver:");
        this.jdbcDvrText = new Text(this.jdbcComposite, 2048);
        this.jdbcDvrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jdbcDvrText.addModifyListener((ModifyListener)this);
        Label jdbcUrlLabel = new Label(this.jdbcComposite, 0);
        jdbcUrlLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jdbcUrlLabel.setText("JDBC URL:");
        this.jdbcUrlText = new Text(this.jdbcComposite, 2048);
        this.jdbcUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jdbcUrlText.addModifyListener((ModifyListener)this);
        Label jdbcUsrLabel = new Label(this.jdbcComposite, 0);
        jdbcUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jdbcUsrLabel.setText("User Name:");
        this.jdbcUsrText = new Text(this.jdbcComposite, 2048);
        this.jdbcUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jdbcUsrText.addModifyListener((ModifyListener)this);
        Label jdbcPwdLabel = new Label(this.jdbcComposite, 0);
        jdbcPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        jdbcPwdLabel.setText("Password:");
        this.jdbcPwdText = new Text(this.jdbcComposite, 2048);
        this.jdbcPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.jdbcPwdText.addModifyListener((ModifyListener)this);
        this.emptyComposite = new Composite(this.stackComposite, 0);
        this.stackLayout.topControl = this.emptyComposite;
        root.setWeights(new int[]{40, 60});
        this.setControl((Control)root);
        this.projectSelectionChanged(this.exporter);
    }

    public boolean needsToBeShown() {
        Iterator i = this.settings.keySet().iterator();
        while (i.hasNext()) {
            if (!this.exporter.isProjectSelected(((IProject)i.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public void projectSelectionChanged(Exporter exporter) {
        if (this.viewer == null) {
            return;
        }
        this.viewer.refresh();
        this.viewer.expandAll();
        if (this.viewer.getSelection().isEmpty() && !this.settings.isEmpty()) {
            Map folders;
            IProject project = null;
            Iterator i = this.settings.keySet().iterator();
            while (project == null && i.hasNext()) {
                IProject p = (IProject)i.next();
                if (!exporter.isProjectSelected(p.getName())) continue;
                project = p;
            }
            if (project != null && !(folders = (Map)this.settings.get(project)).isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(folders.keySet().iterator().next()));
            }
        }
    }

    public void savePrefrences() {
        for (IProject project : this.settings.keySet()) {
            if (!this.exporter.isProjectSelected(project.getName())) continue;
            Map folders = (Map)this.settings.get(project);
            for (IFolder folder : folders.keySet()) {
                Map config = (Map)folders.get(folder);
                if (config == null) continue;
                String prefix = "db." + folder.getName() + ".";
                for (Map.Entry entry : config.entrySet()) {
                    this.exporter.setProjectProperty(project.getName(), String.valueOf(prefix) + entry.getKey(), (String)entry.getValue(), "pwd".equals(entry.getKey()));
                }
            }
        }
    }

    public void createServiceConfigurations(String projectName, Element servicesElement) {
        Element serviceElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:service");
        serviceElement.setAttribute("id", "org.eclipse.vtp.framework.databases.services.database-registry");
        for (Map.Entry projectEntry : this.settings.entrySet()) {
            IProject project = (IProject)projectEntry.getKey();
            if (!this.exporter.isProjectSelected(project.getName())) continue;
            Map folders = (Map)projectEntry.getValue();
            for (Map.Entry folderEntry : folders.entrySet()) {
                String pwd;
                IFolder folder = (IFolder)folderEntry.getKey();
                HashMap properties = (HashMap)folderEntry.getValue();
                if (properties == null) {
                    properties = new HashMap();
                    this.loadDefaults(project.getName(), folder.getName(), properties);
                }
                JndiDatabaseConfiguration database = null;
                Element databaseElement = null;
                if ("jdbc".equals(properties.get("type"))) {
                    JdbcDatabaseConfiguration jdbc = new JdbcDatabaseConfiguration();
                    jdbc.setDriver((String)properties.get("dvr"));
                    jdbc.setUrl((String)properties.get("url"));
                    database = jdbc;
                    databaseElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "database:jdbc-database");
                } else {
                    JndiDatabaseConfiguration jndi = new JndiDatabaseConfiguration();
                    jndi.setUri((String)properties.get("uri"));
                    database = jndi;
                    databaseElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "database:jndi-database");
                }
                database.setName(folder.getName());
                String usr = (String)properties.get("usr");
                if (usr.length() > 0) {
                    database.setUsername(usr);
                }
                if ((pwd = (String)properties.get("pwd")).length() > 0) {
                    database.setPassword(this.exporter.encrypt(pwd));
                }
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    IResource[] files = folder.members();
                    int k = 0;
                    while (k < files.length) {
                        if (1 == files[k].getType()) {
                            Element root = builder.parse(((IFile)files[k]).getLocation().toFile()).getDocumentElement();
                            DatabaseTableConfiguration table = new DatabaseTableConfiguration();
                            table.setName(root.getAttribute("name"));
                            NodeList list = ((Element)root.getElementsByTagName("columns").item(0)).getElementsByTagName("column");
                            int m = 0;
                            while (m < list.getLength()) {
                                Element element = (Element)list.item(m);
                                DatabaseColumnConfiguration column = new DatabaseColumnConfiguration();
                                column.setName(element.getAttribute("name"));
                                String type = ((Element)element.getElementsByTagName("column-type").item(0)).getAttribute("type");
                                if ("Varchar".equalsIgnoreCase(type)) {
                                    column.setType(8);
                                } else if ("Number".equalsIgnoreCase(type)) {
                                    column.setType(6);
                                } else if ("Big Number".equalsIgnoreCase(type)) {
                                    column.setType(2);
                                } else if ("Decimal".equalsIgnoreCase(type)) {
                                    column.setType(5);
                                } else if ("Big Decimal".equalsIgnoreCase(type)) {
                                    column.setType(1);
                                } else if ("Boolean".equalsIgnoreCase(type)) {
                                    column.setType(3);
                                } else if ("DateTime".equalsIgnoreCase(type)) {
                                    column.setType(4);
                                } else {
                                    column.setType(7);
                                }
                                table.addColumn(column);
                                ++m;
                            }
                            database.addTable(table);
                        }
                        ++k;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                database.save(databaseElement);
                serviceElement.appendChild(databaseElement);
            }
        }
        servicesElement.appendChild(serviceElement);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object value = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            value = selection.getFirstElement();
        }
        if (value instanceof IProject) {
            value = null;
        }
        if (value == null) {
            this.selectedDatabase = null;
            this.typeCombo.setEnabled(false);
            this.stackLayout.topControl = this.emptyComposite;
            this.stackComposite.layout();
            return;
        }
        IFolder folder = (IFolder)value;
        IProject project = folder.getProject();
        Map folders = (Map)this.settings.get(project);
        this.selectedDatabase = (Map)folders.get(folder);
        if (this.selectedDatabase == null) {
            this.selectedDatabase = new HashMap();
            folders.put(folder, this.selectedDatabase);
            this.loadDefaults(project.getName(), folder.getName(), this.selectedDatabase);
        }
        this.typeCombo.setEnabled(true);
        this.resetStack();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (this.jndiUriText == source) {
            this.selectedDatabase.put("uri", this.jndiUriText.getText());
        } else if (this.jndiUsrText == source) {
            this.selectedDatabase.put("usr", this.jndiUsrText.getText());
        } else if (this.jndiPwdText == source) {
            this.selectedDatabase.put("pwd", this.jndiPwdText.getText());
        } else if (this.jdbcDvrText == source) {
            this.selectedDatabase.put("dvr", this.jdbcDvrText.getText());
        } else if (this.jdbcUrlText == source) {
            this.selectedDatabase.put("url", this.jdbcUrlText.getText());
        } else if (this.jdbcUsrText == source) {
            this.selectedDatabase.put("usr", this.jdbcUsrText.getText());
        } else if (this.jdbcPwdText == source) {
            this.selectedDatabase.put("pwd", this.jdbcPwdText.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (this.typeCombo == source) {
            switch (this.typeCombo.getSelectionIndex()) {
                case 0: {
                    this.selectedDatabase.put("type", "jndi");
                    break;
                }
                case 1: {
                    this.selectedDatabase.put("type", "jdbc");
                }
            }
            this.resetStack();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IProject> results = new ArrayList<IProject>(this.settings.size());
        for (IProject project : this.settings.keySet()) {
            if (!this.exporter.isProjectSelected(project.getName())) continue;
            results.add(project);
        }
        return results.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            ((IResource)element).getProject();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.settings.containsKey(element);
    }

    public Object[] getChildren(Object parentElement) {
        Map folders = (Map)this.settings.get(parentElement);
        if (folders == null) {
            return new Object[0];
        }
        return folders.keySet().toArray();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public String getText(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        return null;
    }
}

