/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.configurations.BranchConfiguration;
import org.eclipse.vtp.framework.common.configurations.BrandConfiguration;
import org.eclipse.vtp.framework.common.configurations.DataTypeConfiguration;
import org.eclipse.vtp.framework.common.configurations.DispatchConfiguration;
import org.eclipse.vtp.framework.common.configurations.ExitConfiguration;
import org.eclipse.vtp.framework.common.configurations.FieldConfiguration;
import org.eclipse.vtp.framework.common.configurations.ScriptConfiguration;
import org.eclipse.vtp.framework.common.configurations.VariableMappingConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseCriteriaConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseMappingConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseQueryConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.BridgeMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.DataRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.LanguageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderBindingConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionChoiceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SharedContentConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.TransferMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.media.ContentLoadingManager;
import org.eclipse.vtp.framework.media.FormatterRegistration;
import org.eclipse.vtp.framework.media.FormatterRegistrationManager;
import org.eclipse.vtp.framework.media.InputLoadingManager;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceCallConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceInputConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceMappingConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefinitionBuilder {
    static final int CONTEXT_APPLICATION = 1;
    static final int CONTEXT_FRAGMENT = 2;
    static final int CONTEXT_DIALOG = 3;
    static final String NAMESPACE_URI_PROCESS_DEFINITION = "http://eclipse.org/vtp/xml/framework/engine/process-definition";
    static final String NAMESPACE_URI_COMMON = "http://eclipse.org/vtp/xml/framework/common/configurations";
    static final String NAMESPACE_URI_DATABASES = "http://eclipse.org/vtp/xml/framework/databases/configurations";
    static final String NAMESPACE_URI_WEBSERVICES = "http://eclipse.org/vtp/xml/framework/webservices/configurations";
    static final String NAMESPACE_URI_INTERACTIONS_CORE = "http://eclipse.org/vtp/xml/framework/interactions/core/configurations";
    private final Document callDesign;
    private final DocumentBuilder builder;
    private final Document definition;
    private final Element servicesElement;
    private final Element actionsElement;
    private final Element observersElement;
    private final Element transitionsElement;
    private final Map flowElementsByID = new HashMap();

    public DefinitionBuilder(Document callDesign, DocumentBuilder builder, IProject project, Map brands, Map formatterIDsByLanguage, Map resourceManagerIDsByLanguage) throws Exception {
        this.callDesign = callDesign;
        this.builder = builder;
        this.definition = builder.newDocument();
        Element definitionElement = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:definition");
        this.definition.appendChild(definitionElement);
        this.servicesElement = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:services");
        this.actionsElement = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:actions");
        this.observersElement = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:observers");
        this.transitionsElement = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:transitions");
        definitionElement.appendChild(this.servicesElement);
        definitionElement.appendChild(this.actionsElement);
        definitionElement.appendChild(this.observersElement);
        definitionElement.appendChild(this.transitionsElement);
        this.buildServices(project, brands, formatterIDsByLanguage, resourceManagerIDsByLanguage);
        this.buildFlow();
    }

    public Document getDefinition() {
        return this.definition;
    }

    private void buildServices(IProject project, Map brands, Map formatterIDsByLanguage, Map resourceManagerIDsByLanguage) throws Exception {
        Element brandRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.common.services.brand-registry");
        Element defaultBrandElement = this.definition.createElementNS(NAMESPACE_URI_COMMON, "common:brand");
        BrandConfiguration defaultBrand = new BrandConfiguration();
        defaultBrand.setName("Default");
        this.buildBrandConfigurations(brands, defaultBrand);
        defaultBrand.save(defaultBrandElement);
        brandRegistryElement.appendChild(defaultBrandElement);
        Element dataTypeRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.common.services.data-type-registry");
        IResource[] dataTypeFiles = project.getFolder("Business Objects").members();
        int i = 0;
        while (i < dataTypeFiles.length) {
            Document dataTypeDoc = this.builder.parse(dataTypeFiles[i].getLocation().toFile());
            Element dataTypeElement = this.definition.createElementNS(NAMESPACE_URI_COMMON, "common:data-type");
            DataTypeConfiguration dataType = new DataTypeConfiguration();
            dataType.setName(dataTypeDoc.getDocumentElement().getAttribute("name"));
            if (dataTypeDoc.getDocumentElement().hasAttribute("primary")) {
                dataType.setPrimaryField(dataTypeDoc.getDocumentElement().getAttribute("primary"));
            }
            NodeList list = ((Element)dataTypeDoc.getDocumentElement().getElementsByTagName("fields").item(0)).getElementsByTagName("field");
            int j = 0;
            while (j < list.getLength()) {
                FieldConfiguration field = new FieldConfiguration();
                Element fieldElement = (Element)list.item(j);
                field.setName(fieldElement.getAttribute("name"));
                Element fieldTypeElement = (Element)fieldElement.getElementsByTagName("data-type").item(0);
                String style = ((Element)fieldTypeElement.getElementsByTagName("style").item(0)).getAttribute("value");
                if ("1".equals(style)) {
                    field.setType("Array");
                } else {
                    String typeStr = XMLUtilities.getElementTextData((Element)((Element)fieldTypeElement.getElementsByTagName("type").item(0)), (boolean)true);
                    if ("DateTime".equals(typeStr)) {
                        typeStr = "Date";
                    }
                    field.setType(typeStr);
                    if (fieldElement.getAttribute("initialValue").length() > 0) {
                        field.setInitialValue(fieldElement.getAttribute("initialValue"));
                    }
                }
                dataType.addField(field);
                ++j;
            }
            dataType.save(dataTypeElement);
            dataTypeRegistryElement.appendChild(dataTypeElement);
            ++i;
        }
        Element languageRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.interactions.core.services.language-registry");
        Element mediaProviderRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.interactions.core.services.media-provider-registry");
        for (Map.Entry entry : formatterIDsByLanguage.entrySet()) {
            String languageID = (String)entry.getKey();
            String formatterID = (String)entry.getValue();
            String resourceManagerID = (String)resourceManagerIDsByLanguage.get(languageID);
            String interactionTypeID = null;
            IFormatter formatter = null;
            FormatterRegistration reg = FormatterRegistrationManager.getInstance().getFormatter(formatterID);
            if (reg != null) {
                interactionTypeID = reg.getInteractionType();
                formatter = reg.getFormatter();
            }
            Element languageElement = this.definition.createElementNS(NAMESPACE_URI_INTERACTIONS_CORE, "interactions:language");
            LanguageConfiguration language = new LanguageConfiguration();
            language.setID(languageID);
            if (formatter != null) {
                String code = formatter.getLanguageCode();
                language.setLocale(code == null ? null : code.replace('_', '-'));
            }
            language.save(languageElement);
            languageRegistryElement.appendChild(languageElement);
            Element mediaProviderElement = this.definition.createElementNS(NAMESPACE_URI_INTERACTIONS_CORE, "interactions:media-provider");
            MediaProviderConfiguration mediaProvider = new MediaProviderConfiguration((IContentFactory)ContentLoadingManager.getInstance());
            mediaProvider.setID(resourceManagerID);
            mediaProvider.setFormatterID(formatterID);
            mediaProvider.setResourceManagerID(resourceManagerID);
            this.loadSharedContent(project, mediaProvider);
            mediaProvider.save(mediaProviderElement);
            mediaProviderRegistryElement.appendChild(mediaProviderElement);
            Element mediaProviderBindingElement = this.definition.createElementNS(NAMESPACE_URI_INTERACTIONS_CORE, "interactions:media-provider-binding");
            MediaProviderBindingConfiguration mediaProviderBinding = new MediaProviderBindingConfiguration();
            mediaProviderBinding.setKey(String.valueOf(defaultBrand.getName()) + interactionTypeID + languageID.substring(languageID.lastIndexOf(58) + 1));
            mediaProviderBinding.setMediaProviderID(mediaProvider.getID());
            mediaProviderBinding.save(mediaProviderBindingElement);
            mediaProviderRegistryElement.appendChild(mediaProviderBindingElement);
        }
    }

    private void loadSharedContent(IProject processProject, MediaProviderConfiguration mediaProvider) throws Exception {
        IProject voiceProject = processProject.getWorkspace().getRoot().getProject(mediaProvider.getResourceManagerID());
        IFile xmlFile = voiceProject.getFile("Voice.xml");
        String uri = "http://eclipse.org/vtp/xml/media/voice#1.0";
        if (!xmlFile.exists()) {
            xmlFile = voiceProject.getFile("Author.xml");
            uri = "http://eclipse.org/vtp/xml/media/author#1.0";
        }
        Document voiceDocument = this.builder.parse(xmlFile.getLocation().toFile());
        NodeList list = ((Element)voiceDocument.getDocumentElement().getElementsByTagNameNS(uri, "shared-content").item(0)).getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Element element = (Element)list.item(i);
                ContentLoadingManager contentFactory = ContentLoadingManager.getInstance();
                SharedContentConfiguration sharedContent = new SharedContentConfiguration((IContentFactory)contentFactory);
                sharedContent.setName(element.getAttributeNS(uri, "item-name"));
                sharedContent.setContent(contentFactory.loadContent(element));
                mediaProvider.addSharedContent(sharedContent);
            }
            ++i;
        }
    }

    private void buildBrandConfigurations(Map brands, BrandConfiguration config) {
        for (Map.Entry entry : brands.entrySet()) {
            BrandConfiguration childConfig = new BrandConfiguration();
            childConfig.setName((String)entry.getKey());
            config.addChild(childConfig);
            this.buildBrandConfigurations((Map)entry.getValue(), childConfig);
        }
    }

    private void buildFlow() throws Exception {
        FlowElement start = null;
        if ("fragment-definition".equals(this.callDesign.getDocumentElement().getTagName())) {
            start = this.buildFlowModel((Element)((Element)this.callDesign.getDocumentElement().getElementsByTagName("fragment").item(0)).getElementsByTagName("model").item(0), 2, null);
        } else if ("application-definition".equals(this.callDesign.getDocumentElement().getTagName())) {
            start = this.buildFlowModel((Element)((Element)this.callDesign.getDocumentElement().getElementsByTagName("application").item(0)).getElementsByTagName("model").item(0), 1, null);
        }
        if (start == null) {
            return;
        }
        this.definition.getDocumentElement().setAttribute("start", start.id);
        NodeList dialogs = ((Element)this.callDesign.getDocumentElement().getElementsByTagName("dialogs").item(0)).getElementsByTagName("dialog");
        int i = 0;
        while (i < dialogs.getLength()) {
            Element dialog = (Element)dialogs.item(i);
            this.buildFlowModel((Element)dialog.getElementsByTagName("model").item(0), 3, dialog.getAttribute("id"));
            ++i;
        }
        Iterator i2 = this.flowElementsByID.values().iterator();
        while (i2.hasNext()) {
            ((FlowElement)i2.next()).link();
        }
        LinkedList<FlowElement> toProcess = new LinkedList<FlowElement>();
        toProcess.addLast(start);
        while (!toProcess.isEmpty()) {
            Iterator i3 = ((FlowElement)toProcess.removeFirst()).process().iterator();
            while (i3.hasNext()) {
                toProcess.addLast((FlowElement)i3.next());
            }
        }
    }

    private FlowElement buildFlowModel(Element modelElement, int context, String dialogID) throws Exception {
        FlowElement start = null;
        NodeList elements = ((Element)modelElement.getElementsByTagName("elements").item(0)).getChildNodes();
        int i = 0;
        while (i < elements.getLength()) {
            block52: {
                FlowElement flowElement;
                block55: {
                    String id;
                    Element element;
                    block59: {
                        block58: {
                            block53: {
                                String type;
                                block57: {
                                    block56: {
                                        block54: {
                                            if (!(elements.item(i) instanceof Element)) break block52;
                                            element = (Element)elements.item(i);
                                            id = element.getAttribute("id");
                                            if (context == 3) {
                                                id = String.valueOf(dialogID) + ":" + id;
                                            }
                                            flowElement = null;
                                            System.out.println("Adding flow element: " + element.getTagName() + ":" + element.getAttribute("type"));
                                            if (!"primitive-element".equals(element.getTagName())) break block53;
                                            type = element.getAttribute("type");
                                            if (!"org.eclipse.vtp.desktop.editors.core.appbegin".equals(type)) break block54;
                                            if (start != null || context != 1) break block52;
                                            flowElement = new ApplicationEntryElement(id, element);
                                            start = flowElement;
                                            break block55;
                                        }
                                        if (!"org.eclipse.vtp.desktop.editors.core.beginFragment".equals(type)) break block56;
                                        if (start != null || context != 2) break block52;
                                        flowElement = new FragmentEntryElement(id, element);
                                        start = flowElement;
                                        break block55;
                                    }
                                    if (!"org.eclipse.vtp.desktop.editors.core.modelEntry".equals(type)) break block57;
                                    if (start != null || context != 3) break block52;
                                    flowElement = new DialogEntryElement(id, element, dialogID);
                                    start = flowElement;
                                    break block55;
                                }
                                if ("org.eclipse.vtp.desktop.editors.core.assignment".equals(type)) {
                                    flowElement = new AssignmentElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.adrequest".equals(type)) {
                                    flowElement = new AttachedDataRequestElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.databaseQuery".equals(type)) {
                                    flowElement = new DatabaseQueryElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.decision".equals(type)) {
                                    flowElement = new DecisionElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.endCall".equals(type)) {
                                    flowElement = new EndCallElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.exit".equals(type)) {
                                    if (context == 1) {
                                        flowElement = new EndCallElement(id, element);
                                    } else if (context == 2) {
                                        flowElement = new FragmentExitElement(id, element);
                                    } else if (context == 3) {
                                        flowElement = new DialogExitElement(id, element, dialogID);
                                    }
                                } else if ("org.eclipse.vtp.desktop.editors.core.return".equals(type)) {
                                    flowElement = new FragmentExitElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.optionSet".equals(type)) {
                                    flowElement = new OptionSetElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.playPrompt".equals(type)) {
                                    flowElement = new PlayPromptElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.portalEntry".equals(type)) {
                                    flowElement = new PortalEntryElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.portalExit".equals(type)) {
                                    flowElement = new PortalExitElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.question".equals(type)) {
                                    flowElement = new QuestionElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.record".equals(type)) {
                                    flowElement = new RecordElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.script".equals(type)) {
                                    flowElement = new ScriptElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.subdialog".equals(type)) {
                                    flowElement = new SubdialogElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.transfer".equals(type)) {
                                    flowElement = new TransferElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.advancedtransfer".equals(type)) {
                                    flowElement = new BridgeElement(id, element);
                                } else if ("org.eclipse.vtp.desktop.editors.core.webserviceCall".equals(type)) {
                                    flowElement = new WebServiceCallElement(id, element);
                                }
                                break block55;
                            }
                            if (!"custom-integration-element".equals(element.getTagName())) break block58;
                            flowElement = new CustomElement(id, element);
                            break block55;
                        }
                        if (!"dialog-element".equals(element.getTagName())) break block59;
                        flowElement = new DialogElement(id, element);
                        break block55;
                    }
                    if (!"fragment-element".equals(element.getTagName())) break block52;
                    flowElement = new FragmentElement(id, element);
                }
                this.flowElementsByID.put(flowElement.id, flowElement);
            }
            ++i;
        }
        NodeList connectors = ((Element)modelElement.getElementsByTagName("connectors").item(0)).getElementsByTagName("connector");
        int i2 = 0;
        while (i2 < connectors.getLength()) {
            FlowElement origin;
            Element connector = (Element)connectors.item(i2);
            String originID = connector.getAttribute("origin");
            if (context == 3) {
                originID = String.valueOf(dialogID) + ":" + originID;
            }
            if ((origin = (FlowElement)this.flowElementsByID.get(originID)) != null) {
                FlowElement destination;
                String destinationID = connector.getAttribute("destination");
                if (context == 3) {
                    destinationID = String.valueOf(dialogID) + ":" + destinationID;
                }
                if ((destination = (FlowElement)this.flowElementsByID.get(destinationID)) != null) {
                    NodeList records = connector.getElementsByTagName("record");
                    int j = 0;
                    while (j < records.getLength()) {
                        origin.addResultPath(((Element)records.item(j)).getAttribute("sourcename"), destination);
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return start;
    }

    private Element newServiceElement(String serviceID) {
        Element element = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:service");
        element.setAttribute("id", serviceID);
        this.servicesElement.appendChild(element);
        return element;
    }

    private Element newActionElement(String actionID, String actionName, String actionDescriptorID) {
        Element element = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:action");
        element.setAttribute("id", actionID);
        element.setAttribute("name", actionName);
        element.setAttribute("descriptor-id", actionDescriptorID);
        this.actionsElement.appendChild(element);
        return element;
    }

    private Element newObserverElement(String observerID, String observerDescriptorID) {
        Element element = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:observer");
        element.setAttribute("id", observerID);
        element.setAttribute("descriptor-id", observerDescriptorID);
        this.observersElement.appendChild(element);
        return element;
    }

    private Element newAfterTransitionElement(String actionID, String path) {
        Element element = this.definition.createElementNS(NAMESPACE_URI_PROCESS_DEFINITION, "process:after");
        element.setAttribute("action", actionID);
        element.setAttribute("path", path);
        this.transitionsElement.appendChild(element);
        return element;
    }

    private void buildAssignmentAction(String actionId, String actionName, Element configuration) {
        Element actionElement = this.newActionElement(actionId, actionName, "org.eclipse.vtp.framework.common.actions.assignment");
        this.configureAssignmentAction(configuration, actionElement);
    }

    private void configureAssignmentAction(Element configuration, Element actionElement) {
        String uri = "http://www.eclipse.org/vtp/namespaces/config";
        NodeList variableList = ((Element)((Element)configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "declarations").item(0)).getElementsByTagNameNS(uri, "variable");
        int i = 0;
        while (i < variableList.getLength()) {
            Element variable = (Element)variableList.item(i);
            AssignmentConfiguration config = new AssignmentConfiguration();
            config.setName(variable.getAttribute("name"));
            if ("1".equals(variable.getAttribute("multiplicity")) || "array".equalsIgnoreCase(variable.getAttribute("multiplicity"))) {
                config.setType("Array");
            } else if ("DateTime".equals(variable.getAttribute("type"))) {
                config.setType("Date");
            } else {
                config.setType(variable.getAttribute("type"));
            }
            String value = variable.getAttribute("value");
            if (value != null && value.length() > 0) {
                config.setValue(value);
            }
            Element configElement = this.definition.createElementNS(NAMESPACE_URI_COMMON, "common:assignment");
            config.save(configElement);
            actionElement.appendChild(configElement);
            ++i;
        }
    }

    private class ApplicationEntryElement
    extends FlowElement {
        ApplicationEntryElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.initial");
            DefinitionBuilder.this.configureAssignmentAction(this.configuration, actionElement);
        }
    }

    private class AssignmentElement
    extends FlowElement {
        AssignmentElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            DefinitionBuilder.this.buildAssignmentAction(this.id, null, this.configuration);
        }
    }

    private class AttachedDataRequestElement
    extends FlowElement {
        AttachedDataRequestElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element item;
            String uri = "http://eclipse.org/vtp/xml/configuration/attacheddata/request";
            NodeList bindingsList = this.configuration.getElementsByTagNameNS(uri, "bindings");
            Element attachedData = null;
            int i = 0;
            while (attachedData == null && i < bindingsList.getLength()) {
                Element bindings = (Element)bindingsList.item(i);
                NodeList itemList = bindings.getElementsByTagNameNS(uri, "attached-data-binding");
                int j = 0;
                while (attachedData == null && j < itemList.getLength()) {
                    item = (Element)itemList.item(j);
                    if ("default".equals(item.getAttribute("name"))) {
                        attachedData = item;
                    }
                    ++j;
                }
                ++i;
            }
            if (attachedData == null) {
                return;
            }
            MetaDataConfiguration config = new MetaDataConfiguration();
            NodeList itemList = attachedData.getElementsByTagNameNS(uri, "item");
            int count = 0;
            int i2 = 0;
            while (i2 < itemList.getLength()) {
                item = (Element)itemList.item(i2);
                NodeList entryList = item.getElementsByTagNameNS(uri, "entry");
                if (entryList.getLength() > 0) {
                    MetaDataItemConfiguration[] metaDataItems = new MetaDataItemConfiguration[entryList.getLength()];
                    int j = 0;
                    while (j < entryList.getLength()) {
                        Element entry = (Element)entryList.item(j);
                        MetaDataItemConfiguration metaDataItem = new MetaDataItemConfiguration();
                        metaDataItem.setName(entry.getAttribute("name"));
                        if ("variable".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setVariableValue(entry.getAttribute("value"));
                        } else if ("expression".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setExpressionValue(entry.getAttribute("value"), "JavaScript");
                        } else {
                            metaDataItem.setStaticValue(entry.getAttribute("value"));
                        }
                        metaDataItems[j] = metaDataItem;
                        ++j;
                    }
                    config.setItem(item.getAttribute("key"), metaDataItems);
                    ++count;
                }
                ++i2;
            }
            if (count == 0) {
                return;
            }
            Element dataElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.meta-data-request");
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:meta-data");
            config.save(configElement);
            dataElement.appendChild(configElement);
        }
    }

    private class BridgeElement
    extends FlowElement {
        BridgeElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.bridge-message");
            MediaConfiguration mediaBindings = this.loadMediaBindings();
            BridgeMessageConfiguration config = new BridgeMessageConfiguration();
            config.setType(mediaBindings.getPropertyConfiguration("type"));
            config.setOutputDestination(mediaBindings.getPropertyConfiguration("destination"));
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:bridge-message");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class CustomElement
    extends FlowElement {
        CustomElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            DefinitionBuilder.this.newActionElement(this.id, this.name, this.type);
        }

        String mapResultPath(String input) {
            return input;
        }
    }

    private class DatabaseQueryElement
    extends FlowElement {
        DatabaseQueryElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.databases.actions.database-query");
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            DatabaseQueryConfiguration query = new DatabaseQueryConfiguration();
            Element settings = (Element)((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "settings").item(0);
            query.setDatabase(settings.getAttribute("db-name"));
            query.setTable(settings.getAttribute("db-table"));
            query.setResultName(settings.getAttribute("var-name"));
            query.setResultType(settings.getAttribute("var-type"));
            query.setResultArray("1".equals(settings.getAttribute("var-multi")));
            if (query.isResultArray()) {
                query.setResultLimit(Integer.parseInt(settings.getAttribute("db-result-limit")));
            }
            NodeList list = ((Element)settings.getElementsByTagNameNS(uri, "mappings").item(0)).getElementsByTagNameNS(uri, "mapping");
            int i = 0;
            while (i < list.getLength()) {
                Element mappingElement = (Element)list.item(i);
                DatabaseMappingConfiguration mapping = new DatabaseMappingConfiguration();
                mapping.setName(mappingElement.getAttribute("name"));
                if ("0".equals(mappingElement.getAttribute("type"))) {
                    mapping.setType(2);
                } else if ("1".equals(mappingElement.getAttribute("type"))) {
                    mapping.setType(1);
                } else {
                    mapping.setType(0);
                }
                if (mapping.getType() != 0) {
                    mapping.setValue(mappingElement.getAttribute("value"));
                }
                query.addMapping(mapping);
                ++i;
            }
            list = ((Element)settings.getElementsByTagNameNS(uri, "criteria").item(0)).getElementsByTagNameNS(uri, "criterium");
            i = 0;
            while (i < list.getLength()) {
                Element criteriumElement = (Element)list.item(i);
                DatabaseCriteriaConfiguration criteria = new DatabaseCriteriaConfiguration();
                criteria.setName(criteriumElement.getAttribute("name"));
                if ("0".equals(criteriumElement.getAttribute("type"))) {
                    criteria.setType(2);
                } else if ("1".equals(criteriumElement.getAttribute("type"))) {
                    criteria.setType(1);
                } else {
                    criteria.setType(0);
                }
                if (criteria.getType() != 0) {
                    if ("1".equals(criteriumElement.getAttribute("comp"))) {
                        criteria.setComparison(1);
                    } else if ("2".equals(criteriumElement.getAttribute("comp"))) {
                        criteria.setComparison(2);
                    } else if ("3".equals(criteriumElement.getAttribute("comp"))) {
                        criteria.setComparison(3);
                    } else if ("4".equals(criteriumElement.getAttribute("comp"))) {
                        criteria.setComparison(4);
                    } else if ("5".equals(criteriumElement.getAttribute("comp"))) {
                        criteria.setComparison(5);
                    } else {
                        criteria.setComparison(0);
                    }
                    criteria.setValue(criteriumElement.getAttribute("value"));
                }
                query.addCriteria(criteria);
                ++i;
            }
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_DATABASES, "database:query");
            query.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class DecisionElement
    extends FlowElement {
        DecisionElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.branch");
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            NodeList comparisonList = ((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "comparison");
            if (comparisonList.getLength() > 0) {
                Element comparison = (Element)comparisonList.item(0);
                BranchConfiguration config = new BranchConfiguration();
                String typeStr = comparison.getAttribute("type");
                if ("equal".equals(typeStr)) {
                    config.setType(0);
                } else if ("less-than".equals(typeStr)) {
                    config.setType(1);
                } else if ("less-than-or-equal".equals(typeStr)) {
                    config.setType(2);
                } else if ("greater-than".equals(typeStr)) {
                    config.setType(3);
                } else if ("greater-than-or-equal".equals(typeStr)) {
                    config.setType(4);
                } else if ("not-equal".equals(typeStr)) {
                    config.setType(5);
                }
                config.setPath("True");
                if ("expression".equalsIgnoreCase(comparison.getAttribute("left-type"))) {
                    config.setLeftExpressionValue(comparison.getAttribute("left-value"), "JavaScript");
                } else {
                    config.setLeftVariableValue(comparison.getAttribute("left-value"));
                }
                if ("expression".equalsIgnoreCase(comparison.getAttribute("right-type"))) {
                    config.setRightExpressionValue(comparison.getAttribute("right-value"), "JavaScript");
                } else {
                    config.setRightVariableValue(comparison.getAttribute("right-value"));
                }
                Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_COMMON, "common:branch");
                config.save(configElement);
                actionElement.appendChild(configElement);
            }
        }

        String mapResultPath(String input) {
            return "False".equals(input) ? "default" : input;
        }
    }

    private class DialogElement
    extends FlowElement {
        DialogEntryElement entry;

        DialogElement(String id, Element configuration) {
            super(id, configuration);
            this.entry = null;
        }

        String getTargetID(Element afterTransitionElement) {
            return this.entry == null ? null : this.entry.getTargetID(afterTransitionElement);
        }
    }

    private class DialogEntryElement
    extends FlowElement {
        final String dialogID;

        DialogEntryElement(String id, Element configuration, String dialogID) {
            super(id, configuration);
            this.dialogID = dialogID;
        }

        void link() {
            DialogElement dialog = (DialogElement)DefinitionBuilder.this.flowElementsByID.get(this.dialogID);
            if (dialog != null) {
                dialog.entry = this;
            }
        }

        String getTargetID(Element afterTransitionElement) {
            this.buildObservers("Continue", afterTransitionElement);
            FlowElement next = (FlowElement)this.resultPaths.get("Continue");
            return next == null ? null : next.getTargetID(afterTransitionElement);
        }
    }

    private class DialogExitElement
    extends FlowElement {
        final String dialogID;

        DialogExitElement(String id, Element configuration, String dialogID) {
            super(id, configuration);
            this.dialogID = dialogID;
        }

        String getTargetID(Element afterTransitionElement) {
            DialogElement dialog = (DialogElement)DefinitionBuilder.this.flowElementsByID.get(this.dialogID);
            if (dialog == null) {
                return null;
            }
            String path = this.configuration.getAttribute("name");
            FlowElement next = (FlowElement)dialog.resultPaths.get(path);
            if (next == null) {
                return null;
            }
            dialog.buildObservers(path, afterTransitionElement);
            return next.getTargetID(afterTransitionElement);
        }
    }

    private class EndCallElement
    extends FlowElement {
        EndCallElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.end");
        }
    }

    private abstract class FlowElement {
        final String id;
        final String name;
        final String type;
        final Element configuration;
        final Map resultPaths = new HashMap();
        boolean processed = false;

        FlowElement(String id, Element configuration) {
            this.id = id;
            this.name = configuration.getAttribute("name");
            this.type = configuration.getAttribute("type");
            this.configuration = configuration;
        }

        void addResultPath(String path, FlowElement next) {
            this.resultPaths.put(path, next);
        }

        void link() {
        }

        String getTargetID(Element afterTransitionElement) {
            return this.id;
        }

        final List process() {
            if (this.processed) {
                return Collections.EMPTY_LIST;
            }
            this.processed = true;
            this.buildAction();
            ArrayList nextElements = new ArrayList(this.resultPaths.size());
            for (Map.Entry entry : this.resultPaths.entrySet()) {
                String designPath = (String)entry.getKey();
                String processPath = this.mapResultPath(designPath);
                Element afterTrasition = DefinitionBuilder.this.newAfterTransitionElement(this.id, processPath);
                this.buildObservers(designPath, afterTrasition);
                String target = ((FlowElement)entry.getValue()).getTargetID(afterTrasition);
                if (target == null) {
                    DefinitionBuilder.this.transitionsElement.removeChild(afterTrasition);
                    continue;
                }
                afterTrasition.setAttribute("target", target);
                nextElements.add(DefinitionBuilder.this.flowElementsByID.get(target));
            }
            return nextElements;
        }

        void buildAction() {
        }

        void buildObservers(String designPath, Element afterTrasition) {
            NodeList itemList;
            String uri = "http://eclipse.org/vtp/xml/configuration/attacheddata";
            NodeList bindingsList = this.configuration.getElementsByTagNameNS(uri, "bindings");
            Element attachedData = null;
            int i = 0;
            while (attachedData == null && i < bindingsList.getLength()) {
                Element bindings = (Element)bindingsList.item(i);
                itemList = bindings.getElementsByTagNameNS(uri, "attached-data-binding");
                int j = 0;
                while (attachedData == null && j < itemList.getLength()) {
                    Element item = (Element)itemList.item(j);
                    if (designPath.equals(item.getAttribute("name"))) {
                        attachedData = item;
                    }
                    ++j;
                }
                ++i;
            }
            if (attachedData == null) {
                return;
            }
            String observerID = Guid.createGUID();
            MetaDataConfiguration config = new MetaDataConfiguration();
            itemList = attachedData.getElementsByTagNameNS(uri, "item");
            int count = 0;
            int i2 = 0;
            while (i2 < itemList.getLength()) {
                Element item = (Element)itemList.item(i2);
                NodeList entryList = item.getElementsByTagNameNS(uri, "entry");
                if (entryList.getLength() > 0) {
                    MetaDataItemConfiguration[] metaDataItems = new MetaDataItemConfiguration[entryList.getLength()];
                    int j = 0;
                    while (j < entryList.getLength()) {
                        Element entry = (Element)entryList.item(j);
                        MetaDataItemConfiguration metaDataItem = new MetaDataItemConfiguration();
                        metaDataItem.setName(entry.getAttribute("name"));
                        if ("variable".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setVariableValue(entry.getAttribute("value"));
                        } else if ("expression".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setExpressionValue(entry.getAttribute("value"), "JavaScript");
                        } else {
                            metaDataItem.setStaticValue(entry.getAttribute("value"));
                        }
                        metaDataItems[j] = metaDataItem;
                        ++j;
                    }
                    config.setItem(item.getAttribute("key"), metaDataItems);
                    ++count;
                }
                ++i2;
            }
            if (count == 0) {
                return;
            }
            Element observerElement = DefinitionBuilder.this.newObserverElement(observerID, "org.eclipse.vtp.framework.interactions.core.observers.meta-data-message");
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:meta-data");
            config.save(configElement);
            observerElement.appendChild(configElement);
            Element notify = afterTrasition.getOwnerDocument().createElementNS(DefinitionBuilder.NAMESPACE_URI_PROCESS_DEFINITION, "process:notify");
            notify.setAttribute("observer", observerID);
            afterTrasition.appendChild(notify);
        }

        String mapResultPath(String input) {
            return "Continue".equals(input) ? "default" : input;
        }

        MediaConfiguration loadMediaBindings() {
            int k;
            Element itemElement;
            int j;
            NodeList items;
            MediaConfiguration result = new MediaConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
            String uri = "http://eclipse.org/vtp/xml/configuration/media";
            Element bindingsElement = (Element)this.configuration.getElementsByTagNameNS(uri, "bindings").item(0);
            if (bindingsElement == null) {
                return null;
            }
            NodeList list = bindingsElement.getElementsByTagNameNS(uri, "prompt-binding");
            int i = 0;
            while (i < list.getLength()) {
                Element promptElement = (Element)list.item(i);
                OutputConfiguration outputConfig = new OutputConfiguration((IContentFactory)ContentLoadingManager.getInstance());
                items = promptElement.getElementsByTagNameNS(uri, "item");
                j = 0;
                while (j < items.getLength()) {
                    itemElement = (Element)items.item(j);
                    NodeList contents = itemElement.getChildNodes();
                    ArrayList<Content> contentList = new ArrayList<Content>(contents.getLength());
                    k = 0;
                    while (k < contents.getLength()) {
                        if (contents.item(k) instanceof Element) {
                            contentList.add(ContentLoadingManager.getInstance().loadContent((Element)contents.item(k)));
                        }
                        ++k;
                    }
                    outputConfig.setItem(itemElement.getAttribute("key"), contentList.toArray(new Content[contentList.size()]));
                    ++j;
                }
                result.setOutputConfiguration(promptElement.getAttribute("name"), outputConfig);
                ++i;
            }
            list = bindingsElement.getElementsByTagNameNS(uri, "grammar-binding");
            i = 0;
            while (i < list.getLength()) {
                Element grammarElement = (Element)list.item(i);
                InputConfiguration inputConfig = new InputConfiguration((IInputGrammarFactory)InputLoadingManager.getInstance());
                items = grammarElement.getElementsByTagNameNS(uri, "item");
                j = 0;
                while (j < items.getLength()) {
                    itemElement = (Element)items.item(j);
                    try {
                        InputGrammar grammar = null;
                        NodeList contents = itemElement.getChildNodes();
                        k = 0;
                        while (grammar == null && k < contents.getLength()) {
                            if (contents.item(k) instanceof Element) {
                                grammar = InputLoadingManager.getInstance().loadInput((Element)contents.item(k));
                            }
                            ++k;
                        }
                        if (grammar != null) {
                            inputConfig.setItem(itemElement.getAttribute("key"), grammar);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                result.setInputConfiguration(grammarElement.getAttribute("name"), inputConfig);
                ++i;
            }
            list = bindingsElement.getElementsByTagNameNS(uri, "property-binding");
            i = 0;
            while (i < list.getLength()) {
                Element propertyElement = (Element)list.item(i);
                PropertyConfiguration propertyConfig = new PropertyConfiguration();
                items = propertyElement.getElementsByTagNameNS(uri, "item");
                j = 0;
                while (j < items.getLength()) {
                    itemElement = (Element)items.item(j);
                    try {
                        propertyConfig.setItem(itemElement.getAttribute("key"), XMLUtilities.getElementTextData((Element)itemElement, (boolean)true));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                result.setPropertyConfiguration(propertyElement.getAttribute("name"), propertyConfig);
                ++i;
            }
            return result;
        }
    }

    private class FragmentElement
    extends FlowElement {
        FragmentElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.include");
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            DispatchConfiguration config = new DispatchConfiguration();
            config.setTargetProcessURI(this.configuration.getAttribute("name"));
            NodeList mapplingList = ((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "mapping");
            int i = 0;
            while (i < mapplingList.getLength()) {
                Element mapping = (Element)mapplingList.item(i);
                VariableMappingConfiguration vmc = new VariableMappingConfiguration();
                String type = mapping.getAttribute("mapping-type");
                String value = mapping.getAttribute("mapping-value");
                if ("variable".equalsIgnoreCase(type)) {
                    vmc.setVariableValue(value);
                } else if ("expression".equalsIgnoreCase(type)) {
                    vmc.setExpressionValue(value, "JavaScript");
                } else if ("static".equalsIgnoreCase(type)) {
                    vmc.setStaticValue(value);
                } else {
                    vmc.setNoValue();
                }
                config.setVariableMapping(mapping.getAttribute("fragment-variable-name"), vmc);
                ++i;
            }
            NodeList outgoingList = ((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "outgoing-data");
            int i2 = 0;
            while (i2 < outgoingList.getLength()) {
                Element outgoingData = (Element)outgoingList.item(i2);
                String path = outgoingData.getAttribute("exit-path");
                NodeList entryList = outgoingData.getElementsByTagNameNS(uri, "data-mapping");
                int j = 0;
                while (j < entryList.getLength()) {
                    Element dataElement = (Element)entryList.item(j);
                    String name = dataElement.getAttribute("output");
                    String value = dataElement.getAttribute("target");
                    if (!"Not Used".equals(value)) {
                        config.setOutgoingDataValue(path, name, value);
                    }
                    ++j;
                }
                ++i2;
            }
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_COMMON, "common:dispatch");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class FragmentEntryElement
    extends FlowElement {
        FragmentEntryElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.initial");
            DefinitionBuilder.this.configureAssignmentAction(this.configuration, actionElement);
        }
    }

    private class FragmentExitElement
    extends FlowElement {
        FragmentExitElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.final");
            ExitConfiguration config = new ExitConfiguration();
            config.setValue(this.configuration.getAttribute("name"));
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_COMMON, "common:exit");
            config.save(configElement);
            actionElement.appendChild(configElement);
            NodeList list = this.configuration.getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config");
            if (list.getLength() > 0) {
                Element custom = (Element)list.item(0);
                list = custom.getElementsByTagName("export");
                int i = 0;
                while (i < list.getLength()) {
                    String name = ((Element)list.item(i)).getAttribute("name");
                    if (name != null && name.length() > 0) {
                        AssignmentConfiguration assign = new AssignmentConfiguration();
                        assign.setName(name);
                        configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_COMMON, "common:assignment");
                        assign.save(configElement);
                        actionElement.appendChild(configElement);
                    }
                    ++i;
                }
            }
        }
    }

    private class OptionSetElement
    extends FlowElement {
        OptionSetElement(String id, Element configuration) {
            super(id, configuration);
        }

        String mapResultPath(String input) {
            return input;
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.selection-request");
            SelectionRequestConfiguration config = new SelectionRequestConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
            config.setOutputName("Prompt");
            config.setDataName("selection");
            MediaConfiguration media = this.loadMediaBindings();
            Element customConfig = (Element)this.configuration.getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config").item(0);
            NodeList choiceElements = ((Element)customConfig.getElementsByTagNameNS(customConfig.getNamespaceURI(), "choices").item(0)).getElementsByTagNameNS(customConfig.getNamespaceURI(), "choice");
            int i = 0;
            while (i < choiceElements.getLength()) {
                Element choiceElement = (Element)choiceElements.item(i);
                String name = choiceElement.getAttribute("name");
                String script = null;
                if (choiceElement.hasAttribute("script")) {
                    script = choiceElement.getAttribute("script");
                }
                String prefix = String.valueOf(name) + "-";
                MediaConfiguration choiceMedia = new MediaConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                String[] propertyNames = media.getPropertyConfigurationNames();
                int j = 0;
                while (j < propertyNames.length) {
                    if (propertyNames[j].startsWith(prefix)) {
                        PropertyConfiguration property = media.getPropertyConfiguration(propertyNames[j]);
                        media.setPropertyConfiguration(propertyNames[j], null);
                        choiceMedia.setPropertyConfiguration(propertyNames[j].substring(prefix.length()), property);
                    }
                    ++j;
                }
                String[] outputNames = media.getOutputConfigurationNames();
                int j2 = 0;
                while (j2 < outputNames.length) {
                    if (outputNames[j2].startsWith(prefix)) {
                        OutputConfiguration output = media.getOutputConfiguration(outputNames[j2]);
                        media.setOutputConfiguration(outputNames[j2], null);
                        choiceMedia.setOutputConfiguration(outputNames[j2].substring(prefix.length()), output);
                    }
                    ++j2;
                }
                String[] inputNames = media.getInputConfigurationNames();
                int j3 = 0;
                while (j3 < inputNames.length) {
                    if (inputNames[j3].startsWith(prefix)) {
                        InputConfiguration input = media.getInputConfiguration(inputNames[j3]);
                        media.setInputConfiguration(inputNames[j3], null);
                        choiceMedia.setInputConfiguration(inputNames[j3].substring(prefix.length()), input);
                    }
                    ++j3;
                }
                SelectionChoiceConfiguration choice = new SelectionChoiceConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                choice.setName(name);
                choice.setOutputName("prompt");
                choice.setInputName("grammar");
                if (script != null) {
                    choice.setScriptingLanguage("JavaScript");
                    choice.setScript(script);
                }
                choice.setMediaConfiguration(choiceMedia);
                config.addChoice(choice);
                ++i;
            }
            config.setMediaConfiguration(media);
            NodeList brandOrderElements = customConfig.getElementsByTagNameNS(customConfig.getNamespaceURI(), "brand-order");
            TreeMap<Integer, String> entries = new TreeMap<Integer, String>();
            int i2 = 0;
            while (i2 < brandOrderElements.getLength()) {
                Element brandOrder = (Element)brandOrderElements.item(i2);
                String brand = brandOrder.getAttribute("brand");
                NodeList entryElements = brandOrder.getElementsByTagNameNS(brandOrder.getNamespaceURI(), "entry");
                int j = 0;
                while (j < entryElements.getLength()) {
                    Element entryElement = (Element)entryElements.item(j);
                    entries.put(new Integer(entryElement.getAttribute("spot")), entryElement.getAttribute("name"));
                    ++j;
                }
                config.setBrandedChoices(brand, entries.values().toArray(new String[entries.size()]));
                entries.clear();
                ++i2;
            }
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:selection-request");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class PlayPromptElement
    extends FlowElement {
        PlayPromptElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.output-message");
            OutputMessageConfiguration config = new OutputMessageConfiguration((IContentFactory)ContentLoadingManager.getInstance());
            config.setOutputName("Prompt");
            config.setMediaConfiguration(this.loadMediaBindings());
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:output-message");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class PortalEntryElement
    extends FlowElement {
        PortalEntryElement(String id, Element configuration) {
            super(id, configuration);
        }

        String getTargetID(Element afterTransitionElement) {
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            FlowElement exit = (FlowElement)DefinitionBuilder.this.flowElementsByID.get(((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getAttribute("exit-id"));
            return exit == null ? null : exit.getTargetID(afterTransitionElement);
        }
    }

    private class PortalExitElement
    extends FlowElement {
        PortalExitElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.portal");
        }
    }

    private class QuestionElement
    extends FlowElement {
        QuestionElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.input-request");
            InputRequestConfiguration config = new InputRequestConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
            config.setOutputName("Prompt");
            config.setInputName("Grammar");
            config.setInputName2("Voice-Grammar");
            Element customConfig = (Element)this.configuration.getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config").item(0);
            config.setDataName(customConfig.getAttribute("variable-name"));
            config.setMediaConfiguration(this.loadMediaBindings());
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:input-request");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class RecordElement
    extends FlowElement {
        RecordElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.data-request");
            DataRequestConfiguration config = new DataRequestConfiguration((IContentFactory)ContentLoadingManager.getInstance());
            config.setOutputName("Prompt");
            Element customConfig = (Element)this.configuration.getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config").item(0);
            config.setDataName(customConfig.getAttribute("var-name"));
            config.setMediaConfiguration(this.loadMediaBindings());
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:data-request");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class ScriptElement
    extends FlowElement {
        ScriptElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.scripted");
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            ScriptConfiguration config = new ScriptConfiguration();
            config.setScriptingLanguage("JavaScript");
            try {
                config.setScript(XMLUtilities.getElementTextData((Element)((Element)((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "script").item(0)), (boolean)true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_COMMON, "common:script");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class SubdialogElement
    extends FlowElement {
        SubdialogElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.common.actions.no-op");
        }
    }

    private class TransferElement
    extends FlowElement {
        TransferElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.interactions.core.actions.transfer-message");
            MediaConfiguration mediaBindings = this.loadMediaBindings();
            TransferMessageConfiguration config = new TransferMessageConfiguration();
            config.setType(mediaBindings.getPropertyConfiguration("type"));
            config.setDestination(mediaBindings.getPropertyConfiguration("destination"));
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_INTERACTIONS_CORE, "interactions:transfer-message");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    private class WebServiceCallElement
    extends FlowElement {
        WebServiceCallElement(String id, Element configuration) {
            super(id, configuration);
        }

        void buildAction() {
            Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, "org.eclipse.vtp.framework.webservices.actions.webservice-call");
            String uri = "http://www.eclipse.org/vtp/namespaces/config";
            WebServiceCallConfiguration call = new WebServiceCallConfiguration();
            Element settings = (Element)((Element)this.configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "settings").item(0);
            call.setLocator(settings.getAttribute("ws-locator"));
            call.setWebService(settings.getAttribute("ws-name"));
            call.setPort(settings.getAttribute("ws-port"));
            call.setOperation(settings.getAttribute("ws-operation"));
            call.setResultName(settings.getAttribute("var-name"));
            call.setResultType(settings.getAttribute("var-type"));
            call.setResultArray("1".equals(settings.getAttribute("var-multi")));
            NodeList list = ((Element)settings.getElementsByTagNameNS(uri, "mappings").item(0)).getElementsByTagNameNS(uri, "mapping");
            int i = 0;
            while (i < list.getLength()) {
                Element mappingElement = (Element)list.item(i);
                WebServiceMappingConfiguration mapping = new WebServiceMappingConfiguration();
                mapping.setName(mappingElement.getAttribute("name"));
                if ("0".equals(mappingElement.getAttribute("type"))) {
                    mapping.setType(2);
                } else if ("1".equals(mappingElement.getAttribute("type"))) {
                    mapping.setType(1);
                } else {
                    mapping.setType(0);
                }
                if (mapping.getType() != 0) {
                    mapping.setValue(mappingElement.getAttribute("value"));
                }
                call.addMapping(mapping);
                ++i;
            }
            list = ((Element)settings.getElementsByTagNameNS(uri, "inputs").item(0)).getElementsByTagNameNS(uri, "input");
            i = 0;
            while (i < list.getLength()) {
                Element inputElement = (Element)list.item(i);
                WebServiceInputConfiguration input = new WebServiceInputConfiguration();
                input.setName(inputElement.getAttribute("name"));
                if ("value".equals(inputElement.getAttribute("type"))) {
                    input.setType(2);
                } else if ("variable".equals(inputElement.getAttribute("type"))) {
                    input.setType(1);
                } else {
                    input.setType(0);
                }
                if (input.getType() != 0) {
                    input.setValue(inputElement.getAttribute("value"));
                }
                call.addInput(input);
                ++i;
            }
            Element configElement = DefinitionBuilder.this.definition.createElementNS(DefinitionBuilder.NAMESPACE_URI_WEBSERVICES, "webservice:call");
            call.save(configElement);
            actionElement.appendChild(configElement);
        }
    }
}

