/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.export.ConfigureDatabasesPage;
import org.eclipse.vtp.desktop.projects.core.export.ExportWebappPage;
import org.eclipse.vtp.desktop.projects.core.export.Exporter;
import org.eclipse.vtp.desktop.projects.core.export.SelectApplicationsPage;

public class ExportWebappWizard
extends Wizard
implements IExportWizard {
    private Exporter exporter = null;
    private WizardPage firstPage = null;
    private ExportWebappPage[] subsequentPages = null;
    private final Set selectedNames = new HashSet();

    public ExportWebappWizard() {
        this.setNeedsProgressMonitor(true);
    }

    private void changeArchive(File archive) {
        this.exporter.setArchive(archive);
        Iterator i = this.selectedNames.iterator();
        while (i.hasNext()) {
            this.exporter.selectProject((String)i.next());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.exporter = new Exporter(workbench);
        this.firstPage = new FirstPage();
        this.subsequentPages = new ExportWebappPage[]{new SelectApplicationsPage(this.exporter), new ConfigureDatabasesPage(this.exporter)};
        if (selection == null) {
            return;
        }
        for (Object obj : selection) {
            if (obj instanceof IProject) {
                this.selectedNames.add(((IProject)obj).getName());
                continue;
            }
            if (!(obj instanceof IAdaptable) || !((obj = ((IAdaptable)obj).getAdapter(IProject.class)) instanceof IProject)) continue;
            this.selectedNames.add(((IProject)obj).getName());
        }
        String lastPath = Exporter.getLastArchivePath();
        this.changeArchive(lastPath == null ? null : new File(lastPath));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.firstPage);
        int i = 0;
        while (i < this.subsequentPages.length) {
            this.addPage((IWizardPage)this.subsequentPages[i]);
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        while (nextPage instanceof ExportWebappPage && !((ExportWebappPage)nextPage).needsToBeShown()) {
            nextPage = super.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previousPage = super.getPreviousPage(page);
        while (previousPage instanceof ExportWebappPage && !((ExportWebappPage)previousPage).needsToBeShown()) {
            previousPage = super.getPreviousPage(previousPage);
        }
        return previousPage;
    }

    public boolean canFinish() {
        return super.canFinish() && this.exporter != null;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWizardPage[] pages = ExportWebappWizard.this.getPages();
                        int i = 0;
                        while (i < pages.length) {
                            if (pages[i] instanceof ExportWebappPage) {
                                ((ExportWebappPage)pages[i]).savePrefrences();
                            }
                            ++i;
                        }
                        ExportWebappWizard.this.exporter.exportWebApplication(monitor, ExportWebappWizard.this.subsequentPages);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            new ErrorDialog(this.getShell(), "Error Exporting Web Application", e.getTargetException().getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getTargetException().getMessage(), e.getTargetException()), 4).open();
        }
        catch (Exception e) {
            e.printStackTrace();
            new ErrorDialog(this.getShell(), "Error Exporting Web Application", e.getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
        }
        return false;
    }

    private final class FirstPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        public FirstPage() {
            super("FirstPage", "Select an Archive File", null);
        }

        private void evaluate(String path) {
            File archive = null;
            String msg = null;
            if (path == null || path.length() == 0) {
                msg = "Select an archive file to export to.";
            } else {
                archive = new File(path);
                if (archive.isDirectory()) {
                    msg = "Select a file, not a directory.";
                } else if (!archive.getName().endsWith(".war")) {
                    msg = "Archive file name must end with \".war\".";
                }
            }
            if (msg != null) {
                archive = null;
            }
            ExportWebappWizard.this.changeArchive(archive);
            this.setErrorMessage(msg);
            this.setPageComplete(msg == null);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText("Archive file:");
            Combo combo = new Combo(composite, 4);
            combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            String lastPath = Exporter.getLastArchivePath();
            Object[] paths = Exporter.getAllArchivePaths();
            Arrays.sort(paths);
            int i = 0;
            while (i < paths.length) {
                combo.add((String)paths[i]);
                if (((String)paths[i]).equals(lastPath)) {
                    combo.select(i);
                }
                ++i;
            }
            combo.addModifyListener((ModifyListener)this);
            Button button = new Button(composite, 8);
            button.setData((Object)combo);
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            button.setText("Browse...");
            button.addSelectionListener((SelectionListener)this);
            this.setControl((Control)composite);
            combo.setFocus();
        }

        public void modifyText(ModifyEvent e) {
            this.evaluate(((Combo)e.getSource()).getText());
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            String path = new FileDialog(this.getShell()).open();
            if (path == null) {
                return;
            }
            Combo combo = (Combo)button.getData();
            combo.setText(path);
            this.evaluate(combo.getText());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

