/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.export.DefinitionBuilder;
import org.eclipse.vtp.desktop.projects.core.export.ExporterExtension;
import org.eclipse.vtp.desktop.projects.core.export.ExporterObserver;
import org.eclipse.vtp.framework.common.IEncryptionEngine;
import org.eclipse.vtp.framework.util.ConfigurationDictionary;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.StaticConfigurationAdmin;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Exporter {
    private static final Preferences PREFERENCES = DesktopCorePlugin.getDefault().getPluginPreferences();
    private static final String KEY_EXPORT = "export";
    private static final String KEY_PREFIX_EXPORT = "export.";
    private static final String[] PLUGINS = new String[]{"org.eclipse.osgi", "org.eclipse.osgi.services@1:start", "org.eclipse.equinox.common@2:start", "org.eclipse.equinox.app@2:start", "org.eclipse.equinox.preferences@start", "org.eclipse.equinox.registry@start", "org.eclipse.core.contenttype@start", "org.eclipse.core.jobs@start", "org.eclipse.core.runtime@start", "org.eclipse.core.runtime.compatibility.auth@start", "org.eclipse.update.configurator@start", "javax.activation@start", "javax.mail@start", "org.apache.xerces@start", "org.apache.xml.resolver@start", "javax.xml.soap@start", "javax.xml.rpc@start", "javax.wsdl@start", "org.apache.ant@start", "org.apache.axis@start", "org.apache.commons.discovery@start", "org.apache.commons.io@start", "org.apache.commons.fileupload@start", "org.apache.commons.logging@start", "org.apache.commons.pool@start", "org.apache.log4j@start", "org.mozilla.javascript@start", "org.eclipse.equinox.http.servlet@start", "org.eclipse.equinox.http.servletbridge@start", "org.eclipse.vtp.framework.core@start", "org.eclipse.vtp.framework.util@start", "org.eclipse.vtp.framework.spi@start", "org.eclipse.vtp.framework.engine@start"};
    private static final String[] EXTENSIONS = new String[]{"org.eclipse.vtp.framework.core.actions", "org.eclipse.vtp.framework.core.configurations", "org.eclipse.vtp.framework.core.observers", "org.eclipse.vtp.framework.core.services"};
    private static File INSTALL_AREA;
    private final List pluginNames;
    private final IEncryptionEngine encryption;
    private final DocumentBuilder documentBuilder;
    private final Transformer transformer;
    private final ConfigurationDictionary configurationDictionary = new ConfigurationDictionary("org.eclipse.vtp.framework.engine.http");
    private final Map projects;
    private final Map plugIns;
    private File archive = null;
    private String prefix = null;
    private final List observers = new ArrayList();

    static {
        File area = null;
        try {
            area = new File(new URL(System.getProperty("osgi.install.area")).getPath());
        }
        catch (MalformedURLException malformedURLException) {
            area = new File(".");
        }
        INSTALL_AREA = area;
    }

    public static String getLastArchivePath() {
        return PREFERENCES.getString(KEY_EXPORT);
    }

    public static String[] getAllArchivePaths() {
        String[] names = PREFERENCES.propertyNames();
        ArrayList<String> paths = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            if (names[i].startsWith(KEY_PREFIX_EXPORT) && names[i].length() > KEY_PREFIX_EXPORT.length() && names[i].indexOf(46, KEY_PREFIX_EXPORT.length()) < 0) {
                paths.add(PREFERENCES.getString(names[i]));
            }
            ++i;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public Exporter(IWorkbench workbench) {
        try {
            ArrayList<String> pluginNames = new ArrayList<String>(PLUGINS.length);
            int i = 0;
            while (i < PLUGINS.length) {
                pluginNames.add(PLUGINS[i]);
                ++i;
            }
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IEncryptionEngine encryption = null;
            IExtension[] services = extensionRegistry.getExtensionPoint("org.eclipse.vtp.framework.core.services").getExtensions();
            int i2 = 0;
            while (encryption == null && i2 < services.length) {
                IConfigurationElement[] elements = services[i2].getConfigurationElements();
                int j = 0;
                while (encryption == null && j < elements.length) {
                    if ("service".equals(elements[j].getName())) {
                        System.out.println("FOUND: " + elements[j].getAttribute("id"));
                        String type = elements[j].getAttribute("type");
                        IConfigurationElement[] identifiers = elements[j].getChildren("identifier");
                        int k = 0;
                        while (encryption == null && k < identifiers.length) {
                            if (IEncryptionEngine.class.getName().equals(identifiers[k].getAttribute("name"))) {
                                try {
                                    encryption = (IEncryptionEngine)Platform.getBundle((String)services[i2].getContributor().getName()).loadClass(type).newInstance();
                                }
                                catch (Exception e) {
                                    System.err.println("Failed to load encryption engine: " + type + " :: " + e.getMessage());
                                    e.printStackTrace();
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            this.encryption = encryption;
            LinkedHashSet<String> extraNames = new LinkedHashSet<String>();
            int i3 = 0;
            while (i3 < EXTENSIONS.length) {
                IExtension[] extensions = extensionRegistry.getExtensionPoint(EXTENSIONS[i3]).getExtensions();
                int j = 0;
                while (j < extensions.length) {
                    extraNames.add(String.valueOf(extensions[j].getContributor().getName()) + "@start");
                    ++j;
                }
                ++i3;
            }
            pluginNames.addAll(extraNames);
            this.pluginNames = Collections.unmodifiableList(pluginNames);
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                this.documentBuilder = dbf.newDocumentBuilder();
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.configurationDictionary.put((Object)"path", (Object)"/");
            HashSet<String> unsavedProjectNames = new HashSet<String>();
            IWorkbenchPage[] pages = workbench.getActiveWorkbenchWindow().getPages();
            int i4 = 0;
            while (i4 < pages.length) {
                IEditorReference[] editorReferences = pages[i4].getEditorReferences();
                int j = 0;
                while (j < editorReferences.length) {
                    if (editorReferences[j].isDirty()) {
                        IEditorInput editorInput = null;
                        try {
                            editorInput = editorReferences[j].getEditorInput();
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        if (editorInput instanceof IFileEditorInput) {
                            unsavedProjectNames.add(((IFileEditorInput)editorInput).getFile().getProject().getName());
                        }
                    }
                    ++j;
                }
                ++i4;
            }
            IProject[] array = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            HashMap<String, Project> projects = new HashMap<String, Project>(array.length);
            int i5 = 0;
            while (i5 < array.length) {
                try {
                    if (array[i5].isOpen()) {
                        Project p = null;
                        if (array[i5].hasNature("org.eclipse.vtp.desktop.projects.core.VoiceApplicationNature")) {
                            p = new ApplicationProject(array[i5]);
                            projects.put(array[i5].getName(), p);
                        }
                        if (array[i5].hasNature("org.eclipse.vtp.desktop.projects.core.VoiceApplicationFragmentNature")) {
                            p = new FragmentProject(array[i5]);
                            projects.put(array[i5].getName(), p);
                        }
                        if (array[i5].hasNature("org.eclipse.vtp.desktop.projects.voice.VoicePersonaNature")) {
                            p = new MediaProject(array[i5]);
                            projects.put(array[i5].getName(), p);
                        }
                        if (array[i5].hasNature("org.eclipse.vtp.desktop.projects.text.AuthorProjectNature")) {
                            p = new MediaProject(array[i5]);
                            projects.put(array[i5].getName(), p);
                        }
                        if (p != null && unsavedProjectNames.contains(array[i5].getName())) {
                            p.dirty = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i5;
            }
            this.projects = Collections.unmodifiableMap(projects);
            Iterator i22 = this.projects.values().iterator();
            while (i22.hasNext()) {
                try {
                    ((Project)i22.next()).init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            LinkedHashMap<Object, Bundle> plugIns = new LinkedHashMap<Object, Bundle>();
            plugIns.put(pluginNames.get(0), null);
            int i6 = 1;
            while (i6 < pluginNames.size()) {
                String pluginName = (String)pluginNames.get(i6);
                int at = pluginName.indexOf(64);
                if (at < 0) {
                    plugIns.put(pluginName, null);
                } else {
                    plugIns.put(pluginName.substring(0, at), null);
                }
                ++i6;
            }
            Bundle[] bundles = DesktopCorePlugin.getDefault().getBundles();
            int i7 = 0;
            while (i7 < bundles.length) {
                block49: {
                    Bundle bundle;
                    String symbolicName;
                    block50: {
                        if (bundles[i7].getState() == 1) break block49;
                        symbolicName = bundles[i7].getSymbolicName();
                        if ("system.bundle".equals(symbolicName)) {
                            symbolicName = (String)pluginNames.get(0);
                        }
                        if (plugIns.containsKey(symbolicName)) break block50;
                        String host = (String)bundles[i7].getHeaders().get("Fragment-Host");
                        if (host == null) break block49;
                        if (host.indexOf(59) >= 0) {
                            host = host.substring(0, host.indexOf(59));
                        }
                        if (!plugIns.containsKey(host = host.trim())) break block49;
                    }
                    if ((bundle = (Bundle)plugIns.get(symbolicName)) == null) {
                        plugIns.put(symbolicName, bundles[i7]);
                    } else {
                        Version oldVersion = new Version((String)bundle.getHeaders().get("Bundle-Version"));
                        Version newVersion = new Version((String)bundles[i7].getHeaders().get("Bundle-Version"));
                        if (newVersion.compareTo((Object)oldVersion) > 0) {
                            plugIns.put(symbolicName, bundles[i7]);
                        }
                    }
                }
                ++i7;
            }
            Iterator i32 = plugIns.entrySet().iterator();
            while (i32.hasNext()) {
                Map.Entry entry = i32.next();
                if (entry.getValue() == null) {
                    i32.remove();
                    continue;
                }
                entry.setValue(new PlugIn((Bundle)entry.getValue()));
            }
            this.plugIns = Collections.unmodifiableMap(plugIns);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        if (this.archive == archive) {
            return;
        }
        this.archive = archive;
        if (archive == null) {
            this.prefix = null;
        } else {
            String[] names = PREFERENCES.propertyNames();
            String path = archive.getAbsolutePath();
            String prefix = null;
            int i = 0;
            while (prefix == null && i < names.length) {
                if (names[i].startsWith(KEY_PREFIX_EXPORT) && names[i].length() > KEY_PREFIX_EXPORT.length() && names[i].indexOf(46, KEY_PREFIX_EXPORT.length()) < 0 && path.equals(PREFERENCES.getString(names[i]))) {
                    prefix = String.valueOf(names[i]) + ".";
                }
                ++i;
            }
            if (prefix == null) {
                prefix = KEY_PREFIX_EXPORT + Guid.createGUID() + ".";
            }
            this.prefix = prefix;
        }
        for (Project project : this.projects.values()) {
            if (archive == null) {
                project.clear();
                continue;
            }
            project.load();
        }
        this.fireArchiveChangedEvent();
    }

    public String[] getApplicationProjectNames() {
        ArrayList<String> names = new ArrayList<String>(this.projects.size());
        for (Project project : this.projects.values()) {
            if (!(project instanceof ApplicationProject)) continue;
            names.add(project.project.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getFragmentProjectNames() {
        ArrayList<String> names = new ArrayList<String>(this.projects.size());
        for (Project project : this.projects.values()) {
            if (!(project instanceof FragmentProject)) continue;
            names.add(project.project.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getMediaProjectNames() {
        ArrayList<String> names = new ArrayList<String>(this.projects.size());
        for (Project project : this.projects.values()) {
            if (!(project instanceof MediaProject)) continue;
            names.add(project.project.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public IProject getProject(String projectName) {
        Project project = (Project)this.projects.get(projectName);
        if (project == null) {
            return null;
        }
        return project.project;
    }

    String getProjectProperty(String projectName, String propertyName) {
        return this.getProjectProperty(projectName, propertyName, false);
    }

    String getProjectProperty(String projectName, String propertyName, boolean encrypted) {
        Project project = (Project)this.projects.get(projectName);
        if (project == null) {
            return null;
        }
        String property = project.getProperty(propertyName);
        if (property == null || property.length() == 0 || this.encryption == null || !encrypted) {
            return property;
        }
        return this.decrypt(property);
    }

    void setProjectProperty(String projectName, String propertyName, String propertyValue) {
        this.setProjectProperty(projectName, propertyName, propertyValue, false);
    }

    void setProjectProperty(String projectName, String propertyName, String propertyValue, boolean encrypted) {
        Project project = (Project)this.projects.get(projectName);
        if (project == null) {
            return;
        }
        if (propertyValue == null || propertyValue.length() == 0 || this.encryption == null || !encrypted) {
            project.setProperty(propertyName, propertyValue);
        } else {
            project.setProperty(propertyName, this.encrypt(propertyValue));
        }
    }

    String encrypt(String plainText) {
        if (this.encryption == null || plainText == null) {
            return plainText;
        }
        return new String(this.encryption.encrypt(plainText.toCharArray()));
    }

    String decrypt(String cypherText) {
        if (this.encryption == null || cypherText == null) {
            return cypherText;
        }
        return new String(this.encryption.decrypt(cypherText.toCharArray()));
    }

    public boolean isProjectSelected(String projectName) {
        if (this.archive == null) {
            return false;
        }
        Project project = (Project)this.projects.get(projectName);
        if (project == null) {
            return false;
        }
        return project.selectionCount > 0;
    }

    public boolean isProjectDirty(String projectName) {
        if (this.archive == null) {
            return false;
        }
        Project project = (Project)this.projects.get(projectName);
        if (project == null) {
            return false;
        }
        return project.dirty;
    }

    public void selectProject(String projectName) {
        if (this.archive == null) {
            return;
        }
        Object project = this.projects.get(projectName);
        if (project instanceof ApplicationProject) {
            if (((ApplicationProject)project).select()) {
                this.fireProjectSelectionChangedEvent();
            }
        } else if (project instanceof FragmentProject && ((FragmentProject)project).select()) {
            this.fireProjectSelectionChangedEvent();
        }
    }

    public void deselectProject(String projectName) {
        if (this.archive == null) {
            return;
        }
        Object project = this.projects.get(projectName);
        if (project instanceof ApplicationProject) {
            if (((ApplicationProject)project).deselect()) {
                this.fireProjectSelectionChangedEvent();
            }
        } else if (project instanceof FragmentProject && ((FragmentProject)project).deselect()) {
            this.fireProjectSelectionChangedEvent();
        }
    }

    public void exportWebApplication(IProgressMonitor monitor, ExporterExtension[] extensions) throws CoreException {
        if (this.archive == null) {
            return;
        }
        this.savePreferences(extensions);
        ZipOutputStream output = null;
        try {
            try {
                this.archive.delete();
                output = new ZipOutputStream(new FileOutputStream(this.archive));
                new WebApplicationBuilder(monitor, extensions, output).run();
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            CoreException ex = new CoreException((IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 0, String.valueOf(e.getMessage()), (Throwable)e));
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void addExporterObserver(ExporterObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void removeExporterObserver(ExporterObserver observer) {
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void fireArchiveChangedEvent() {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ((ExporterObserver)i.next()).archiveChanged(this);
        }
    }

    private void fireProjectSelectionChangedEvent() {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ((ExporterObserver)i.next()).projectSelectionChanged(this);
        }
    }

    private void savePreferences(ExporterExtension[] extensions) {
        PREFERENCES.setValue(KEY_EXPORT, this.archive.getAbsolutePath());
        PREFERENCES.setValue(this.prefix.substring(0, this.prefix.length() - 1), this.archive.getAbsolutePath());
        int i = 0;
        while (i < extensions.length) {
            extensions[i].savePrefrences();
            ++i;
        }
        Iterator i2 = this.projects.values().iterator();
        while (i2.hasNext()) {
            ((Project)i2.next()).save();
        }
        DesktopCorePlugin.getDefault().savePluginPreferences();
    }

    private final class ApplicationProject
    extends ProcessProject {
        final Map fragmentProjects;

        ApplicationProject(IProject project) throws Exception {
            super(project);
            this.fragmentProjects = new HashMap();
        }

        void init() throws Exception {
            super.init();
            NodeList applicationList = this.callDesign.getDocumentElement().getElementsByTagName("application");
            int i = 0;
            while (i < applicationList.getLength()) {
                NodeList modelList = ((Element)applicationList.item(i)).getElementsByTagName("model");
                int j = 0;
                while (j < modelList.getLength()) {
                    NodeList elementsList = ((Element)modelList.item(j)).getElementsByTagName("elements");
                    int k = 0;
                    while (k < elementsList.getLength()) {
                        NodeList fragmentElementList = ((Element)elementsList.item(k)).getElementsByTagName("fragment-element");
                        int l = 0;
                        while (l < fragmentElementList.getLength()) {
                            Element fragmentElement = (Element)fragmentElementList.item(l);
                            String includeID = fragmentElement.getAttribute("id");
                            String projectID = fragmentElement.getAttribute("instanceId");
                            FragmentProject project = null;
                            Iterator m = Exporter.this.projects.values().iterator();
                            while (project == null && m.hasNext()) {
                                Project p = (Project)m.next();
                                if (!(p instanceof FragmentProject) || !projectID.equals(((FragmentProject)p).id)) continue;
                                project = (FragmentProject)p;
                            }
                            if (project != null) {
                                this.fragmentProjects.put(includeID, project);
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }

        Collection getRequiredProjects() {
            Collection projects = super.getRequiredProjects();
            projects.addAll(this.fragmentProjects.values());
            return projects;
        }

        File getCallDesign() {
            return this.project.getFile("CallDesign.xml").getLocation().toFile();
        }
    }

    private static interface Builder {
        public ExporterExtension[] getExtensions();

        public void addEntry(String var1, File var2) throws IOException;

        public void addFileEntry(String var1, InputStream var2) throws IOException;

        public OutputStream writeFileEntry(String var1) throws IOException;

        public void addParentEntries(String var1) throws IOException;
    }

    private abstract class Component {
        int selectionCount = 0;

        private Component() {
        }
    }

    private final class FragmentProject
    extends ProcessProject {
        FragmentProject(IProject project) throws Exception {
            super(project);
        }

        File getCallDesign() {
            return this.project.getFile("CallDesign.frag").getLocation().toFile();
        }
    }

    private final class MediaProject
    extends Project {
        final Document config;
        final String id;
        final String formatter;

        MediaProject(IProject project) throws Exception {
            super(project);
            this.config = Exporter.this.documentBuilder.parse(project.getFile(".config").getLocation().toFile());
            this.id = this.config.getDocumentElement().getAttribute("id");
            this.formatter = this.config.getDocumentElement().getAttribute("language-pack");
        }

        void createPluginXML(Element pluginElement) {
            Element extensionElement = pluginElement.getOwnerDocument().createElement("extension");
            extensionElement.setAttribute("point", "org.eclipse.vtp.framework.engine.resources");
            Element resourcesElement = extensionElement.getOwnerDocument().createElement("resources");
            resourcesElement.setAttribute("id", this.project.getName());
            resourcesElement.setAttribute("name", this.project.getName());
            resourcesElement.setAttribute("path", "project/Media Files");
            extensionElement.appendChild(resourcesElement);
            pluginElement.appendChild(extensionElement);
        }
    }

    private final class PlugIn
    extends Component {
        final Bundle instance;

        PlugIn(Bundle instance) {
            this.instance = instance;
        }

        void install(Builder builder) throws IOException {
            String symbolicName = this.instance.getSymbolicName();
            if ("system.bundle".equals(symbolicName) || PLUGINS[0].equals(symbolicName)) {
                String jarName = Exporter.this.pluginNames.get(0) + "_" + this.instance.getHeaders().get("Bundle-Version") + ".jar";
                System.err.println("##### Adding: " + jarName);
                builder.addFileEntry("WEB-INF/eclipse/plugins/" + jarName, new FileInputStream(new File(new File(INSTALL_AREA, "plugins"), jarName)));
            } else {
                String path = null;
                if (this.instance.getLocation().startsWith("update@")) {
                    path = this.instance.getLocation().substring("update@".length());
                } else if (this.instance.getLocation().startsWith("initial@reference:file:")) {
                    path = this.instance.getLocation().substring("initial@reference:file:".length());
                }
                if (path == null) {
                    return;
                }
                File source = new File(INSTALL_AREA, path);
                if (!source.exists()) {
                    return;
                }
                String jarName = "WEB-INF/eclipse/plugins/" + symbolicName + "_" + this.instance.getHeaders().get("Bundle-Version");
                if (source.isFile()) {
                    builder.addFileEntry(String.valueOf(jarName) + ".jar", new FileInputStream(source));
                } else {
                    jarName = String.valueOf(jarName) + "/";
                    File buildProperties = new File(source, "build.properties");
                    if (buildProperties.exists()) {
                        ZipOutputStream output = null;
                        try {
                            Properties props = new Properties();
                            InputStream input = null;
                            try {
                                input = new FileInputStream(buildProperties);
                                props.load(input);
                            }
                            finally {
                                if (input != null) {
                                    input.close();
                                }
                            }
                            StringTokenizer i = new StringTokenizer(props.getProperty("bin.includes"), ",");
                            while (i.hasMoreTokens()) {
                                String binToken = i.nextToken().trim();
                                if (binToken.length() == 0) continue;
                                String target = props.getProperty("output." + binToken);
                                if (target == null) {
                                    builder.addEntry(String.valueOf(jarName) + binToken, new File(source, binToken));
                                    continue;
                                }
                                StringTokenizer j = new StringTokenizer(target, ",");
                                while (j.hasMoreTokens()) {
                                    String outputToken = j.nextToken().trim();
                                    if (outputToken.length() == 0) continue;
                                    String entryName = ".".equals(binToken) ? jarName : String.valueOf(jarName) + binToken;
                                    builder.addEntry(entryName, new File(source, outputToken));
                                }
                            }
                        }
                        finally {
                            if (output != null) {
                                output.close();
                            }
                        }
                    }
                    builder.addEntry(jarName, source);
                }
            }
        }
    }

    private abstract class ProcessProject
    extends Project {
        final Document buildPath;
        final String id;
        final Map brands;
        final Map mediaProjects;
        Document callDesign;

        ProcessProject(IProject project) throws Exception {
            super(project);
            this.brands = new HashMap();
            this.mediaProjects = new HashMap();
            this.callDesign = null;
            this.buildPath = Exporter.this.documentBuilder.parse(project.getFile(".buildPath").getLocation().toFile());
            this.id = this.buildPath.getDocumentElement().getAttribute("id");
            NodeList langSupportList = this.buildPath.getDocumentElement().getElementsByTagName("language-support");
            int i = 0;
            while (i < langSupportList.getLength()) {
                Element langSupport = (Element)langSupportList.item(i);
                NodeList list = langSupport.getElementsByTagName("language");
                int j = 0;
                while (j < list.getLength()) {
                    Element lang = (Element)list.item(j);
                    this.mediaProjects.put(String.valueOf(langSupport.getAttribute("interaction-type")) + ":" + lang.getAttribute("name"), lang.getAttribute("project"));
                    ++j;
                }
                ++i;
            }
            Element defaultBrand = (Element)((Element)this.buildPath.getDocumentElement().getElementsByTagName("brands").item(0)).getElementsByTagName("brand").item(0);
            this.buildBrands(this.brands, defaultBrand);
        }

        private void buildBrands(Map brand, Element element) {
            NodeList list = element.getElementsByTagName("brand");
            int i = 0;
            while (i < list.getLength()) {
                HashMap childBrand = new HashMap();
                Element childElement = (Element)list.item(i);
                this.buildBrands(childBrand, childElement);
                brand.put(childElement.getAttribute("name"), childBrand);
                ++i;
            }
        }

        abstract File getCallDesign();

        void init() throws Exception {
            super.init();
            Iterator i = this.mediaProjects.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String projectID = (String)entry.getValue();
                MediaProject project = null;
                Iterator j = Exporter.this.projects.values().iterator();
                while (project == null && j.hasNext()) {
                    Project p = (Project)j.next();
                    if (!(p instanceof MediaProject) || !projectID.equals(((MediaProject)p).id)) continue;
                    project = (MediaProject)p;
                }
                if (project == null) {
                    i.remove();
                    continue;
                }
                entry.setValue(project);
            }
            this.callDesign = Exporter.this.documentBuilder.parse(this.getCallDesign());
        }

        Collection getRequiredProjects() {
            return new ArrayList(this.mediaProjects.values());
        }

        Collection getConfigurationDictionaries() {
            ConfigurationDictionary config = new ConfigurationDictionary("org.eclipse.vtp.framework.engine.http.deployments." + this.symbolicName, "org.eclipse.vtp.framework.engine.http.deployments");
            config.put((Object)"deployment.id", (Object)this.project.getName());
            config.put((Object)"definition.id", (Object)this.project.getName());
            config.put((Object)"resources", (Object)this.mediaProjects.keySet().toArray(new String[this.mediaProjects.size()]));
            config.put((Object)"path", (Object)("/" + this.project.getName()));
            if (this instanceof FragmentProject) {
                config.put((Object)"fragment", (Object)"true");
            } else {
                config.put((Object)"fragment", (Object)"false");
            }
            return Collections.singleton(config);
        }

        void writeManifest(PrintStream ps) throws Exception {
            super.writeManifest(ps);
            ps.print("Bundle-ClassPath:");
            IResource[] wsFolders = this.project.getFolder("Web Services").members();
            boolean printed = false;
            int i = 0;
            while (i < wsFolders.length) {
                IFolder wsClasses;
                if (wsFolders[i].exists() && wsFolders[i].getType() == 2 && (wsClasses = ((IFolder)wsFolders[i]).getFolder(".classes")).exists()) {
                    if (printed) {
                        ps.println(",");
                    }
                    ps.print(" project/");
                    ps.print(wsClasses.getProjectRelativePath().toString());
                    printed = true;
                }
                ++i;
            }
            IResource[] dependencies = this.project.getFolder("Dependencies").members();
            int i2 = 0;
            while (i2 < dependencies.length) {
                if (dependencies[i2].exists() && (dependencies[i2].getType() == 2 || dependencies[i2].getType() == 1)) {
                    if (printed) {
                        ps.println(",");
                    }
                    ps.print(" project/");
                    ps.print(dependencies[i2].getProjectRelativePath().toString());
                    if (dependencies[i2].getType() == 2) {
                        ps.print("/");
                    }
                    printed = true;
                }
                ++i2;
            }
            if (!printed) {
                ps.print(".");
            }
        }

        void buildDefinitions(Builder builder, String path) throws Exception {
            HashMap formatterIDsByLanguage = new HashMap(this.mediaProjects.size());
            HashMap resourceManagerIDsByLanguage = new HashMap(this.mediaProjects.size());
            for (Map.Entry entry : this.mediaProjects.entrySet()) {
                System.err.println("#########formatterIDsByLanguage:" + entry.getKey() + ":" + ((MediaProject)entry.getValue()).formatter);
                formatterIDsByLanguage.put(entry.getKey(), ((MediaProject)entry.getValue()).formatter);
                System.err.println("#########resourceManagerIDsByLanguage:" + entry.getKey() + ":" + ((MediaProject)entry.getValue()).project.getName());
                resourceManagerIDsByLanguage.put(entry.getKey(), ((MediaProject)entry.getValue()).project.getName());
            }
            Document definition = new DefinitionBuilder(this.callDesign, Exporter.this.documentBuilder, this.project, this.brands, formatterIDsByLanguage, resourceManagerIDsByLanguage).getDefinition();
            Element servicesElement = (Element)definition.getDocumentElement().getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "services").item(0);
            ExporterExtension[] extensions = builder.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                extensions[i].createServiceConfigurations(this.project.getName(), servicesElement);
                ++i;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new OutputStreamWriter(builder.writeFileEntry(String.valueOf(path) + "process.xml"), "UTF-16"));
                Exporter.this.transformer.transform(new DOMSource(definition), new XMLWriter(pw).toXMLResult());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
        }

        void createPluginXML(Element pluginElement) {
            Element extensionElement = pluginElement.getOwnerDocument().createElement("extension");
            extensionElement.setAttribute("point", "org.eclipse.vtp.framework.engine.definitions");
            Element resourcesElement = extensionElement.getOwnerDocument().createElement("definition");
            resourcesElement.setAttribute("id", this.project.getName());
            resourcesElement.setAttribute("name", this.project.getName());
            resourcesElement.setAttribute("path", "process.xml");
            extensionElement.appendChild(resourcesElement);
            pluginElement.appendChild(extensionElement);
        }
    }

    private abstract class Project
    extends Component {
        final IProject project;
        final String symbolicName;
        String prefix = null;
        boolean dirty = false;

        Project(IProject project) throws Exception {
            this.project = project;
            this.symbolicName = project.getName();
        }

        String getProperty(String propertyName) {
            if (this.prefix == null) {
                return null;
            }
            return PREFERENCES.getString(String.valueOf(this.prefix) + propertyName);
        }

        void setProperty(String propertyName, String propertyValue) {
            if (this.prefix != null) {
                PREFERENCES.setValue(String.valueOf(this.prefix) + propertyName, propertyValue);
            }
        }

        void init() throws Exception {
        }

        void load() {
            this.prefix = String.valueOf(Exporter.this.prefix) + ".projects." + this.project.getName() + ".";
            this.selectionCount = 0;
        }

        void clear() {
            this.selectionCount = 0;
            this.prefix = null;
        }

        void save() {
        }

        boolean select() {
            ++this.selectionCount;
            if (this.selectionCount == 1) {
                Iterator i = this.getRequiredProjects().iterator();
                while (i.hasNext()) {
                    ((Project)i.next()).select();
                }
                return true;
            }
            return false;
        }

        boolean deselect() {
            if (this.selectionCount == 0) {
                return false;
            }
            --this.selectionCount;
            if (this.selectionCount == 0) {
                Iterator i = this.getRequiredProjects().iterator();
                while (i.hasNext()) {
                    ((Project)i.next()).deselect();
                }
                return true;
            }
            return false;
        }

        Collection getRequiredProjects() {
            return Collections.EMPTY_LIST;
        }

        Collection getConfigurationDictionaries() {
            return Collections.EMPTY_LIST;
        }

        void compile(Builder builder) throws Exception {
            String path = "WEB-INF/eclipse/plugins/" + this.symbolicName + "_0.0.0/";
            PrintStream ps = null;
            try {
                ps = new PrintStream(builder.writeFileEntry(String.valueOf(path) + "META-INF/MANIFEST.MF"));
                this.writeManifest(ps);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                ps = null;
            }
            builder.addEntry(String.valueOf(path) + "project/", this.project.getLocation().toFile());
            this.buildDefinitions(builder, path);
            Document pluginXmlDoc = Exporter.this.documentBuilder.newDocument();
            pluginXmlDoc.appendChild(pluginXmlDoc.createProcessingInstruction("eclipse", "version=\"3.2\""));
            Element pluginElement = pluginXmlDoc.createElement("plugins");
            pluginXmlDoc.appendChild(pluginElement);
            this.createPluginXML(pluginElement);
            if (pluginElement.getChildNodes().getLength() > 0) {
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new OutputStreamWriter(builder.writeFileEntry(String.valueOf(path) + "plugin.xml"), "UTF-16"));
                    Exporter.this.transformer.transform(new DOMSource(pluginXmlDoc), new XMLWriter(pw).toXMLResult());
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                    pw = null;
                }
            }
        }

        void writeManifest(PrintStream ps) throws Exception {
            ps.println("Manifest-Version: 1.0");
            ps.println("Bundle-ManifestVersion: 2");
            ps.print("Bundle-Name: ");
            ps.println(this.project.getName());
            ps.print("Bundle-SymbolicName: ");
            ps.print(this.symbolicName);
            ps.println(";singleton:=true");
            ps.println("Bundle-Version: 0.0.0");
            ps.println("Bundle-Localization: plugin");
            ps.print("Require-Bundle:");
            boolean printed = false;
            Iterator i = Exporter.this.plugIns.keySet().iterator();
            while (i.hasNext()) {
                if (printed) {
                    ps.println(",");
                }
                ps.print(" ");
                ps.print(i.next());
                ps.print(";resolution:=optional");
                printed = true;
            }
            ps.println();
        }

        void buildDefinitions(Builder builder, String path) throws Exception {
        }

        void createPluginXML(Element pluginElement) {
        }
    }

    private final class WebApplicationBuilder
    implements Builder {
        private final IProgressMonitor monitor;
        private final ExporterExtension[] extensions;
        private final ZipOutputStream output;
        private final Map projects;
        private final Map plugIns;
        private final Set entries = new HashSet();

        WebApplicationBuilder(IProgressMonitor monitor, ExporterExtension[] extensions, ZipOutputStream output) {
            this.monitor = monitor;
            this.extensions = extensions;
            this.output = output;
            this.projects = new HashMap(Exporter.this.projects);
            Iterator i = this.projects.values().iterator();
            while (i.hasNext()) {
                if (((Project)i.next()).selectionCount != 0) continue;
                i.remove();
            }
            this.plugIns = new LinkedHashMap(Exporter.this.plugIns);
        }

        boolean run() throws Exception {
            this.monitor.beginTask("building WAR file...", 2);
            this.monitor.setTaskName("Constructing web application...");
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.buildWebApplication();
            this.monitor.worked(1);
            this.monitor.setTaskName("Compiling projects...");
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.compileProjects();
            this.monitor.worked(1);
            this.monitor.done();
            return true;
        }

        private void buildWebApplication() throws Exception {
            Iterator i2;
            if (this.monitor.isCanceled()) {
                return;
            }
            this.addFileEntry("WEB-INF/web.xml", this.getClass().getResourceAsStream("/web.xml"));
            this.addFileEntry("WEB-INF/eclipse/launch.ini", this.getClass().getResourceAsStream("/launch.ini"));
            PrintStream ps = null;
            try {
                ps = new PrintStream(this.writeFileEntry("WEB-INF/eclipse/configuration/config.ini"));
                ps.println("#Eclipse Runtime Configuration File");
                ps.print("osgi.bundles=javax.servlet@start");
                int i = 1;
                while (i < Exporter.this.pluginNames.size()) {
                    ps.print(',');
                    ps.println("\\");
                    ps.print("  ");
                    ps.print(Exporter.this.pluginNames.get(i));
                    ++i;
                }
                i2 = this.projects.values().iterator();
                while (i2.hasNext()) {
                    ps.print(',');
                    ps.println("\\");
                    ps.print("  ");
                    ps.print(((Project)i2.next()).symbolicName);
                    ps.print("@start");
                }
                ps.println();
                ps.println("osgi.bundles.defaultStartLevel=4");
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                ps = null;
            }
            this.addFileEntry("WEB-INF/eclipse/plugins/javax.servlet_2.4.0/META-INF/MANIFEST.MF", this.getClass().getResourceAsStream("/servletManifest.mf"));
            i2 = this.plugIns.values().iterator();
            while (i2.hasNext()) {
                ((PlugIn)i2.next()).install(this);
            }
            this.addFileEntry("WEB-INF/eclipse/plugins/static.configuration_0.0.0/META-INF/MANIFEST.MF", this.getClass().getResourceAsStream("/staticConfigManifest.mf"));
            LinkedList<ConfigurationDictionary> dictionaries = new LinkedList<ConfigurationDictionary>();
            dictionaries.add(Exporter.this.configurationDictionary);
            Iterator i = this.projects.values().iterator();
            while (i.hasNext()) {
                dictionaries.addAll(((Project)i.next()).getConfigurationDictionaries());
            }
            Document document = Exporter.this.documentBuilder.newDocument();
            document.appendChild(ConfigurationDictionary.saveAll((Document)document, (ConfigurationDictionary[])dictionaries.toArray(new ConfigurationDictionary[dictionaries.size()])));
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new OutputStreamWriter(this.writeFileEntry("WEB-INF/eclipse/plugins/static.configuration_0.0.0/META-INF/services/" + StaticConfigurationAdmin.class.getName()), "UTF-16"));
                    Exporter.this.transformer.transform(new DOMSource(document), new XMLWriter(pw).toXMLResult());
                }
                catch (TransformerException e) {
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e);
                    throw ex;
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
            this.addFileEntry("WEB-INF/lib/servletbridge.jar", this.getClass().getResourceAsStream("/servletbridge.jar"));
        }

        private void compileProjects() throws Exception {
            HashMap projects = new HashMap(this.projects);
            Iterator i = projects.values().iterator();
            while (i.hasNext()) {
                if (((Project)i.next()).selectionCount != 0) continue;
                i.remove();
            }
            i = projects.values().iterator();
            while (i.hasNext()) {
                ((Project)i.next()).compile(this);
            }
        }

        public ExporterExtension[] getExtensions() {
            return this.extensions;
        }

        public void addEntry(String entryName, File resource) throws IOException {
            if (resource.isFile()) {
                this.addFileEntry(entryName, new FileInputStream(resource));
            } else {
                File[] files;
                if (".svn".equals(resource.getName())) {
                    return;
                }
                if ("CVS".equals(resource.getName())) {
                    return;
                }
                this.addParentEntries(entryName);
                if (this.entries.add(entryName)) {
                    this.output.putNextEntry(new ZipEntry(entryName));
                    this.output.closeEntry();
                }
                if ((files = resource.listFiles()) != null) {
                    int i = 0;
                    while (i < files.length) {
                        this.addEntry(String.valueOf(entryName) + (files[i].isDirectory() ? String.valueOf(files[i].getName()) + "/" : files[i].getName()), files[i].getCanonicalFile());
                        ++i;
                    }
                }
            }
        }

        public void addFileEntry(String entryName, InputStream data) throws IOException {
            if (data == null) {
                return;
            }
            this.addParentEntries(entryName);
            if (!this.entries.add(entryName)) {
                return;
            }
            try {
                byte[] buffer = new byte[10240];
                try {
                    this.output.putNextEntry(new ZipEntry(entryName));
                    int i = data.read(buffer);
                    while (i >= 0) {
                        this.output.write(buffer, 0, i);
                        i = data.read(buffer);
                    }
                }
                finally {
                    this.output.closeEntry();
                }
            }
            catch (Throwable throwable) {
                try {
                    data.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }

        public OutputStream writeFileEntry(String entryName) throws IOException {
            this.addParentEntries(entryName);
            if (!this.entries.add(entryName)) {
                return null;
            }
            this.output.putNextEntry(new ZipEntry(entryName));
            return new OutputStream(){

                public void write(int b) throws IOException {
                    WebApplicationBuilder.this.output.write(b);
                }

                public void write(byte[] b) throws IOException {
                    WebApplicationBuilder.this.output.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    WebApplicationBuilder.this.output.write(b, off, len);
                }

                public void close() throws IOException {
                    WebApplicationBuilder.this.output.closeEntry();
                }
            };
        }

        public void addParentEntries(String entryName) throws IOException {
            int lastSlash = entryName.lastIndexOf(47);
            if (lastSlash == entryName.length() - 1) {
                lastSlash = entryName.lastIndexOf(47, lastSlash - 1);
            }
            if (lastSlash < 0) {
                return;
            }
            String parentEntryName = entryName.substring(0, lastSlash + 1);
            this.addParentEntries(parentEntryName);
            if (this.entries.add(parentEntryName)) {
                this.output.putNextEntry(new ZipEntry(parentEntryName));
                this.output.closeEntry();
            }
        }
    }
}

