/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.projects.core.export.ExportWebappPage;
import org.eclipse.vtp.desktop.projects.core.export.Exporter;

public class SelectApplicationsPage
extends ExportWebappPage
implements ICheckStateListener,
IStructuredContentProvider {
    private CheckboxTableViewer viewer = null;

    public SelectApplicationsPage(Exporter exporter) {
        super("SelectApplicationsPage", "Select the Applications and Fragments to Export", null, exporter);
    }

    public void createControl(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.exporter);
        this.setControl((Control)this.viewer.getTable());
        this.projectSelectionChanged(this.exporter);
    }

    public void projectSelectionChanged(Exporter exporter) {
        if (this.viewer == null) {
            return;
        }
        String[] appNames = (String[])this.getElements(null);
        int count = 0;
        boolean dirty = false;
        int i = 0;
        while (i < appNames.length) {
            boolean selected = exporter.isProjectSelected(appNames[i]);
            if (selected) {
                ++count;
                dirty |= exporter.isProjectDirty(appNames[i]);
            }
            this.viewer.setChecked((Object)appNames[i], selected);
            ++i;
        }
        String[] mediaNames = exporter.getMediaProjectNames();
        int i2 = 0;
        while (i2 < mediaNames.length) {
            if (exporter.isProjectSelected(mediaNames[i2])) {
                dirty |= exporter.isProjectDirty(mediaNames[i2]);
            }
            ++i2;
        }
        if (dirty) {
            MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Unsaved Projects", (String)"One or more of the projects to be exported contains unsaved resources.");
        }
        this.setPageComplete(count > 0);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.exporter.selectProject((String)event.getElement());
        } else {
            this.exporter.deselectProject((String)event.getElement());
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        String[] apps = this.exporter.getApplicationProjectNames();
        String[] frags = this.exporter.getFragmentProjectNames();
        Object[] all = new String[apps.length + frags.length];
        System.arraycopy(apps, 0, all, 0, apps.length);
        System.arraycopy(frags, 0, all, apps.length, frags.length);
        return all;
    }
}

