/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.osgi.framework.Bundle;

public class _OldExportWebappWizard
extends Wizard
implements IExportWizard {
    private static final String DB_PROP_TYPE = "type";
    private static final String DB_TYPE_JNDI = "jndi";
    private static final String DB_TYPE_JDBC = "jdbc";
    private static final String DB_PROP_JNDI_URI = "jndi.uri";
    private static final String DB_PROP_JNDI_USR = "jndi.usr";
    private static final String DB_PROP_JNDI_PWD = "jndi.pwd";
    private static final String DB_PROP_JDBC_DVR = "jdbc.dvr";
    private static final String DB_PROP_JDBC_URL = "jdbc.url";
    private static final String DB_PROP_JDBC_USR = "jdbc.usr";
    private static final String DB_PROP_JDBC_PWD = "jdbc.pwd";
    private static final String WS_PROP_ENDPOINT = "endpoint";
    private URL installURL = null;
    private IApplicationProject applicationProject = null;
    private List fragmentProjects = new ArrayList();
    private List personaProjects = new ArrayList();
    private Map frameworkBundles = new TreeMap();
    private Map axisJars = new TreeMap();
    private Map languageBundles = new TreeMap();
    private Map moduleBundles = new TreeMap();
    private Map dependencies = new TreeMap();
    private Map databases = new TreeMap();
    private Map webServices = new TreeMap();
    private File war = null;

    public _OldExportWebappWizard() {
        this.setNeedsProgressMonitor(true);
    }

    private void initializeWizard(Object selected) throws CoreException {
    }

    private boolean writeWAR(IProgressMonitor monitor, ZipOutputStream out) throws CoreException {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        try {
            this.initializeWizard(selected);
        }
        catch (CoreException e) {
            new ErrorDialog(this.getShell(), "Error Exporting Application", e.getMessage(), e.getStatus(), 4).open();
            IllegalStateException ex = new IllegalStateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectWARPage());
        if (!this.databases.isEmpty()) {
            this.addPage((IWizardPage)new ConfigureDatabasesPage());
        }
        if (!this.webServices.isEmpty()) {
            this.addPage((IWizardPage)new ConfigureWebServicesPage());
        }
        this.addPage((IWizardPage)new SelectIncludesPage());
    }

    public boolean canFinish() {
        return this.war != null;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * Loose catch block
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block49: {
                        File parent = _OldExportWebappWizard.this.war.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        boolean success = false;
                        ZipOutputStream out = null;
                        try {
                            out = new ZipOutputStream(new FileOutputStream(_OldExportWebappWizard.this.war));
                            success = _OldExportWebappWizard.this.writeWAR(monitor, out);
                        }
                        catch (FileNotFoundException e) {
                            new ErrorDialog(_OldExportWebappWizard.this.getShell(), "WAR file not found", e.getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                            try {
                                try {
                                    if (out != null) {
                                        out.close();
                                    }
                                    break block49;
                                }
                                catch (IOException iOException) {
                                    if (!success) {
                                        _OldExportWebappWizard.this.war.delete();
                                    }
                                    break block49;
                                }
                            }
                            finally {
                                if (!success) {
                                    _OldExportWebappWizard.this.war.delete();
                                }
                            }
                        }
                        catch (CoreException e) {
                            new ErrorDialog(_OldExportWebappWizard.this.getShell(), "Error exporting WAR", e.getMessage(), e.getStatus(), 4).open();
                            try {
                                try {
                                    if (out != null) {
                                        out.close();
                                    }
                                    break block49;
                                }
                                catch (IOException iOException) {
                                    if (!success) {
                                        _OldExportWebappWizard.this.war.delete();
                                    }
                                    break block49;
                                }
                            }
                            finally {
                                if (!success) {
                                    _OldExportWebappWizard.this.war.delete();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            new ErrorDialog(_OldExportWebappWizard.this.getShell(), "Unknown error", e.getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
                            {
                                catch (Throwable throwable) {
                                    block51: {
                                        try {
                                            try {
                                                if (out != null) {
                                                    out.close();
                                                }
                                            }
                                            catch (IOException iOException) {
                                                if (!success) {
                                                    _OldExportWebappWizard.this.war.delete();
                                                }
                                                break block51;
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (!success) {
                                                _OldExportWebappWizard.this.war.delete();
                                            }
                                            throw throwable2;
                                        }
                                        if (!success) {
                                            _OldExportWebappWizard.this.war.delete();
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                try {
                                    if (out != null) {
                                        out.close();
                                    }
                                    break block49;
                                }
                                catch (IOException iOException) {
                                    if (!success) {
                                        _OldExportWebappWizard.this.war.delete();
                                    }
                                    break block49;
                                }
                            }
                            finally {
                                if (!success) {
                                    _OldExportWebappWizard.this.war.delete();
                                }
                            }
                        }
                        try {
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException iOException) {
                                if (!success) {
                                    _OldExportWebappWizard.this.war.delete();
                                }
                            }
                        }
                        finally {
                            if (!success) {
                                _OldExportWebappWizard.this.war.delete();
                            }
                        }
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.getShell(), "Error preparing WAR", e.getTargetException().getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getTargetException().getMessage(), e.getTargetException()), 4).open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error preparing WAR", e.getMessage(), (IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e), 4).open();
        }
        return false;
    }

    private class ConfigureDatabasesPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        Combo typeCombo;
        Composite stackComposite;
        StackLayout stackLayout;
        Composite jndiComposite;
        Composite jdbcComposite;
        Text jndiUriText;
        Text jndiUsrText;
        Text jndiPwdText;
        Text jdbcDvrText;
        Text jdbcUrlText;
        Text jdbcUsrText;
        Text jdbcPwdText;

        ConfigureDatabasesPage() {
            super("Configure the application databases");
            this.typeCombo = null;
            this.stackComposite = null;
            this.stackLayout = null;
            this.jndiComposite = null;
            this.jdbcComposite = null;
            this.jndiUriText = null;
            this.jndiUsrText = null;
            this.jndiPwdText = null;
            this.jdbcDvrText = null;
            this.jdbcUrlText = null;
            this.jdbcUsrText = null;
            this.jdbcPwdText = null;
            this.setTitle(this.getName());
        }

        void databaseSelectionChanged() {
        }

        void typeSelectionChanged() {
        }

        public void createControl(Composite parent) {
        }

        public void modifyText(ModifyEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ConfigureWebServicesPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        List portList;
        Text endpointText;

        ConfigureWebServicesPage() {
            super("Configure the application web services");
            this.portList = null;
            this.endpointText = null;
            this.setTitle(this.getName());
        }

        void portSelectionChanged() {
        }

        public void createControl(Composite parent) {
        }

        public void modifyText(ModifyEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == this.portList) {
                this.portSelectionChanged();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class EmbeddedAxisJar
    extends EmbeddedJar {
        final File jar;

        EmbeddedAxisJar(File jar) {
            this.jar = jar;
            this.shouldBeEmbedded = true;
        }

        public String toString() {
            return "Axis: " + this.getFileName();
        }

        final boolean canBeEmbedded() {
            return true;
        }

        final String getFileName() {
            return this.jar.getName();
        }

        final InputStream openStream() throws CoreException {
            try {
                return new FileInputStream(this.jar);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
        }
    }

    private abstract class EmbeddedBundleJar
    extends EmbeddedJar {
        final Bundle bundle;
        final URL bundleUrl;

        EmbeddedBundleJar(Bundle bundle) {
            this.bundle = bundle;
            URL bundleUrl = null;
            if (bundle.getLocation().startsWith("update@") && bundle.getLocation().endsWith(".jar")) {
                try {
                    bundleUrl = new URL(_OldExportWebappWizard.this.installURL, bundle.getLocation().substring(7));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.bundleUrl = bundleUrl;
            this.shouldBeEmbedded = this.canBeEmbedded();
        }

        final boolean canBeEmbedded() {
            return this.bundleUrl != null;
        }

        final String getFileName() {
            return String.valueOf(this.bundle.getSymbolicName()) + "_" + this.bundle.getHeaders().get("Bundle-Version") + ".jar";
        }

        final InputStream openStream() throws CoreException {
            try {
                return this.bundleUrl.openStream();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
        }
    }

    private final class EmbeddedDependencyJar
    extends EmbeddedJar {
        final IFile jarFile;

        EmbeddedDependencyJar(IFile jarFile) {
            this.jarFile = jarFile;
        }

        boolean canBeEmbedded() {
            return this.jarFile.exists();
        }

        String getFileName() {
            return this.jarFile.getName();
        }

        InputStream openStream() throws CoreException {
            return this.jarFile.getContents();
        }

        public String toString() {
            return "Dependency: " + this.jarFile.getName();
        }
    }

    private final class EmbeddedFrameworkJar
    extends EmbeddedBundleJar {
        EmbeddedFrameworkJar(Bundle bundle) {
            super(bundle);
        }

        public String toString() {
            return (String)this.bundle.getHeaders().get("Bundle-Name");
        }
    }

    private abstract class EmbeddedJar {
        boolean shouldBeEmbedded = true;

        private EmbeddedJar() {
        }

        abstract boolean canBeEmbedded();

        abstract String getFileName();

        abstract InputStream openStream() throws CoreException;

        final void embed(ZipOutputStream out) throws CoreException {
            if (!this.canBeEmbedded()) {
                return;
            }
            if (!this.shouldBeEmbedded) {
                return;
            }
            InputStream in = null;
            try {
                try {
                    in = this.openStream();
                    out.putNextEntry(new ZipEntry("WEB-INF/lib/" + this.getFileName()));
                    byte[] buffer = new byte[10240];
                    int i = in.read(buffer);
                    while (i >= 0) {
                        out.write(buffer, 0, i);
                        i = in.read(buffer);
                    }
                    out.closeEntry();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private final class EmbeddedLanguagePackJar
    extends EmbeddedBundleJar {
        final String language;

        EmbeddedLanguagePackJar(Bundle bundle, String languageCode) {
            super(bundle);
            String language = null;
            String country = null;
            String variant = null;
            StringTokenizer st = new StringTokenizer(languageCode, "-_");
            if (st.hasMoreTokens()) {
                language = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                country = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                variant = st.nextToken();
            }
            this.language = language == null ? Locale.getDefault().getDisplayName() : (country == null ? new Locale(language).getDisplayName() : (variant == null ? new Locale(language, country).getDisplayName() : new Locale(language, country, variant).getDisplayName()));
        }

        public String toString() {
            return "Language Pack for " + this.language;
        }
    }

    private final class EmbeddedModuleJar
    extends EmbeddedBundleJar {
        final String vendor;
        final String moduleGroup;
        final String version;

        EmbeddedModuleJar(Bundle bundle, String vendor, String moduleGroup, String version) {
            super(bundle);
            this.vendor = vendor;
            this.moduleGroup = moduleGroup;
            this.version = version;
        }

        public String toString() {
            return String.valueOf(this.moduleGroup) + " module group version " + this.version + " from " + this.vendor;
        }
    }

    private class SelectIncludesPage
    extends WizardPage
    implements ICheckStateListener {
        private CheckboxTableViewer viewer;

        SelectIncludesPage() {
            super("Select the JAR files to include");
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            LinkedList list = new LinkedList();
            list.addAll(_OldExportWebappWizard.this.frameworkBundles.values());
            list.addAll(_OldExportWebappWizard.this.axisJars.values());
            list.addAll(_OldExportWebappWizard.this.languageBundles.values());
            list.addAll(_OldExportWebappWizard.this.moduleBundles.values());
            list.addAll(_OldExportWebappWizard.this.dependencies.values());
            this.viewer.add(list.toArray());
            for (EmbeddedJar jar : list) {
                if (jar.canBeEmbedded()) {
                    this.viewer.setChecked((Object)jar, true);
                    continue;
                }
                this.viewer.setGrayed((Object)jar, true);
            }
            this.viewer.addCheckStateListener((ICheckStateListener)this);
            this.setControl((Control)this.viewer.getTable());
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            EmbeddedJar jar = (EmbeddedJar)event.getElement();
            if (!event.getChecked()) {
                jar.shouldBeEmbedded = false;
            } else if (jar.canBeEmbedded()) {
                jar.shouldBeEmbedded = true;
            } else {
                this.viewer.setChecked((Object)jar, false);
            }
        }
    }

    private class SelectWARPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        Text pathText;

        SelectWARPage() {
            super("Select a WAR file");
            this.pathText = null;
            this.setTitle(this.getName());
        }

        void evaluateState() {
            String msg = null;
            String path = this.pathText.getText();
            if (path == null || path.length() == 0) {
                msg = "Select a WAR file to export to.";
            } else if (new File(path).isDirectory()) {
                msg = "Select a file, not a directory.";
            }
            if (msg == null) {
                _OldExportWebappWizard.this.war = new File(path);
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                _OldExportWebappWizard.this.war = null;
                this.setErrorMessage(msg);
                this.setPageComplete(false);
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            Label lbl = new Label(composite, 0);
            lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            lbl.setText("WAR file:");
            this.pathText = new Text(composite, 2048);
            this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.pathText.addModifyListener((ModifyListener)this);
            Button browseButton = new Button(composite, 8);
            browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            browseButton.setText("Browse...");
            browseButton.addSelectionListener((SelectionListener)this);
            this.setControl((Control)composite);
            this.pathText.setFocus();
            this.evaluateState();
        }

        public void modifyText(ModifyEvent e) {
            this.evaluateState();
        }

        public void widgetSelected(SelectionEvent e) {
            String path = new FileDialog(this.getShell()).open();
            if (path == null) {
                return;
            }
            this.pathText.setText(path);
            this.evaluateState();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class XMLWriter {
        final PrintStream out;
        int depth = 0;

        XMLWriter(OutputStream out) {
            this.out = new PrintStream(out);
            this.out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.out.println();
            this.out.println("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" ");
            this.out.println("                         \"http://java.sun.com/dtd/web-app_2_3.dtd\">");
            this.out.println();
        }

        void startElement(String name) {
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.println("<" + name + ">");
            ++this.depth;
        }

        void writeElement(String name, String value) {
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.print("<" + name + ">");
            this.out.print(value);
            this.out.println("</" + name + ">");
        }

        void endElement(String name) {
            --this.depth;
            int i = 0;
            while (i < this.depth) {
                this.out.print("\t");
                ++i;
            }
            this.out.println("</" + name + ">");
        }

        void close() {
            this.out.flush();
        }
    }
}

