/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragment;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.ApplicationFragmentProject;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationFragment
extends VoiceResource
implements IApplicationFragment {
    IFile file;
    String fragmentId = null;
    ApplicationFragmentProject project;

    public ApplicationFragment(IFile file, ApplicationFragmentProject project) {
        this.file = file;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            System.out.println(builder.getDOMImplementation().toString());
            System.out.println("supports namespaces: " + builder.isNamespaceAware());
            Document document = builder.parse(file.getContents());
            Element rootElement = document.getDocumentElement();
            if (!rootElement.getTagName().equals("fragment-definition")) {
                throw new IllegalArgumentException("The file provided is not a valid application definition file");
            }
            this.fragmentId = rootElement.getAttribute("id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.project = project;
        this.activateEvents();
    }

    public String getName() {
        return this.file.getName();
    }

    public IVoiceToolsProject getProject() {
        return this.project;
    }

    public IFile getUnderlyingFile() {
        return this.file;
    }

    public InputStream read() throws CoreException {
        return this.file.getContents();
    }

    public void write(InputStream in) throws CoreException {
        this.file.setContents(in, true, true, null);
    }

    public IVoiceToolsResource getParent() {
        return this.project;
    }

    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    public String getFragmentId() {
        return this.fragmentId;
    }
}

