/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.BusinessObject;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceToolsDesignProject;
import org.eclipse.vtp.framework.util.Guid;

public class BusinessObjectSet
extends VoiceResource
implements IBusinessObjectSet {
    private static String businessObjectTemplate = "<business-object id=\"[id]\" name=\"[name]\">\t<fields></fields></business-object>";
    private VoiceToolsDesignProject project;
    private IFolder folder;

    public BusinessObjectSet(VoiceToolsDesignProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
        this.activateEvents();
    }

    public String getName() {
        return this.folder.getName();
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public IVoiceToolsResource getParent() {
        return this.project;
    }

    public List getBusinessObjects() {
        ArrayList<BusinessObject> ret = new ArrayList<BusinessObject>();
        try {
            IResource[] res = this.folder.members();
            int i = 0;
            while (i < res.length) {
                if (res[i] instanceof IFile) {
                    BusinessObject bo = new BusinessObject(this, (IFile)res[i]);
                    ret.add(bo);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public IBusinessObject createBusinessObject(String name) throws CoreException {
        IFile objectFile = this.folder.getFile(String.valueOf(name) + ".dod");
        if (objectFile.exists()) {
            throw new IllegalArgumentException("Business Object with that name already exists: " + name);
        }
        String template = new String(businessObjectTemplate);
        template = template.replaceAll("\\[id\\]", Guid.createGUID());
        template = template.replaceAll("\\[name\\]", name);
        objectFile.create((InputStream)new ByteArrayInputStream(template.getBytes()), true, null);
        BusinessObject bo = new BusinessObject(this, objectFile);
        this.refresh();
        return bo;
    }

    public void deleteBusinessObject(IBusinessObject businessObject) {
    }
}

