/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IDatabase;
import org.eclipse.vtp.desktop.projects.core.IDatabaseSet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.Database;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceToolsDesignProject;

public class DatabaseSet
extends VoiceResource
implements IDatabaseSet {
    private VoiceToolsDesignProject project;
    private IFolder folder;

    public DatabaseSet(VoiceToolsDesignProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
        this.activateEvents();
    }

    public String getName() {
        return this.folder.getName();
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public IVoiceToolsResource getParent() {
        return this.project;
    }

    public List getDatabases() {
        ArrayList<Database> ret = new ArrayList<Database>();
        try {
            IResource[] res = this.folder.members();
            int i = 0;
            while (i < res.length) {
                if (res[i] instanceof IFolder && !res[i].getName().startsWith(".")) {
                    Database database = new Database(this, (IFolder)res[i]);
                    ret.add(database);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public IDatabase createDatabase(String name) throws CoreException {
        IFolder databaseFolder = this.folder.getFolder(name);
        if (databaseFolder.exists()) {
            throw new IllegalArgumentException("A Database with that name already exists: " + name);
        }
        databaseFolder.create(true, false, null);
        Database database = new Database(this, databaseFolder);
        this.refresh();
        return database;
    }

    public void deleteDatabase(IDatabase database) {
    }
}

