/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.ColumnType;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IDatabaseTable;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.projects.core.internals.Database;
import org.eclipse.vtp.desktop.projects.core.internals.DatabaseTableColumn;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseTable
extends VoiceResource
implements IDatabaseTable {
    Database database;
    IFile file;
    String name;
    List columns;

    public DatabaseTable(Database database, IFile file) {
        this.database = database;
        this.file = file;
        this.activateEvents();
        this.loadModel();
    }

    private void loadModel() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file.getContents());
            Element rootElement = document.getDocumentElement();
            this.name = rootElement.getAttribute("name");
            this.columns = new ArrayList();
            NodeList nl = rootElement.getElementsByTagName("column");
            int i = 0;
            while (i < nl.getLength()) {
                Element fieldElement = (Element)nl.item(i);
                String fieldName = fieldElement.getAttribute("name");
                NodeList dtnl = fieldElement.getElementsByTagName("column-type");
                if (dtnl.getLength() > 0) {
                    ColumnType fieldDataType = ColumnType.load((Element)dtnl.item(0));
                    DatabaseTableColumn dtc = new DatabaseTableColumn(this, fieldName, fieldDataType);
                    this.columns.add(dtc);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    public String getName() {
        return this.name;
    }

    public List getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public IVoiceToolsResource getParent() {
        return this.database;
    }

    public void write(InputStream source) throws CoreException {
        this.file.setContents(source, true, true, null);
        DesktopCorePlugin.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadModel();
            this.refresh();
        } else {
            super.processObjectEvent(event);
        }
    }

    public void delete() throws CoreException {
        this.file.delete(false, null);
        this.database.refresh();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseTable) {
            return ((DatabaseTable)obj).database.equals(this.database) && ((DatabaseTable)obj).name.equals(this.name);
        }
        return false;
    }

    public IFile getUnderlyingFile() {
        return this.file;
    }
}

