/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IDependency;
import org.eclipse.vtp.desktop.projects.core.IDependencySet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.projects.core.internals.Dependency;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;

public class DependencySet
extends VoiceResource
implements IDependencySet {
    private final IVoiceToolsDesignProject project;
    private final IFolder folder;

    public DependencySet(IVoiceToolsDesignProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public String getName() {
        return this.folder.getName();
    }

    public IVoiceToolsResource getParent() {
        return this.project;
    }

    public List getDependencies() {
        LinkedList<Dependency> results = new LinkedList<Dependency>();
        try {
            IResource[] members = this.folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getType() == 1) {
                    results.add(new Dependency(this, (IFile)members[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    public IDependency createDependency(String name, URL content) {
        System.out.println("creating dependency!");
        file = this.folder.getFile(name);
        in = null;
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            in = content.openStream();
            file.setContents(in, true, false, null);
        }
        catch (IOException e) {
            e.printStackTrace();
lbl13:
            // 2 sources

            while (true) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException v0) {}
                return null;
            }
        }
        catch (CoreException e) {
            try {
                e.printStackTrace();
                ** continue;
            }
            catch (Throwable var6_7) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException v1) {}
                throw var6_7;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException v2) {}
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
        return new Dependency(this, file);
    }

    public void removeDependency(IDependency dependency) {
        IFile file = this.folder.getFile(dependency.getName());
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
    }
}

