/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vtp.desktop.projects.core.IMediaContainer;
import org.eclipse.vtp.desktop.projects.core.IMediaFile;
import org.eclipse.vtp.desktop.projects.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaResource;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.MediaFolder;
import org.eclipse.vtp.desktop.projects.core.internals.MediaTypeManager;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;

public class MediaFilesFolder
extends VoiceResource
implements IMediaFilesFolder {
    IFolder folder;
    IVoiceToolsResource parent;

    public MediaFilesFolder(IVoiceToolsResource parent, IFolder folder) {
        this.parent = parent;
        this.folder = folder;
        this.activateEvents();
    }

    public String getName() {
        return this.folder.getName();
    }

    public List listMediaResources() throws CoreException {
        ArrayList<IMediaResource> ret = new ArrayList<IMediaResource>();
        IResource[] res = this.folder.members();
        int i = 0;
        while (i < res.length) {
            if (!res[i].getName().startsWith(".")) {
                IFolder f;
                if (res[i] instanceof IFolder) {
                    f = (IFolder)res[i];
                    ret.add(new MediaFolder((IMediaContainer)this, f));
                } else {
                    f = (IFile)res[i];
                    IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, (IFile)f);
                    if (mf != null) {
                        ret.add(mf);
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public IMediaFolder getMediaFolder(String name) {
        IFolder f = this.folder.getFolder(name);
        return new MediaFolder((IMediaContainer)this, f);
    }

    public IMediaFile getMediaFile(String name) {
        IFile f = this.folder.getFile(name);
        IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, f);
        return mf;
    }

    public IVoiceToolsResource getParent() {
        return this.parent;
    }

    public IMediaFile create(String name) throws CoreException {
        return this.create(name, new ByteArrayInputStream(new byte[0]), null);
    }

    public IMediaFile create(String name, InputStream source, IProgressMonitor monitor) throws CoreException {
        IFile file = this.folder.getFile(name);
        IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, file);
        if (mf != null) {
            file.create(source, false, null);
        }
        return mf;
    }

    public IMediaFolder makeDirectory(String name) throws CoreException {
        IFolder f = this.folder.getFolder(name);
        f.create(false, true, null);
        return new MediaFolder((IMediaContainer)this, f);
    }

    public String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public IFile getAlternateTextFile() {
        return this.folder.getFile(".audioFiles");
    }
}

