/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IMediaContainer;
import org.eclipse.vtp.desktop.projects.core.IMediaFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaResource;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;

public abstract class MediaResource
extends VoiceResource
implements IMediaResource {
    IResource resource;
    IMediaContainer container;

    public MediaResource(IMediaContainer container, IResource resource) {
        this.resource = resource;
        this.container = container;
        this.activateEvents();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public IMediaContainer getParentMediaContainer() {
        return this.container;
    }

    public IVoiceToolsResource getParent() {
        return this.container;
    }

    public String getName() {
        return this.resource.getName();
    }

    protected String getObjectId() {
        return this.resource.getFullPath().toPortableString();
    }

    public void delete() throws CoreException {
        this.resource.delete(false, null);
        this.container.refresh();
    }

    public String getMediaPath() {
        String path = "";
        IVoiceToolsResource obj = this.getParent();
        if (obj instanceof IMediaFolder) {
            path = ((IMediaFolder)obj).getMediaPath();
        }
        path = String.valueOf(path) + "/" + this.getName();
        return path;
    }
}

