/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.DefaultBrandManager;
import org.eclipse.vtp.desktop.projects.core.ApplicationLanguage;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.projects.core.IDatabaseSet;
import org.eclipse.vtp.desktop.projects.core.IDependencySet;
import org.eclipse.vtp.desktop.projects.core.IMediaProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.IWebServiceSet;
import org.eclipse.vtp.desktop.projects.core.MediaProjectManager;
import org.eclipse.vtp.desktop.projects.core.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.projects.core.internals.ApplicationProject;
import org.eclipse.vtp.desktop.projects.core.internals.BusinessObjectSet;
import org.eclipse.vtp.desktop.projects.core.internals.DatabaseSet;
import org.eclipse.vtp.desktop.projects.core.internals.DependencySet;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceToolsProject;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceSet;
import org.eclipse.vtp.desktop.projects.core.internals.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VoiceToolsDesignProject
extends VoiceToolsProject
implements IVoiceToolsDesignProject {
    private static final String DEFAULT_FRAMEWORK_VERSION = "2.1";
    private String designProjectId;
    private String designProjectName;
    private String applicationFrameworkVersion;
    private Map supportedLanguages = new HashMap();
    private DefaultBrandManager brandManager = null;
    private WebServiceSet webServiceSet = null;

    public VoiceToolsDesignProject(IProject project) {
        super(project);
        this.loadBuildPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuildPath() {
        this.supportedLanguages.clear();
        VoiceToolsDesignProject voiceToolsDesignProject = this;
        synchronized (voiceToolsDesignProject) {
            block23: {
                boolean brandManagerWasNull = false;
                try {
                    ApplicationLanguage al;
                    String mediaProjectTypeEP = "org.eclipse.vtp.desktop.projects.core.mediaProjects";
                    HashMap<String, String> mediaProjectNatureIdsByInteractionType = new HashMap<String, String>();
                    IConfigurationElement[] mediaProjectTypeElements = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaProjectTypeEP);
                    int i = 0;
                    while (i < mediaProjectTypeElements.length) {
                        mediaProjectNatureIdsByInteractionType.put(mediaProjectTypeElements[i].getAttribute("interaction-type"), mediaProjectTypeElements[i].getAttribute("nature-id"));
                        ++i;
                    }
                    IFile buildPath = this.project.getFile(".buildPath");
                    DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = buildFactory.newDocumentBuilder();
                    Document doc = builder.parse(buildPath.getContents());
                    Element root = doc.getDocumentElement();
                    this.designProjectId = root.getAttribute("id");
                    this.designProjectName = root.getAttribute("name");
                    this.applicationFrameworkVersion = root.getAttribute("framework-version");
                    if (this.applicationFrameworkVersion == null || this.applicationFrameworkVersion.length() == 0) {
                        this.applicationFrameworkVersion = DEFAULT_FRAMEWORK_VERSION;
                    }
                    if (this.brandManager == null) {
                        this.brandManager = new DefaultBrandManager();
                        brandManagerWasNull = true;
                    }
                    ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    NodeList nl = root.getElementsByTagName("language-support");
                    if (nl.getLength() < 1) {
                        throw new RuntimeException("language-support element missing in build path");
                    }
                    int ls = 0;
                    while (ls < nl.getLength()) {
                        Element personasElement = (Element)nl.item(ls);
                        String interactionType = personasElement.getAttribute("interaction-type");
                        if (interactionType.equals("")) {
                            interactionType = "org.eclipse.vtp.framework.interactions.voice.interaction";
                        }
                        System.out.println("language-support for: " + interactionType);
                        ArrayList<ApplicationLanguage> interactionSupportedLanguages = (ArrayList<ApplicationLanguage>)this.supportedLanguages.get(interactionType);
                        if (interactionSupportedLanguages == null) {
                            interactionSupportedLanguages = new ArrayList<ApplicationLanguage>();
                            this.supportedLanguages.put(interactionType, interactionSupportedLanguages);
                        }
                        NodeList nl2 = personasElement.getElementsByTagName("language");
                        int i2 = 0;
                        while (i2 < nl2.getLength()) {
                            Element languageElement = (Element)nl2.item(i2);
                            String langName = languageElement.getAttribute("name");
                            String langProject = languageElement.getAttribute("project");
                            this.brandManager.addInteractionSupport(interactionType);
                            al = new ApplicationLanguage(langName, langProject);
                            interactionSupportedLanguages.add(al);
                            this.brandManager.addSupportedLanguage(interactionType, langName);
                            ++i2;
                        }
                        ++ls;
                    }
                    if (!brandManagerWasNull) break block23;
                    NodeList nl2 = root.getElementsByTagName("brands");
                    if (nl2.getLength() < 1) {
                        throw new RuntimeException("brands element missing in build path");
                    }
                    Element brandsElement = (Element)nl2.item(0);
                    nl = brandsElement.getChildNodes();
                    int i3 = 0;
                    while (i3 < nl.getLength()) {
                        if (nl.item(i3).getNodeType() == 1) {
                            Element brandElement = (Element)nl.item(i3);
                            Brand defaultBrand = new Brand(brandElement.getAttribute("name"));
                            System.out.println("loading brand: " + defaultBrand.getName());
                            for (String interactionType : this.supportedLanguages.keySet()) {
                                List interactionSupportedLanguages = (List)this.supportedLanguages.get(interactionType);
                                int l = 0;
                                while (l < interactionSupportedLanguages.size()) {
                                    al = (ApplicationLanguage)interactionSupportedLanguages.get(l);
                                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                    int p = 0;
                                    while (p < projects.length) {
                                        try {
                                            IMediaProject mp;
                                            if (projects[p].hasNature((String)mediaProjectNatureIdsByInteractionType.get(interactionType)) && (mp = MediaProjectManager.getInstance().convertToMediaProject(projects[p])).getMediaProjectId().equals(al.getProjectId())) {
                                                defaultBrand.registerMediaProvider(interactionType, al.getName(), mp.getMediaProvider());
                                            }
                                        }
                                        catch (CoreException e) {
                                            e.printStackTrace();
                                        }
                                        ++p;
                                    }
                                    ++l;
                                }
                            }
                            this.brandManager.setDefaultBrand(defaultBrand);
                            NodeList subBrandList = brandElement.getChildNodes();
                            this.addBrands(mediaProjectNatureIdsByInteractionType, defaultBrand, subBrandList);
                        }
                        ++i3;
                    }
                }
                catch (FactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getDesignProjectId() {
        return this.designProjectId;
    }

    public String getDesignProjectName() {
        return this.designProjectName;
    }

    public String getApplicationFrameworkVersion() {
        return this.applicationFrameworkVersion;
    }

    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadBuildPath();
            this.refresh();
        }
        super.processObjectEvent(event);
    }

    public List getSupportedLanguages(String interactionType) {
        return Collections.unmodifiableList((List)this.supportedLanguages.get(interactionType));
    }

    public void setSupportedLanguages(Map languageMap) {
        for (String interactionType : languageMap.keySet()) {
            List languages = (List)languageMap.get(interactionType);
            this.supportedLanguages.put(interactionType, languages);
        }
        this.storeConfig();
        DesktopCorePlugin.removeFromCache(this);
    }

    public void storeConfig() {
        try {
            System.out.println("in storeConfig()");
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = document.createElement("application-properties");
            document.appendChild(rootElement);
            rootElement.setAttribute("id", this.designProjectId);
            rootElement.setAttribute("name", this.designProjectName);
            for (String interactionType : this.supportedLanguages.keySet()) {
                System.out.println("saving language support for: " + interactionType);
                Element languageSupportElement = document.createElement("language-support");
                rootElement.appendChild(languageSupportElement);
                languageSupportElement.setAttribute("interaction-type", interactionType);
                List interactionSupportedLanguages = (List)this.supportedLanguages.get(interactionType);
                System.out.println("# of languages: " + interactionSupportedLanguages.size());
                int i = 0;
                while (i < interactionSupportedLanguages.size()) {
                    ApplicationLanguage al = (ApplicationLanguage)interactionSupportedLanguages.get(i);
                    Element languageElement = document.createElement("language");
                    languageSupportElement.appendChild(languageElement);
                    languageElement.setAttribute("name", al.getName());
                    languageElement.setAttribute("project", al.getProjectId());
                    ++i;
                }
            }
            Element sharedLibrariesElement = document.createElement("shared-libraries");
            rootElement.appendChild(sharedLibrariesElement);
            Element brandsElement = document.createElement("brands");
            rootElement.appendChild(brandsElement);
            Brand defaultBrand = this.brandManager.getDefaultBrand();
            this.writeBrand(brandsElement, defaultBrand);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            trans.transform(source, result);
            IFile buildPath = this.project.getFile(".buildPath");
            buildPath.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        DesktopCorePlugin.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    public void writeBrand(Element parentElement, Brand brand) {
        System.out.println("writing brand: " + brand.getName());
        Element brandElement = parentElement.getOwnerDocument().createElement("brand");
        parentElement.appendChild(brandElement);
        brandElement.setAttribute("name", brand.getName());
        List children = brand.getChildBrands();
        int i = 0;
        while (i < children.size()) {
            this.writeBrand(brandElement, (Brand)children.get(i));
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationProject)) {
            return false;
        }
        return ((ApplicationProject)obj).project.equals((Object)this.project);
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    private void addBrands(Map natureMap, Brand parent, NodeList brandList) {
        int i = 0;
        while (i < brandList.getLength()) {
            if (brandList.item(i).getNodeType() == 1) {
                Element brandElement = (Element)brandList.item(i);
                Brand brand = new Brand(brandElement.getAttribute("name"));
                for (String interactionType : this.supportedLanguages.keySet()) {
                    List interactionSupportedLanguages = (List)this.supportedLanguages.get(interactionType);
                    int l = 0;
                    while (l < interactionSupportedLanguages.size()) {
                        ApplicationLanguage al = (ApplicationLanguage)interactionSupportedLanguages.get(l);
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int p = 0;
                        while (p < projects.length) {
                            try {
                                IMediaProject mp;
                                if (projects[p].hasNature((String)natureMap.get(interactionType)) && (mp = MediaProjectManager.getInstance().convertToMediaProject(projects[p])).getMediaProjectId().equals(al.getProjectId())) {
                                    brand.registerMediaProvider(interactionType, al.getName(), mp.getMediaProvider());
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++p;
                        }
                        ++l;
                    }
                }
                brand.setParent(parent);
                this.addBrands(natureMap, brand, brandElement.getChildNodes());
            }
            ++i;
        }
    }

    public IBusinessObjectSet getBusinessObjectSet() {
        IFolder f = this.project.getFolder("Business Objects");
        if (!f.exists()) {
            throw new RuntimeException("Missing business objects folder");
        }
        return new BusinessObjectSet(this, f);
    }

    public IDatabaseSet getDatabaseSet() {
        IFolder f = this.project.getFolder("Databases");
        if (!f.exists()) {
            throw new RuntimeException("Missing databases folder");
        }
        return new DatabaseSet(this, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWebServiceSet getWebServiceSet() {
        VoiceToolsDesignProject voiceToolsDesignProject = this;
        synchronized (voiceToolsDesignProject) {
            if (this.webServiceSet == null) {
                IFolder f = this.project.getFolder("Web Services");
                if (!f.exists()) {
                    try {
                        f.create(true, true, null);
                    }
                    catch (CoreException coreException) {
                        throw new RuntimeException("Missing web services folder");
                    }
                }
                this.webServiceSet = new WebServiceSet(this, f);
            }
            return this.webServiceSet;
        }
    }

    public IDependencySet getDependencySet() {
        IFolder f = this.project.getFolder("Dependencies");
        if (!f.exists()) {
            try {
                f.create(true, true, null);
            }
            catch (CoreException coreException) {
                throw new RuntimeException("Missing dependencies folder");
            }
        }
        return new DependencySet(this, f);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            return this.project;
        }
        return super.getAdapter(adapter);
    }

    public List getSupportedInteractions() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.supportedLanguages.keySet());
        return ret;
    }
}

