/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.IWebServiceOperation;
import org.eclipse.vtp.desktop.projects.core.IWebServicePort;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceConstants;
import org.eclipse.vtp.desktop.projects.core.internals.WebServicePort;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceTypeSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServiceOperation
extends VoiceResource
implements IWebServiceOperation,
WebServiceConstants {
    private final WebServicePort webServicePort;
    private final String name;
    private final Map inputs;
    private final Map faults;
    private final FieldType output;

    public WebServiceOperation(WebServicePort webServicePort, WebServiceTypeSet types, Class portClass, Map messagePartIndex, Element wsdlOperationElement) {
        this.webServicePort = webServicePort;
        String name = wsdlOperationElement.getAttribute("name");
        Method operationMethod = WebServiceOperation.getOperationMethod(portClass, name);
        if (operationMethod == null) {
            name = new StringBuffer().append(Character.toLowerCase(name.charAt(0))).append(name.substring(1)).toString();
            operationMethod = WebServiceOperation.getOperationMethod(portClass, name);
        }
        if (operationMethod == null) {
            this.name = null;
            this.inputs = Collections.EMPTY_MAP;
            this.faults = Collections.EMPTY_MAP;
            this.output = null;
        } else {
            this.name = name;
            Class<?>[] parameterTypes = operationMethod.getParameterTypes();
            LinkedHashMap<String, FieldType> inputs = new LinkedHashMap<String, FieldType>(parameterTypes.length);
            NodeList inputNodeList = wsdlOperationElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "input");
            if (inputNodeList.getLength() == 1) {
                String inputMsgName = ((Element)inputNodeList.item(0)).getAttribute("message");
                String[] partNames = (String[])messagePartIndex.get(inputMsgName.substring(inputMsgName.indexOf(58) + 1));
                int i = 0;
                while (i < parameterTypes.length) {
                    if (partNames.length <= i) {
                        inputs.put(String.valueOf(partNames[partNames.length - 1]) + "_" + i, types.loadFieldType(parameterTypes[i]));
                    } else {
                        inputs.put(partNames[i], types.loadFieldType(parameterTypes[i]));
                    }
                    ++i;
                }
            }
            this.inputs = Collections.unmodifiableMap(inputs);
            Class<?>[] excpetionTypes = operationMethod.getExceptionTypes();
            LinkedHashMap<String, FieldType> faults = new LinkedHashMap<String, FieldType>(excpetionTypes.length);
            NodeList faultNodeList = wsdlOperationElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "fault");
            if (faultNodeList.getLength() > 0) {
                int j = 0;
                int i = 0;
                while (i < excpetionTypes.length) {
                    if (!RemoteException.class.equals(excpetionTypes[i])) {
                        faults.put(((Element)faultNodeList.item(j)).getAttribute("name"), types.loadFieldType(excpetionTypes[i]));
                        ++j;
                    }
                    ++i;
                }
            }
            this.faults = Collections.unmodifiableMap(faults);
            this.output = types.loadFieldType(operationMethod.getReturnType());
            this.printTree(types, this.output.getTypeName(), 0);
        }
    }

    private void printTree(WebServiceTypeSet types, String typeName, int depth) {
        String fullName = "org.eclipse.vtp.framework.synthetic_ws.ReplPartWS." + typeName;
        IBusinessObject businessObject = types.getBusinessObject(fullName);
        if (businessObject == null) {
            return;
        }
        for (IBusinessObjectField field : businessObject.getFields()) {
            int j = 0;
            while (j < depth) {
                System.err.print('\t');
                ++j;
            }
            System.err.print(field.getDataType().getTypeName());
            System.err.print(' ');
            System.err.println(field.getName());
            this.printTree(types, field.getDataType().getTypeName(), depth + 1);
        }
    }

    private static Method getOperationMethod(Class portClass, String methodName) {
        Method[] methods = portClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers()) && !Modifier.isStatic(methods[i].getModifiers()) && methods[i].getName().equals(methodName)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    protected String getObjectId() {
        return String.valueOf(this.webServicePort.getObjectId()) + "#" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public IVoiceToolsResource getParent() {
        return this.webServicePort;
    }

    public String[] getInputNames() {
        return this.inputs.keySet().toArray(new String[this.inputs.size()]);
    }

    public FieldType getInput(String inputName) {
        return (FieldType)this.inputs.get(inputName);
    }

    public String[] getFaultNames() {
        return this.faults.keySet().toArray(new String[this.faults.size()]);
    }

    public FieldType getFault(String faultName) {
        return (FieldType)this.faults.get(faultName);
    }

    public FieldType getOutput() {
        return this.output;
    }

    public IWebServicePort getWebServicePort() {
        return this.webServicePort;
    }
}

