/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.IWebService;
import org.eclipse.vtp.desktop.projects.core.IWebServiceOperation;
import org.eclipse.vtp.desktop.projects.core.IWebServicePort;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.WebService;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceConstants;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceOperation;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceTypeSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServicePort
extends VoiceResource
implements IWebServicePort,
WebServiceConstants {
    private final WebService webService;
    private final String name;
    private final String serviceName;
    private List operations = Collections.EMPTY_LIST;
    private Map operationIndex = Collections.EMPTY_MAP;

    public WebServicePort(WebService webService, WebServiceTypeSet types, ClassLoader classLoader, Map messagePartIndex, Map portServiceIndex, Element wsdlPortTypeElement) throws ClassNotFoundException {
        this.webService = webService;
        String name = wsdlPortTypeElement.getAttribute("name");
        Class<?> portClass = null;
        try {
            portClass = classLoader.loadClass(String.valueOf(webService.getGeneratedPackageName()) + "." + name);
        }
        catch (ClassNotFoundException e1) {
            try {
                name = new StringBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
                portClass = classLoader.loadClass(String.valueOf(webService.getGeneratedPackageName()) + "." + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    name = String.valueOf(wsdlPortTypeElement.getAttribute("name")) + "_PortType";
                    portClass = classLoader.loadClass(String.valueOf(webService.getGeneratedPackageName()) + "." + name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        name = new StringBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
                        portClass = classLoader.loadClass(String.valueOf(webService.getGeneratedPackageName()) + "." + name);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        throw e1;
                    }
                }
            }
        }
        this.name = name;
        this.serviceName = (String)portServiceIndex.get(wsdlPortTypeElement.getAttribute("name"));
        LinkedList<WebServiceOperation> operations = new LinkedList<WebServiceOperation>();
        HashMap<String, WebServiceOperation> operationIndex = new HashMap<String, WebServiceOperation>();
        NodeList operationElementList = wsdlPortTypeElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < operationElementList.getLength()) {
            WebServiceOperation operation = new WebServiceOperation(this, types, portClass, messagePartIndex, (Element)operationElementList.item(i));
            operations.add(operation);
            operationIndex.put(operation.getName(), operation);
            ++i;
        }
        this.operations = Collections.unmodifiableList(operations);
        this.operationIndex = Collections.unmodifiableMap(operationIndex);
    }

    protected String getObjectId() {
        return String.valueOf(this.webService.getObjectId()) + "#" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public IVoiceToolsResource getParent() {
        return this.webService;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List getWebServiceOperations() {
        return this.operations;
    }

    public IWebServiceOperation getWebServiceOperation(String name) {
        return (IWebServiceOperation)this.operationIndex.get(name);
    }

    public IWebService getWebService() {
        return this.webService;
    }
}

