/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.IWebService;
import org.eclipse.vtp.desktop.projects.core.IWebServiceSet;
import org.eclipse.vtp.desktop.projects.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.internals.WebService;

public class WebServiceSet
extends VoiceResource
implements IWebServiceSet {
    private final VoiceToolsDesignProject project;
    private final IFolder folder;
    private List webServices = null;
    private Map webServiceIndex = null;

    public WebServiceSet(VoiceToolsDesignProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
    }

    private List loadExistingWebServices() {
        if (this.webServices == null) {
            this.webServices = new LinkedList();
            this.webServiceIndex = new HashMap();
            IResource[] members = null;
            try {
                members = this.folder.members();
            }
            catch (CoreException coreException) {
                members = null;
            }
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    IFile wsdlFile;
                    if (members[i].getType() == 2 && (wsdlFile = ((IFolder)members[i]).getFile(".wsdl")).exists()) {
                        try {
                            WebService webService = new WebService(this, (IFolder)members[i], wsdlFile);
                            this.webServices.add(webService);
                            this.webServiceIndex.put(webService.getName(), webService);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++i;
                }
            }
        }
        return this.webServices;
    }

    public String getName() {
        return this.folder.getName();
    }

    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public IVoiceToolsResource getParent() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWebServices() {
        WebServiceSet webServiceSet = this;
        synchronized (webServiceSet) {
            return new ArrayList(this.loadExistingWebServices());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWebService getWebService(String name) {
        WebServiceSet webServiceSet = this;
        synchronized (webServiceSet) {
            this.loadExistingWebServices();
            return (IWebService)this.webServiceIndex.get(name);
        }
    }

    public IWebService createWebService(String name, URL wsdlFile) throws CoreException {
        WebServiceSet webServiceSet = this;
        synchronized (webServiceSet) {
            WebService webService;
            block32: {
                IFolder webServiceFolder = this.folder.getFolder(name);
                if (webServiceFolder.exists()) {
                    throw new IllegalArgumentException("A Web Service with that name already exists: " + name);
                }
                IFile localWsdlFile = webServiceFolder.getFile(".wsdl");
                InputStream input = null;
                try {
                    input = wsdlFile.openStream();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, DesktopCorePlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                }
                WebService service = null;
                try {
                    webServiceFolder.create(true, true, null);
                    if (localWsdlFile.exists()) {
                        localWsdlFile.setContents(input, true, false, null);
                    } else {
                        localWsdlFile.create(input, true, null);
                    }
                    service = new WebService(this, webServiceFolder, localWsdlFile);
                    service.processWebServiceDescriptor();
                    this.loadExistingWebServices().add(service);
                    this.webServiceIndex.put(service.getName(), service);
                    webService = service;
                }
                catch (Throwable throwable) {
                    block34: {
                        try {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {
                                if (service == null && webServiceFolder.exists()) {
                                    webServiceFolder.delete(true, null);
                                } else {
                                    this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                                    this.refresh();
                                }
                                break block34;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (service == null && webServiceFolder.exists()) {
                                webServiceFolder.delete(true, null);
                            } else {
                                this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                                this.refresh();
                            }
                            throw throwable2;
                        }
                        if (service == null && webServiceFolder.exists()) {
                            webServiceFolder.delete(true, null);
                        } else {
                            this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                            this.refresh();
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        if (service == null && webServiceFolder.exists()) {
                            webServiceFolder.delete(true, null);
                        } else {
                            this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                            this.refresh();
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (service == null && webServiceFolder.exists()) {
                        webServiceFolder.delete(true, null);
                    } else {
                        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                        this.refresh();
                    }
                    throw throwable;
                }
                if (service == null && webServiceFolder.exists()) {
                    webServiceFolder.delete(true, null);
                } else {
                    this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
                    this.refresh();
                }
            }
            return webService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWebService(IWebService webService) throws CoreException {
        if (webService == null) {
            return;
        }
        WebServiceSet webServiceSet = this;
        synchronized (webServiceSet) {
            Iterator i = this.loadExistingWebServices().iterator();
            while (i.hasNext()) {
                if (!((IWebService)i.next()).equals(webService)) continue;
                i.remove();
                this.webServiceIndex.remove(webService.getName());
                break;
            }
            IFolder webServiceFolder = this.folder.getFolder(webService.getName());
            if (webServiceFolder.exists()) {
                webServiceFolder.delete(true, null);
            }
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
    }
}

