/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceTypeField;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceTypeSet;

public class WebServiceType
extends VoiceResource
implements IBusinessObject {
    private final WebServiceTypeSet webServiceTypeSet;
    private final String id;
    private final List fields;

    public WebServiceType(WebServiceTypeSet webServiceTypeSet, Class objectType) {
        this.webServiceTypeSet = webServiceTypeSet;
        this.id = objectType.getName();
        LinkedList<WebServiceTypeField> fields = new LinkedList<WebServiceTypeField>();
        Method[] methods = objectType.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers()) && !Modifier.isStatic(methods[i].getModifiers()) && methods[i].getName().startsWith("get") && methods[i].getName().length() > 3 && methods[i].getParameterTypes().length <= 0) {
                fields.add(new WebServiceTypeField(methods[i].getName().substring(3), webServiceTypeSet.loadFieldType(methods[i].getReturnType())));
            }
            ++i;
        }
        this.fields = Collections.unmodifiableList(fields);
    }

    protected String getObjectId() {
        return String.valueOf(this.webServiceTypeSet.getObjectId()) + "#" + this.getName();
    }

    public String getName() {
        return this.getId().substring(this.getId().lastIndexOf(46) + 1);
    }

    public IVoiceToolsResource getParent() {
        return this.webServiceTypeSet;
    }

    public String getId() {
        return this.id;
    }

    public List getFields() {
        return this.fields;
    }

    public IBusinessObjectSet getBusinessObjectSet() {
        return this.webServiceTypeSet;
    }

    public IFile getUnderlyingFile() {
        return null;
    }

    public void delete() throws CoreException {
    }
}

