/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.internals;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.IWebService;
import org.eclipse.vtp.desktop.projects.core.IWebServiceTypeSet;
import org.eclipse.vtp.desktop.projects.core.internals.VoiceResource;
import org.eclipse.vtp.desktop.projects.core.internals.WebService;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceConstants;
import org.eclipse.vtp.desktop.projects.core.internals.WebServiceType;

public class WebServiceTypeSet
extends VoiceResource
implements IWebServiceTypeSet,
WebServiceConstants {
    private final WebService webService;
    private List objects = new LinkedList();
    private Map objectIndex = new HashMap();

    public WebServiceTypeSet(WebService webService) {
        this.webService = webService;
    }

    protected FieldType loadFieldType(Class objectType) {
        if (Boolean.class.equals((Object)objectType) || Boolean.TYPE.equals(objectType)) {
            return FieldType.BOOLEAN;
        }
        if (Boolean[].class.equals((Object)objectType) || boolean[].class.equals((Object)objectType)) {
            return FieldType.booleanArray();
        }
        if (BigDecimal.class.isAssignableFrom(objectType) || BigInteger.class.isAssignableFrom(objectType) || Float.class.equals((Object)objectType) || Float.TYPE.equals(objectType) || Double.class.equals((Object)objectType) || Double.TYPE.equals(objectType)) {
            return FieldType.DECIMAL;
        }
        if (BigDecimal[].class.isAssignableFrom(objectType) || BigInteger[].class.isAssignableFrom(objectType) || Float[].class.equals((Object)objectType) || float[].class.equals((Object)objectType) || Double[].class.equals((Object)objectType) || double[].class.equals((Object)objectType)) {
            return FieldType.decimalArray();
        }
        if (Number.class.isAssignableFrom(objectType) || Byte.TYPE.equals(objectType) || Short.TYPE.equals(objectType) || Character.class.equals((Object)objectType) || Character.TYPE.equals(objectType) || Integer.TYPE.equals(objectType) || Long.TYPE.equals(objectType)) {
            return FieldType.NUMBER;
        }
        if (Number[].class.isAssignableFrom(objectType) || byte[].class.equals((Object)objectType) || short[].class.equals((Object)objectType) || char[].class.equals((Object)objectType) || Character[].class.equals((Object)objectType) || int[].class.equals((Object)objectType) || long[].class.equals((Object)objectType)) {
            return FieldType.numberArray();
        }
        if (Date.class.isAssignableFrom(objectType) || Calendar.class.isAssignableFrom(objectType)) {
            return FieldType.DATETIME;
        }
        if (Date[].class.isAssignableFrom(objectType) || Calendar[].class.isAssignableFrom(objectType)) {
            return FieldType.dateTimeArray();
        }
        if (String.class.equals((Object)objectType)) {
            return FieldType.STRING;
        }
        if (String[].class.equals((Object)objectType)) {
            return FieldType.stringArray();
        }
        if (QName.class.equals((Object)objectType) || QName[].class.equals((Object)objectType)) {
            return FieldType.stringArray();
        }
        if (objectType.isArray()) {
            return FieldType.objectArray(this.findBusinessObjectFor(objectType.getComponentType()));
        }
        return FieldType.object(this.findBusinessObjectFor(objectType));
    }

    protected void finishedLoading() {
        this.objects = Collections.unmodifiableList(new ArrayList(this.objects));
        this.objectIndex = Collections.unmodifiableMap(new HashMap(this.objectIndex));
    }

    private IBusinessObject findBusinessObjectFor(Class objectType) {
        IBusinessObject object = (IBusinessObject)this.objectIndex.get(objectType.getName());
        if (object != null) {
            return object;
        }
        if (!objectType.getName().startsWith("org.apache.axis.types.") && !objectType.getName().startsWith(this.webService.getGeneratedPackageName())) {
            throw new IllegalArgumentException("Unknown object type: " + objectType.getName());
        }
        object = new WebServiceType(this, objectType);
        this.objects.add(object);
        this.objectIndex.put(object.getId(), object);
        return object;
    }

    protected String getObjectId() {
        return String.valueOf(this.webService.getObjectId()) + "#types";
    }

    public String getName() {
        return "Types";
    }

    public IVoiceToolsResource getParent() {
        return this.webService;
    }

    public IBusinessObject createBusinessObject(String name) {
        throw new UnsupportedOperationException();
    }

    public void deleteBusinessObject(IBusinessObject businessObject) {
        throw new UnsupportedOperationException();
    }

    public List getBusinessObjects() {
        return this.objects;
    }

    public IBusinessObject getBusinessObject(String name) {
        return (IBusinessObject)this.objectIndex.get(name);
    }

    public IWebService getWebService() {
        return this.webService;
    }
}

