/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.util.ApplicationConfigurationScreen;

public class ApplicationProjectConfigurationPropertyPage
extends PropertyPage {
    private ApplicationConfigurationScreen screen = new ApplicationConfigurationScreen();
    private IVoiceToolsDesignProject applicationProject = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(IAdaptable element) {
        super.setElement(element);
        try {
            if (element instanceof IVoiceToolsDesignProject) {
                this.applicationProject = (IVoiceToolsDesignProject)element;
            } else {
                if (!(element instanceof IProject)) throw new RuntimeException("Unsupported element type");
                IProject project = (IProject)element;
                if (DesktopCorePlugin.isApplicationFragmentProject(project)) {
                    this.applicationProject = DesktopCorePlugin.convertToApplicationFragment(project);
                } else {
                    if (!DesktopCorePlugin.isApplicationProject(project)) throw new RuntimeException("Unsupported element type");
                    this.applicationProject = DesktopCorePlugin.convertToApplication(project);
                }
            }
            this.screen.loadFrom(this.applicationProject);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        this.screen.createContents(comp);
        return comp;
    }

    protected void performDefaults() {
        this.screen.loadFrom(this.applicationProject);
        super.performDefaults();
    }

    public boolean performOk() {
        this.screen.saveTo(this.applicationProject);
        return true;
    }
}

