/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.InteractionType;
import org.eclipse.vtp.desktop.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.projects.core.ApplicationLanguage;
import org.eclipse.vtp.desktop.projects.core.IMediaProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.MediaProjectManager;
import org.eclipse.vtp.desktop.projects.core.dialogs.BrandDialog;
import org.eclipse.vtp.desktop.projects.core.dialogs.LanguageSupportDialog;

public class ApplicationConfigurationScreen {
    private final Map mediaProjectsByInteraction = new HashMap();
    private Map languageViewers = new HashMap();
    private TreeViewer brandViewer = null;
    private String mediaProjectTypeEP = "org.eclipse.vtp.desktop.projects.core.mediaProjects";
    private List interactionTypeIds = InteractionTypeManager.getInstance().getInteractionTypes();
    private Map mediaProjectNatureIdsByInteractionType = new HashMap();
    private final Map supportedLanguagesByInteractionType = new HashMap();
    private BrandInfo brands = new BrandInfo();

    public ApplicationConfigurationScreen() {
        IConfigurationElement[] mediaProjectTypeElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.mediaProjectTypeEP);
        int i = 0;
        while (i < mediaProjectTypeElements.length) {
            String interactionType = mediaProjectTypeElements[i].getAttribute("interaction-type");
            String natureId = mediaProjectTypeElements[i].getAttribute("nature-id");
            System.out.println("interaction-type: " + interactionType + " nature-id: " + natureId);
            this.mediaProjectNatureIdsByInteractionType.put(interactionType, natureId);
            ArrayList<IMediaProject> mediaProjects = new ArrayList<IMediaProject>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int p = 0;
            while (p < projects.length) {
                try {
                    if (projects[p].hasNature(natureId)) {
                        IMediaProject pp = MediaProjectManager.getInstance().convertToMediaProject(projects[p]);
                        mediaProjects.add(pp);
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                ++p;
            }
            this.mediaProjectsByInteraction.put(interactionType, mediaProjects);
            ++i;
        }
    }

    public void loadFrom(IVoiceToolsDesignProject project) {
        String interactionType;
        int i;
        List supportedInteractionTypes;
        this.supportedLanguagesByInteractionType.clear();
        if (project == null) {
            this.brands = new BrandInfo();
        } else {
            supportedInteractionTypes = project.getSupportedInteractions();
            i = 0;
            while (i < supportedInteractionTypes.size()) {
                interactionType = (String)supportedInteractionTypes.get(i);
                List supportedLanguages = project.getSupportedLanguages(interactionType);
                ArrayList targetList = new ArrayList();
                targetList.addAll(supportedLanguages);
                this.supportedLanguagesByInteractionType.put(interactionType, targetList);
                ++i;
            }
            this.brands = this.loadBrand(null, project.getBrandManager().getDefaultBrand());
        }
        supportedInteractionTypes = project.getSupportedInteractions();
        i = 0;
        while (i < supportedInteractionTypes.size()) {
            interactionType = (String)supportedInteractionTypes.get(i);
            if (this.languageViewers.get(interactionType) != null) {
                ((TableViewer)this.languageViewers.get(interactionType)).refresh();
            }
            ++i;
        }
        if (this.brandViewer != null) {
            this.brandViewer.refresh();
        }
    }

    private BrandInfo loadBrand(BrandInfo parentBrand, Brand childBrand) {
        BrandInfo info = new BrandInfo();
        info.name = childBrand.getName();
        info.parent = parentBrand;
        Iterator i = childBrand.getChildBrands().iterator();
        while (i.hasNext()) {
            info.children.add(this.loadBrand(info, (Brand)i.next()));
        }
        return info;
    }

    public void saveTo(IVoiceToolsDesignProject project) {
        if (project == null) {
            return;
        }
        this.saveBrand(project.getBrandManager().getDefaultBrand(), this.brands);
        project.setSupportedLanguages(this.supportedLanguagesByInteractionType);
    }

    private void saveBrand(Brand brand, BrandInfo brandInfo) {
        if (!brand.getName().equals(brandInfo.name)) {
            brand.setName(brandInfo.name);
        }
        HashMap<String, Brand> childBrandsByName = new HashMap<String, Brand>();
        for (Brand childBrand : brand.getChildBrands()) {
            childBrandsByName.put(childBrand.getName(), childBrand);
        }
        for (BrandInfo childBrandInfo : brandInfo.children) {
            Brand childBrand = (Brand)childBrandsByName.remove(childBrandInfo.name);
            if (childBrand == null) {
                childBrand = new Brand(childBrandInfo.name);
                childBrand.setParent(brand);
            }
            this.saveBrand(childBrand, childBrandInfo);
        }
        Iterator<Object> i = childBrandsByName.values().iterator();
        while (i.hasNext()) {
            ((Brand)i.next()).delete();
        }
    }

    public Control createContents(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sf = toolkit.createScrolledForm(parent);
        Composite comp = sf.getForm().getBody();
        comp.setLayout((Layout)new GridLayout());
        comp.setBackground(parent.getBackground());
        int i = 0;
        while (i < this.interactionTypeIds.size()) {
            final InteractionType interactionType = (InteractionType)this.interactionTypeIds.get(i);
            Section interactionSection = toolkit.createSection(comp, 256);
            GridData gridData = new GridData(770);
            interactionSection.setLayoutData((Object)gridData);
            interactionSection.setText(interactionType.getName());
            Composite langComp = new Composite(comp, 0);
            langComp.setBackground(comp.getBackground());
            langComp.setLayout((Layout)new GridLayout(2, false));
            langComp.setLayoutData((Object)new GridData(768));
            Table table = new Table(langComp, 8456708);
            TableColumn nameColumn = new TableColumn(table, 0);
            nameColumn.setText("Name");
            nameColumn.setWidth(120);
            TableColumn projectColumn = new TableColumn(table, 0);
            projectColumn.setText("Media Project");
            projectColumn.setWidth(200);
            table.setHeaderVisible(true);
            gridData = new GridData(1808);
            gridData.verticalAlignment = 128;
            gridData.verticalSpan = 3;
            gridData.heightHint = 110;
            table.setLayoutData((Object)gridData);
            final TableViewer languageViewer = new TableViewer(table);
            languageViewer.setContentProvider((IContentProvider)new LanguageContentProvider(interactionType.getId()));
            languageViewer.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider(interactionType.getId()));
            languageViewer.setInput((Object)this);
            this.languageViewers.put(interactionType.getId(), languageViewer);
            Composite buttonComp = new Composite(langComp, 0);
            buttonComp.setBackground(langComp.getBackground());
            buttonComp.setLayoutData((Object)new GridData());
            buttonComp.setLayout((Layout)new GridLayout(1, false));
            Button addLangButton = new Button(buttonComp, 8);
            addLangButton.setText("Add Language");
            addLangButton.setLayoutData((Object)new GridData(768));
            addLangButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    LanguageSupportDialog lsd = new LanguageSupportDialog(workbenchShell);
                    lsd.setMediaProjects((List)ApplicationConfigurationScreen.this.mediaProjectsByInteraction.get(interactionType.getId()));
                    if (lsd.open() == 0) {
                        ArrayList<ApplicationLanguage> supportedLanguages = (ArrayList<ApplicationLanguage>)ApplicationConfigurationScreen.this.supportedLanguagesByInteractionType.get(interactionType.getId());
                        if (supportedLanguages == null) {
                            supportedLanguages = new ArrayList<ApplicationLanguage>();
                            ApplicationConfigurationScreen.this.supportedLanguagesByInteractionType.put(interactionType.getId(), supportedLanguages);
                        }
                        supportedLanguages.add(lsd.getLangauge());
                        languageViewer.refresh();
                    }
                }
            });
            final Button editLangButton = new Button(buttonComp, 8);
            editLangButton.setEnabled(false);
            editLangButton.setText("Edit Language");
            editLangButton.setLayoutData((Object)new GridData(768));
            editLangButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    LanguageSupportDialog lsd = new LanguageSupportDialog(workbenchShell);
                    lsd.setMediaProjects((List)ApplicationConfigurationScreen.this.mediaProjectsByInteraction.get(interactionType.getId()));
                    lsd.setLanguage((ApplicationLanguage)((IStructuredSelection)languageViewer.getSelection()).getFirstElement());
                    if (lsd.open() == 0) {
                        languageViewer.refresh();
                    }
                }
            });
            final Button removeLangButton = new Button(buttonComp, 8);
            removeLangButton.setEnabled(false);
            removeLangButton.setText("Remove Language");
            removeLangButton.setLayoutData((Object)new GridData(768));
            removeLangButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    List supportedLanguages = (List)ApplicationConfigurationScreen.this.supportedLanguagesByInteractionType.get(interactionType.getId());
                    supportedLanguages.remove((ApplicationLanguage)((IStructuredSelection)languageViewer.getSelection()).getFirstElement());
                    languageViewer.refresh();
                }
            });
            languageViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    editLangButton.setEnabled(!event.getSelection().isEmpty());
                    removeLangButton.setEnabled(!event.getSelection().isEmpty());
                }
            });
            ++i;
        }
        Section brandSection = toolkit.createSection(comp, 256);
        GridData gridData = new GridData(768);
        brandSection.setLayoutData((Object)gridData);
        brandSection.setText("Brands");
        this.brandViewer = new TreeViewer(comp, 67588);
        this.brandViewer.setContentProvider((IContentProvider)new BrandContentProvider());
        this.brandViewer.setLabelProvider((IBaseLabelProvider)new BrandLabelProvider());
        this.brandViewer.setInput((Object)this);
        GridData gridData2 = new GridData(768);
        gridData2.minimumHeight = 125;
        gridData2.heightHint = 125;
        this.brandViewer.getControl().setLayoutData((Object)gridData2);
        this.hookContextMenu();
        return comp;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationConfigurationScreen.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.brandViewer.getControl());
        this.brandViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection sel = (IStructuredSelection)this.brandViewer.getSelection();
        if (!sel.isEmpty()) {
            final BrandInfo brand = (BrandInfo)sel.getFirstElement();
            manager.add((IAction)new Action("Add Brand"){

                public void run() {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    BrandDialog bd = new BrandDialog(workbenchShell);
                    if (bd.open() == 0) {
                        BrandInfo nbrand = new BrandInfo();
                        nbrand.name = bd.getBrandName();
                        nbrand.parent = brand;
                        brand.children.add(nbrand);
                        System.out.println("adding brand: " + nbrand);
                        System.out.println(nbrand.name);
                        ApplicationConfigurationScreen.this.brandViewer.refresh();
                    }
                }
            });
            if (!this.brands.equals(brand)) {
                manager.add((IAction)new Action("Remove Brand"){

                    public void run() {
                        brand.parent.children.remove(brand);
                        ApplicationConfigurationScreen.this.brandViewer.refresh();
                    }
                });
            }
        }
    }

    private class BrandContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private BrandContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{ApplicationConfigurationScreen.this.brands};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return ((BrandInfo)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return ((BrandInfo)element).parent;
        }

        public boolean hasChildren(Object element) {
            return true;
        }
    }

    private static final class BrandInfo {
        String name = "Default";
        BrandInfo parent = null;
        final List children = new LinkedList();

        private BrandInfo() {
        }
    }

    private class BrandLabelProvider
    extends LabelProvider {
        private BrandLabelProvider() {
        }

        public String getText(Object element) {
            return ((BrandInfo)element).name;
        }
    }

    private class LanguageContentProvider
    implements IStructuredContentProvider {
        String interactionType = null;

        public LanguageContentProvider(String interactionType) {
            this.interactionType = interactionType;
        }

        public Object[] getElements(Object inputElement) {
            if (ApplicationConfigurationScreen.this.supportedLanguagesByInteractionType.get(this.interactionType) == null) {
                return new Object[0];
            }
            return ((List)ApplicationConfigurationScreen.this.supportedLanguagesByInteractionType.get(this.interactionType)).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LanguageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        String interactionType = null;

        public LanguageLabelProvider(String interactionType) {
            this.interactionType = interactionType;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            System.out.println("getting columntext for: column=" + columnIndex + " interaction-type=" + this.interactionType + " object=" + element);
            ApplicationLanguage al = (ApplicationLanguage)element;
            if (columnIndex == 0) {
                return al.getName();
            }
            List mediaProjects = (List)ApplicationConfigurationScreen.this.mediaProjectsByInteraction.get(this.interactionType);
            int i = 0;
            while (i < mediaProjects.size()) {
                try {
                    IMediaProject mp = (IMediaProject)mediaProjects.get(i);
                    if (mp.getMediaProjectId().equals(al.getProjectId())) {
                        return mp.getName();
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return "Missing Project: " + al.getProjectId();
        }
    }
}

