/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragmentProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.util.ApplicationConfigurationScreen;

public class CreateApplicationFragmentProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    ApplicationPage applicationPage = new ApplicationPage();
    BuildPathPage buildPathPage = new BuildPathPage();
    IConfigurationElement configElement = null;

    public void addPages() {
        this.addPage((IWizardPage)this.applicationPage);
        this.addPage((IWizardPage)this.buildPathPage);
    }

    public boolean performFinish() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.applicationPage.getApplicationName());
        try {
            newProject.create(null);
            newProject.open(null);
            IProjectDescription desc = newProject.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.vtp.desktop.projects.core.VoiceApplicationFragmentNature"});
            newProject.setDescription(desc, null);
            DesktopCorePlugin.initializeApplicationFragmentStructure(newProject, "", this.applicationPage.getApplicationName());
            IApplicationFragmentProject ap = DesktopCorePlugin.convertToApplicationFragment(newProject);
            this.buildPathPage.configureBuildPath(ap);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "Create Application", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setBackground(parent.getDisplay().getSystemColor(1));
            this.setControl((Control)comp);
            Label hostLabel = new Label(comp, 0);
            hostLabel.setBackground(comp.getBackground());
            hostLabel.setText("Application Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(comp, 2052);
            this.nameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.nameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (ApplicationPage.this.nameField.getText().length() == 0) {
                        ApplicationPage.this.setPageComplete(false);
                    } else {
                        IProject[] existingProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < existingProjects.length) {
                            if (ApplicationPage.this.nameField.getText().equalsIgnoreCase(existingProjects[i].getName())) {
                                ApplicationPage.this.setPageComplete(false);
                                ApplicationPage.this.setErrorMessage("Another project already exists with that name.");
                                return;
                            }
                            ++i;
                        }
                        ApplicationPage.this.setPageComplete(true);
                        ApplicationPage.this.setErrorMessage(null);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            comp.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }

    public class BuildPathPage
    extends WizardPage {
        ApplicationConfigurationScreen screen;

        public BuildPathPage() {
            super("ConfigureBuildPathPage", "Build Path", null);
            this.screen = new ApplicationConfigurationScreen();
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            this.setControl(this.screen.createContents(parent));
        }

        void configureBuildPath(IVoiceToolsDesignProject project) {
            this.screen.saveTo(project);
        }
    }
}

