/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectSet;

public class CreateBusinessObjectWizard
extends Wizard {
    private IBusinessObjectSet objectSet = null;
    private BusinessObjectWizardPage bwp = null;

    public CreateBusinessObjectWizard(IBusinessObjectSet objectSet) {
        this.objectSet = objectSet;
        this.bwp = new BusinessObjectWizardPage();
        this.addPage((IWizardPage)this.bwp);
    }

    public boolean performFinish() {
        try {
            IBusinessObject bo = this.objectSet.createBusinessObject(this.bwp.brandNameField.getText());
            this.objectSet.refresh();
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)bo.getUnderlyingFile());
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class BusinessObjectWizardPage
    extends WizardPage {
        Text brandNameField;

        public BusinessObjectWizardPage() {
            super("BusinessObjectPage", "Enter a name for the new business object", null);
            this.brandNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label brandNameLabel = new Label(comp, 0);
            brandNameLabel.setText("Busines Object Name:");
            brandNameLabel.setSize(brandNameLabel.computeSize(-1, -1));
            this.brandNameField = new Text(comp, 2052);
            this.brandNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.brandNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = BusinessObjectWizardPage.this.brandNameField.getText();
                    Iterator iterator = CreateBusinessObjectWizard.this.objectSet.getBusinessObjects().iterator();
                    while (iterator.hasNext()) {
                        if (!((IBusinessObject)iterator.next()).getName().equals(n)) continue;
                        BusinessObjectWizardPage.this.setErrorMessage("A Business Object already exists with that name.");
                        BusinessObjectWizardPage.this.setPageComplete(false);
                        return;
                    }
                    BusinessObjectWizardPage.this.setErrorMessage(null);
                    BusinessObjectWizardPage.this.setPageComplete(true);
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData brandNameLabelData = new FormData();
            brandNameLabelData.left = new FormAttachment(0, 10);
            brandNameLabelData.top = new FormAttachment(0, 30);
            brandNameLabelData.right = new FormAttachment(0, 10 + brandNameLabel.getSize().x);
            brandNameLabelData.bottom = new FormAttachment(0, 30 + brandNameLabel.getSize().y);
            brandNameLabel.setLayoutData((Object)brandNameLabelData);
            FormData brandNameFieldData = new FormData();
            brandNameFieldData.left = new FormAttachment((Control)brandNameLabel, 10);
            brandNameFieldData.top = new FormAttachment(0, 29);
            brandNameFieldData.right = new FormAttachment(100, -10);
            this.brandNameField.setLayoutData((Object)brandNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

