/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CreateDialogWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private DialogInformationPage personaInformationPage = new DialogInformationPage();
    private IConfigurationElement configElement = null;
    IContainer targetFileContainer;

    public CreateDialogWizard() {
        this.addPage((IWizardPage)this.personaInformationPage);
        System.out.println("finished constructor");
    }

    public boolean performFinish() {
        String fname = this.personaInformationPage.fileName.getText();
        if (!fname.endsWith(".dialog")) {
            fname = String.valueOf(fname) + ".dialog";
        }
        IFile newFile = this.targetFileContainer.getFile(this.targetFileContainer.getProjectRelativePath().append("/" + fname));
        try {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dialog_template.xml");
            newFile.create(in, true, null);
            System.out.println("here:" + in);
            in.close();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(newFile), "org.eclipse.vtp.desktop.editors.core.dialogeditor", true);
        }
        catch (Exception ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource resource;
        System.out.println(selection);
        System.out.println(selection.getFirstElement().getClass());
        Object sel = selection.getFirstElement();
        if (!(sel instanceof IResource)) {
            if (sel instanceof IAdaptable) {
                sel = ((IAdaptable)sel).getAdapter(IResource.class);
            } else {
                throw new RuntimeException("don't know what to do with what was selected!");
            }
        }
        if (!((resource = (IResource)sel) instanceof IContainer)) {
            resource = resource.getParent();
        }
        this.targetFileContainer = (IContainer)resource;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    private class DialogInformationPage
    extends WizardPage {
        Text dialogName;
        Text fileName;

        public DialogInformationPage() {
            super("DialogInformationPage", "Dialog Information", null);
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.makeColumnsEqualWidth = false;
            comp.setLayout((Layout)gl);
            Label nameLabel = new Label(comp, 0);
            nameLabel.setText("Dialog Name:");
            this.dialogName = new Text(comp, 2052);
            Label fileLabel = new Label(comp, 0);
            fileLabel.setText("File:");
            this.fileName = new Text(comp, 2052);
            this.fileName.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    String fname = DialogInformationPage.this.fileName.getText();
                    if (!fname.endsWith(".dialog")) {
                        fname = String.valueOf(fname) + ".dialog";
                    }
                    try {
                        boolean ok = true;
                        IResource[] memebers = ((DialogInformationPage)DialogInformationPage.this).CreateDialogWizard.this.targetFileContainer.members();
                        int i = 0;
                        while (i < memebers.length) {
                            if (memebers[i].getName().equalsIgnoreCase(fname)) {
                                DialogInformationPage.this.setPageComplete(false);
                                DialogInformationPage.this.setErrorMessage("There is already a dialog with that name.");
                                ok = false;
                            }
                            ++i;
                        }
                        if (ok) {
                            DialogInformationPage.this.setPageComplete(true);
                            DialogInformationPage.this.setErrorMessage(null);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            nameLabel.setLayoutData((Object)new GridData());
            this.dialogName.setLayoutData((Object)new GridData(768));
            fileLabel.setLayoutData((Object)new GridData());
            this.fileName.setLayoutData((Object)new GridData(768));
            this.setControl((Control)comp);
        }
    }
}

