/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.projects.core.IMediaContainer;
import org.eclipse.vtp.desktop.projects.core.IMediaFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaResource;

public class CreateMediaFolderWizard
extends Wizard {
    private IMediaContainer container = null;
    private MediaFolderWizardPage mfwp = null;

    public CreateMediaFolderWizard(IMediaContainer container) {
        this.container = container;
        this.mfwp = new MediaFolderWizardPage();
        this.addPage((IWizardPage)this.mfwp);
    }

    public boolean performFinish() {
        try {
            this.container.makeDirectory(this.mfwp.mediaFolderNameField.getText());
            this.container.refresh();
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class MediaFolderWizardPage
    extends WizardPage {
        Text mediaFolderNameField;

        public MediaFolderWizardPage() {
            super("MediaFolderPage", "Enter a name for the folder", null);
            this.mediaFolderNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label folderNameLabel = new Label(comp, 0);
            folderNameLabel.setText("Folder Name:");
            folderNameLabel.setSize(folderNameLabel.computeSize(-1, -1));
            this.mediaFolderNameField = new Text(comp, 2052);
            this.mediaFolderNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = MediaFolderWizardPage.this.mediaFolderNameField.getText();
                    Iterator iterator = null;
                    try {
                        iterator = CreateMediaFolderWizard.this.container.listMediaResources().iterator();
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                        MediaFolderWizardPage.this.setPageComplete(false);
                        MediaFolderWizardPage.this.setErrorMessage("Could not enumerate existing resources.");
                        MediaFolderWizardPage.this.mediaFolderNameField.setEnabled(false);
                    }
                    while (iterator.hasNext()) {
                        IMediaResource resource = (IMediaResource)iterator.next();
                        if (!(resource instanceof IMediaFolder) || !resource.getName().equals(n)) continue;
                        MediaFolderWizardPage.this.setErrorMessage("A folder already exists with that name.");
                        MediaFolderWizardPage.this.setPageComplete(false);
                        return;
                    }
                    MediaFolderWizardPage.this.setErrorMessage(null);
                    MediaFolderWizardPage.this.setPageComplete(true);
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData folderNameLabelData = new FormData();
            folderNameLabelData.left = new FormAttachment(0, 10);
            folderNameLabelData.top = new FormAttachment(0, 30);
            folderNameLabelData.right = new FormAttachment(0, 10 + folderNameLabel.getSize().x);
            folderNameLabelData.bottom = new FormAttachment(0, 30 + folderNameLabel.getSize().y);
            folderNameLabel.setLayoutData((Object)folderNameLabelData);
            FormData folderNameFieldData = new FormData();
            folderNameFieldData.left = new FormAttachment((Control)folderNameLabel, 10);
            folderNameFieldData.top = new FormAttachment(0, 29);
            folderNameFieldData.right = new FormAttachment(100, -10);
            this.mediaFolderNameField.setLayoutData((Object)folderNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

