/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.attraction;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.commands.BeginConnector;
import org.eclipse.vtp.desktop.editors.core.commands.Command;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.commands.StartMove;
import org.eclipse.vtp.desktop.editors.core.model.UIComponentListener;
import org.eclipse.vtp.desktop.editors.core.model.UIElement;
import org.eclipse.vtp.desktop.editors.core.theme.ElementFrame;
import org.eclipse.vtp.desktop.editors.themes.attraction.AttractionComponentFrame;

public class AttractionElementFrame
extends AttractionComponentFrame
implements ElementFrame {
    private UIElement uiElement;
    private boolean selected = false;
    private Point upperLeft;
    private Point lowerRight;
    Image icon = null;

    public AttractionElementFrame(UIElement uiElement) {
        this.uiElement = uiElement;
        uiElement.addListener((UIComponentListener)this);
        uiElement.addPropertyListener((PropertyChangeListener)this);
        this.icon = uiElement.getElement().getIcon() != null ? uiElement.getElement().getIcon() : Activator.getDefault().getImageRegistry().get("ICON_FILE");
    }

    public void alignEdge(int edge, int xy) {
        int diffX = 0;
        int diffY = 0;
        if (edge == 16384) {
            diffX = xy - this.upperLeft.x;
        } else if (edge == 128) {
            diffY = xy - this.upperLeft.y;
        } else if (edge == 131072) {
            diffX = xy - this.lowerRight.x;
        } else if (edge == 1024) {
            diffY = xy - this.lowerRight.y;
        } else {
            return;
        }
        this.adjustPosition(diffX, diffY);
        this.fireChange();
    }

    public void alignCenter(int orientation, int xy) {
        int diffX = 0;
        int diffY = 0;
        Point center = this.uiElement.getCenterPoint();
        if (orientation == 256) {
            diffY = xy - center.y;
        } else if (orientation == 512) {
            diffX = xy - center.x;
        } else {
            return;
        }
        this.adjustPosition(diffX, diffY);
        this.fireChange();
    }

    public UIElement getUIElement() {
        return this.uiElement;
    }

    public void setSize(int width, int height) {
        this.fireChange();
    }

    public void adjustPosition(int xoffset, int yoffset) {
        Point newCenter = new Point(this.uiElement.getCenterPoint().x + xoffset, this.uiElement.getCenterPoint().y + yoffset);
        this.uiElement.setCenterPoint(newCenter);
        this.upperLeft.x += xoffset;
        this.upperLeft.y += yoffset;
        this.lowerRight.x += xoffset;
        this.lowerRight.y += yoffset;
    }

    public Rectangle getBounds() {
        if (this.upperLeft == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y);
    }

    public void mouseDoubleClick(CommandListener commandListener, int x, int y, int modifiers) {
        super.mouseDoubleClick(commandListener, x, y, modifiers);
    }

    public void mouseDown(CommandListener commandListener, int x, int y, int modifiers) {
        if (this.uiElement.getElement().getConnectorRecords().size() > 0 && new Rectangle(this.lowerRight.x - 17, this.lowerRight.y - 17, 14, 14).contains(x, y)) {
            System.out.println("hot spot: begin connector");
            commandListener.executeCommand((Command)new BeginConnector());
        } else if (this.getBounds().contains(x, y)) {
            commandListener.executeCommand((Command)new StartMove());
        }
    }

    public void mouseMove(CommandListener commandListener, int x, int y, int modifiers) {
    }

    public void mouseUp(CommandListener commandListener, int x, int y, int modifiers) {
    }

    public void renderFrame(GC gc, int renderingPhase, int options, Map resourceMap) {
        Font originalFont = gc.getFont();
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        Color selectedColor = this.getColor(gc, resourceMap, "attraction.selection.color", 0, 0, 255);
        Color elementBlue = this.getColor(gc, resourceMap, "attraction.element.color", 201, 229, 255);
        Color elementGradBlue = this.getColor(gc, resourceMap, "attraction.element.color.gradient", 153, 206, 255);
        Font nameFont = this.getFont(gc, resourceMap, "attraction.element.font", "Arial", 10, 0);
        if ((options & 0x10) == 0) {
            System.err.println("Font is: " + nameFont);
            if (nameFont != null) {
                System.err.println(nameFont.getFontData()[0].getName());
                System.err.println(nameFont.getFontData()[0].getHeight());
            }
        }
        gc.setFont(nameFont);
        this.uiElement.getElement().getName();
        if (this.upperLeft == null) {
            System.out.println("^^^^^^^^^^^^^^^^Bounds not set: initializing graphics.");
            this.initializeGraphics(gc, resourceMap);
        }
        int width = this.lowerRight.x - this.upperLeft.x;
        int height = this.lowerRight.y - this.upperLeft.y;
        gc.setBackground(elementBlue);
        gc.fillRoundRectangle(this.upperLeft.x, this.upperLeft.y, width - 1, height - 1, 12, 12);
        if ((options & 0x10) == 0) {
            gc.setBackground(elementGradBlue);
            gc.fillRoundRectangle(this.upperLeft.x, this.upperLeft.y + (this.lowerRight.y - this.upperLeft.y) / 2, this.lowerRight.x - this.upperLeft.x, (this.lowerRight.y - this.upperLeft.y) / 2, 12, 12);
            gc.setForeground(elementBlue);
            gc.fillGradientRectangle(this.upperLeft.x, this.upperLeft.y + (this.lowerRight.y - this.upperLeft.y) / 3, this.lowerRight.x - this.upperLeft.x, (this.lowerRight.y - this.upperLeft.y) / 3 * 2 - 5, true);
        }
        gc.setForeground(foreground);
        gc.setBackground(background);
        if (this.uiElement.getElement().hasConnectors()) {
            gc.drawLine(this.lowerRight.x - 17, this.lowerRight.y - 10, this.lowerRight.x - 3, this.lowerRight.y - 10);
            gc.drawLine(this.lowerRight.x - 8, this.lowerRight.y - 15, this.lowerRight.x - 3, this.lowerRight.y - 10);
            gc.drawLine(this.lowerRight.x - 8, this.lowerRight.y - 5, this.lowerRight.x - 3, this.lowerRight.y - 10);
        }
        if (this.selected && (options & 2) == 0) {
            gc.setForeground(selectedColor);
        }
        gc.drawRoundRectangle(this.upperLeft.x, this.upperLeft.y, width - 1, height - 1, 12, 12);
        if ((options & 4) == 0) {
            gc.drawImage(this.icon, this.upperLeft.x + 10, this.upperLeft.y + 12);
        }
        int curX = this.upperLeft.x + 30;
        int curY = this.upperLeft.y + 15;
        String[] parts = this.getUIElement().getElement().getName().split(" ");
        Point stringExtent = gc.stringExtent(parts[0]);
        int ew = stringExtent.x;
        gc.drawString(parts[0], curX, curY, true);
        curX += stringExtent.x;
        int i = 1;
        while (i < parts.length) {
            stringExtent = gc.stringExtent(" " + parts[i]);
            boolean wrapped = false;
            if (ew + stringExtent.x > 110) {
                stringExtent = gc.stringExtent(parts[i]);
                ew = stringExtent.x;
                curY += 3 + stringExtent.y;
                curX = this.upperLeft.x + 30;
                wrapped = true;
            } else {
                ew += stringExtent.x;
            }
            gc.drawString(String.valueOf(wrapped ? "" : " ") + parts[i], curX, curY, true);
            curX += stringExtent.x;
            ++i;
        }
        if (this.selected) {
            gc.setForeground(foreground);
        }
        gc.setFont(originalFont);
        if ((options & 8) == 0) {
            if (this.uiElement.getElement().hasErrors()) {
                gc.drawImage(Activator.getDefault().getImageRegistry().get("ICON_ERROR"), this.lowerRight.x - 17, this.upperLeft.y);
            } else if (this.uiElement.getElement().hasWarnings()) {
                gc.drawImage(Activator.getDefault().getImageRegistry().get("ICON_WARNING"), this.lowerRight.x - 16, this.upperLeft.y);
            } else if (this.uiElement.getElement().hasTodo()) {
                gc.drawImage(Activator.getDefault().getImageRegistry().get("ICON_TASK"), this.lowerRight.x - 18, this.upperLeft.y + 2);
            }
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean touchesComponent(int x, int y) {
        if (this.upperLeft == null) {
            return false;
        }
        return new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y).contains(x, y);
    }

    public boolean touchesElement(Rectangle rect) {
        if (this.upperLeft == null) {
            return false;
        }
        return new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y).intersects(rect);
    }

    public Point getIncursionPoint(int x, int y) {
        if (this.upperLeft == null || this.lowerRight == null) {
            return null;
        }
        Point p1 = new Point(x, y);
        Point p2 = new Point(this.uiElement.getCenterPoint().x, this.uiElement.getCenterPoint().y);
        Point ret = this.getIntersection(p1, p2, new Point(this.upperLeft.x, this.upperLeft.y), new Point(this.lowerRight.x, this.upperLeft.y));
        if (ret == null) {
            ret = this.getIntersection(p1, p2, new Point(this.lowerRight.x, this.upperLeft.y), new Point(this.lowerRight.x, this.lowerRight.y));
        }
        if (ret == null) {
            ret = this.getIntersection(p1, p2, new Point(this.upperLeft.x, this.upperLeft.y), new Point(this.upperLeft.x, this.lowerRight.y));
        }
        if (ret == null) {
            ret = this.getIntersection(p1, p2, new Point(this.upperLeft.x, this.lowerRight.y), new Point(this.lowerRight.x, this.lowerRight.y));
        }
        return ret;
    }

    protected Point getIntersection(Point p1, Point p2, Point p3, Point p4) {
        double x1 = p1.x;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        double x3 = p3.x;
        double y3 = p3.y;
        double x4 = p4.x;
        double y4 = p4.y;
        double uan = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        double ud = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (ud == 0.0) {
            return null;
        }
        double ua = uan / ud;
        double ubn = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
        double ub = ubn / ud;
        if (ua <= 0.0 || ua >= 1.0 || ub <= 0.0 || ub >= 1.0) {
            return null;
        }
        double ix = x1 + ua * (x2 - x1);
        double iy = y1 + ua * (y2 - y1);
        return new Point((int)ix, (int)iy);
    }

    public void initializeGraphics(GC gc, Map resourceMap) {
        Font originalFont = gc.getFont();
        Font nameFont = new Font(gc.getDevice(), "Arial", 10, 0);
        System.err.println("Font init is: " + nameFont);
        System.err.println(nameFont.getFontData()[0].getName());
        System.err.println(nameFont.getFontData()[0].getHeight());
        gc.setFont(nameFont);
        System.err.println("#0# font.name = " + gc.getFont().getFontData()[0].getName());
        System.err.println("#0# font.height = " + gc.getFont().getFontData()[0].getHeight());
        System.err.println("#0# 'a'.stringExtent.x = " + gc.stringExtent((String)"a").x);
        System.err.println("#0# 'is'.stringExtent.x = " + gc.stringExtent((String)"is").x);
        System.err.println("#0# 'the'.stringExtent.x = " + gc.stringExtent((String)"the").x);
        System.err.println("#0# ' '.stringExtent.x = " + gc.stringExtent((String)" ").x);
        System.err.println("#0# ' a'.stringExtent.x = " + gc.stringExtent((String)" a").x);
        System.err.println("#0# ' is'.stringExtent.x = " + gc.stringExtent((String)" is").x);
        System.err.println("#0# ' the'.stringExtent.x = " + gc.stringExtent((String)" the").x);
        System.err.println("#0# 'a'.stringExtent.x = " + gc.stringExtent((String)"a").x);
        System.err.println("#0# 'is'.stringExtent.x = " + gc.stringExtent((String)"is").x);
        System.err.println("#0# 'the'.stringExtent.x = " + gc.stringExtent((String)"the").x);
        System.err.println("#0# ' '.stringExtent.x = " + gc.stringExtent((String)" ").x);
        System.err.println("#0# ' a'.stringExtent.x = " + gc.stringExtent((String)" a").x);
        System.err.println("#0# ' is'.stringExtent.x = " + gc.stringExtent((String)" is").x);
        System.err.println("#0# ' the'.stringExtent.x = " + gc.stringExtent((String)" the").x);
        Point extent = gc.stringExtent(this.getUIElement().getElement().getName());
        if (extent.x > 110) {
            extent.x = 0;
            String[] parts = this.getUIElement().getElement().getName().split(" ");
            Point stringExtent = gc.stringExtent(parts[0]);
            int ew = 0;
            ew += stringExtent.x;
            extent.x = stringExtent.x;
            System.err.println("#1# parts[0] = " + parts[0]);
            System.err.println("#1# Extent X = " + extent.x);
            System.err.println("#1# Extent Y = " + extent.y);
            int i = 1;
            while (i < parts.length) {
                stringExtent = gc.stringExtent(" " + parts[i]);
                System.err.println("#2# parts[" + i + "] = " + parts[i]);
                System.err.println("#2# ew = " + ew);
                System.err.println("#2# stringExtent.x = " + stringExtent.x);
                if (ew + stringExtent.x > 110) {
                    stringExtent = gc.stringExtent(parts[i]);
                    if (extent.x < ew) {
                        extent.x = ew;
                    }
                    ew = stringExtent.x;
                    extent.y += 3 + stringExtent.y;
                    System.err.println("#2# Extent X = " + extent.x);
                    System.err.println("#2# Extent Y = " + extent.y);
                } else {
                    ew += stringExtent.x;
                }
                ++i;
            }
            if (extent.x < ew) {
                extent.x = ew;
            }
        }
        System.err.println("#3# Extent X = " + extent.x);
        System.err.println("#3# Extent Y = " + extent.y);
        System.out.println("Block: " + this.getUIElement().getElement().getName() + " extent: " + extent);
        int width = extent.x + 50;
        int height = extent.y + 30;
        Point centerPoint = this.uiElement.getCenterPoint();
        this.upperLeft = new Point(centerPoint.x - width / 2, centerPoint.y - height / 2);
        int buffer = width % 2;
        this.lowerRight = new Point(this.upperLeft.x + width + buffer, this.upperLeft.y + height + buffer);
        gc.setFont(originalFont);
        nameFont.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("model.element.name".equals(event.getPropertyName())) {
            System.out.println("Element name changed: " + event.getOldValue() + " -> " + event.getNewValue());
            this.upperLeft = null;
            this.fireRepaintRequest();
        } else {
            super.propertyChange(event);
        }
    }
}

